<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use TorMorten\Eventy\Facades\Events as Eventy;

class ThemesController extends Controller
{
    public $categories      = array('count' => 0);
    public $themescount = 0;
    protected $available    = array();
    protected $activated    = array();
    private $headers        = array(
		'name'        => 'Theme Name',
		'website'     => 'Theme URI',
		'version'     => 'Version',
		'requires'    => 'Requires',
		'description' => 'Description',
		'author'      => 'Author',
		'authoruri'   => 'Author URI',
		'category'    => 'Category',
    );
    
    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->paginate = 20;
    }

    public function index_backupexport($optionname, Request $request)
    {
        if(!is_permission('theme_options')){
            return parent::admin_handle_permission('theme_options');
        }
        $content = get_option($optionname);
        $fileName = "backup-{$optionname}-".date('d-m-Y').".txt";
        $headers = [
            'Content-type' => 'text/plain', 
            'Content-Disposition' => sprintf('attachment; filename="%s"', $fileName),
            'Content-Length' => strlen($content)
        ];
        return response()->make($content, 200, $headers);
    }

    public function index_backupimport($optionname, Request $request)
    {
        if(!is_permission('theme_options')){
            return parent::admin_handle_permission('theme_options');
        }
        $content = get_option($optionname);
        $fileName = "backup-{$optionname}-".date('d-m-Y').".txt";
        $headers = [
            'Content-type' => 'text/plain', 
            'Content-Disposition' => sprintf('attachment; filename="%s"', $fileName),
            'Content-Length' => strlen($content)
        ];
        return response()->make($content, 200, $headers);
    }


    public function index_themeoptions(Request $request)
    {
        if(!is_permission('theme_options')){
            return parent::admin_handle_permission('theme_options');
        }
        $data['page_title'] = admin_lang('theme_options');
        $data['page_class'] = 'themes';
        return get_admin_view('themes.index_themeoptions', $data);
    }

    public function themeoptions_sendform(Request $request)
    {
        if(!is_permission('theme_options')){
            return parent::admin_handle_permission('theme_options');
        }
        Eventy::action('admin_theme_options_save', $request);
        return redirect()->back()->with("success", admin_lang('settings_saved_successfully'));
    }

    public function index_themes(Request $request)
    {
        if(!is_permission('themes')){
            return parent::admin_handle_permission('themes');
        }
        $data['page_title'] = admin_lang('themes');
        $data['page_class'] = 'themes';
        $fetched_themes = $this->fetch();
        $data['fetched_themes'] = $fetched_themes;
        return get_admin_view('themes.index_themes', $data);
    }

    public function load()
    {
		return $this->activated = (is_serialized(get_option('start_themes')))? maybe_unserialize(get_option('start_themes')) : array() ;
	}
    
    public function fetch()
    {
		$themes = glob( resource_path('views/frontend') . '/*', GLOB_ONLYDIR );
        if ( ! empty( $themes ) ):
			$this->load();
		endif;
		foreach ( $themes as $theme ):
			$slug = basename( $theme );
			$file = $theme . '/options.php';
			if ( file_exists( $file ) ):
                $this->themescount ++;
                $headers                    = $this->get_file_data( $file, $this->headers );
                $headers['slug']        = $slug;
				$headers['compatible']      = version_compare( $headers['requires'], SCRIPT_VERSION, '<=' );
				$headers['activated']       = $headers['compatible'] && get_option('theme', 'default') == $slug;
				$headers['basename']        = $slug . '/options.php';
                $headers['screenshot']      = url(env('APP_ROOT_PAHT').'/resources/views/frontend/' . $slug . '/screenshot.png');
				$this->available[ $slug ]   = $headers;
			endif;
		endforeach;
		return $this->available;
    }

    public function get_file_data( $file, $default_headers)
    {
        $fp        = fopen( $file, 'r' );
        $file_data = fread( $fp, 8192 );
        fclose( $fp );
        $file_data = str_replace( "\r", "\n", $file_data );
        $all_headers = $default_headers;
        foreach ( $all_headers as $field => $regex ) {
            if ( preg_match( '/^[ \t\/*#@]*' . preg_quote( $regex, '/' ) . ':(.*)$/mi', $file_data, $match ) && $match[1] )
                $all_headers[ $field ] = cleanup_header_comment( $match[1] );
            else
                $all_headers[ $field ] = '';
        }
        return $all_headers;
    }

    public function index_themes_action($action , $theme, $token, Request $request)
    {
        if(!is_permission('themes')){
            return parent::admin_handle_permission('themes');
        }
        if($action == 'activate'){
            update_option('theme', $theme);
            return redirect(get_admin_url('themes'))->with("success", admin_lang('msg_theme_activate'));
        }
        else {
            return redirect(get_admin_url('themes'));
        }
    }
    
}
