<?php
/**
 * Extension Name: KnowledgeBase
 * Extension URI: http://themearabia.net/extension/knowledgebase
 * Version: 3.0
 * Requires: 5.0
 * Description: knowledge base
 * Author: Themearabia
 * Author URI: http://themearabia.net
 */

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class KnowledgebaseController extends Controller
{

    private $type;
    private $url;
    public function __construct()
    {
        parent::__construct();
        $this->type         = 'knowledgebase';
        $this->url          = url('kb');
        $default_options    = [
            "template"              => "template1",
            "column"                => "col-md-4",
            "post_per_page"         => "6",
            "style"                 => "full",
            "single_style"          => "full",
            "cate_per_page"         => "10",
            "widget_search"         => false,
            "search_text"           => '',
            "widget_categories"     => false,
            "widget_recent"         => false,
            "post_per_recent"       => "3",
            "meta_author"           => false,
            "meta_date"             => false,
            "meta_comments"         => false,
            "meta_views"            => false,
            "meta_cate"             => false,
            "meta_shareit"          => false,
        ];
        $options        = maybe_unserialize(site_config('options_knowledgebase'));
        $this->options  = mega_parse_args($options, $default_options);
    }
    
    // knowledgebase
    public function knowledgebase($slug = false, Request $request)
    {
        if(!is_extensions('knowledgebase')){
            return redirect(url('/'));
        }

        foreach($this->options as $key => $option){
            $data['kb_'.$key] = $option;
        }

        $data['post_type']      = $this->type;
        $this->paginate = $this->options['cate_per_page'];

        if($request->has('search')){
            $search = safe_input($request->get('search'));
            $data['the_term_id']    = '';
            $data['the_cate_name']  = lang('search').': '.$search;
            $data['sub_header']     = extension_lang('knowledgebase', 'knowledgebase');
            $data['page_title']     = extension_lang('knowledgebase', 'knowledgebase');
            $data['breadcrumbs'][]  = ['link' => url('kb'), 'title' => extension_lang('knowledgebase', 'knowledgebase')];
            $data['breadcrumbs'][]  = ['link' => false, 'title' => lang('search').': '.$search];

            $posts = DB::table('posts')
            ->leftJoin('users', function ($join) {$join->on('users.id', '=', 'posts.post_author');})
            ->leftJoin('terms', function ($join) {$join->on('terms.id', '=', 'posts.term_id');})
            ->selectRaw(
                db_select_column_as('posts', 'post_title').
                db_select_column_as('posts', 'post_name').
                db_select_column_as('posts', 'id', 'post_id').
                db_select_column_as('posts', 'post_modified').
                db_select_column_as('posts', 'post_views').
                db_select_column_as('terms', 'slug').
                db_select_column_as('terms', 'name').
                db_select_column_as('users', 'username').
                db_select_column_as('users', 'id', 'author', '')
            )
            ->where(['post_status' => '1', 'post_type' => $this->type])
            ->where('post_title', 'like', "%$search%")
            ->orderBy('post_pin', 'desc')
            ->orderBy('post_orders', 'asc')
            ->orderBy('post_modified', 'desc')
            ->paginate($this->paginate);

            $posts->appends(['search' => $search]);
            if ($request->has('page') and $request->get('page') > $posts->lastPage()) {return redirect($posts->url($posts->lastPage()));}

            $data['posts'] = $posts;
            $data = mega_parse_args($data, $this->get_widgets());
            return get_view('knowledgebase.category_knowledgebase', $data);

        }
        else{
            $data['sub_header']     = extension_lang('knowledgebase', 'knowledgebase');
            $data['page_title']     = extension_lang('knowledgebase', 'knowledgebase');
            $data['breadcrumbs'][]  = ['link' => false, 'title' => extension_lang('knowledgebase', 'knowledgebase')];
            $data['categories']     = DB::table(TERMS_TABLE)->leftJoin('posts', 'posts.term_id', '=', 'terms.id')
            ->selectRaw(
                db_select_column_as('terms', 'id').
                db_select_column_as('terms', 'slug').
                db_select_column_as('terms', 'name').
                db_select_column_as('terms', 'description').
                db_select_column_as('terms', 'image').
                db_select_column_as_count('posts', 'id', 'posts_count', '')
            )
            ->where('type', 'knowledgebase')
            ->where('post_type', 'knowledgebase')
            ->groupBy('posts.term_id')->orderBy('orders', 'ASC')
            ->get();

            return get_view('knowledgebase.knowledgebase', $data);
        }

        
    }

    // category
    public function category($slug, Request $request)
    {
        if(!is_extensions('knowledgebase')){
            return redirect(url('/'));
        }

        $slug = utf8_uri_encode($slug);
        $term = get_term_by_slug($slug, $this->type);
        if ($term->count()) {

            $this->paginate = $this->options['cate_per_page'];
            foreach($this->options as $key => $option){
                $data['kb_'.$key] = $option;
            }

            $get_term = $term->first();
            $data['the_term_id']    = $get_term->id;
            $data['the_cate_name']  = $get_term->name;
            $data['post_type']      = $this->type;
            $data['sub_header']     = extension_lang('knowledgebase', 'knowledgebase');
            $data['page_title']     = extension_lang('knowledgebase', 'knowledgebase').' - '.$get_term->name;
            $data['breadcrumbs'][]  = ['link' => url('kb'), 'title' => extension_lang('knowledgebase', 'knowledgebase')];
            $data['breadcrumbs'][]  = ['link' => false, 'title' => $get_term->name];

            $posts = DB::table(POSTS_TABLE)
            ->leftJoin('users', function ($join) {$join->on('users.id', '=', 'posts.post_author');})
            ->leftJoin('terms', function ($join) {$join->on('terms.id', '=', 'posts.term_id');})
            ->selectRaw(
                db_select_column_as('posts', 'post_title').
                db_select_column_as('posts', 'post_name').
                db_select_column_as('posts', 'id', 'post_id').
                db_select_column_as('posts', 'post_modified').
                db_select_column_as('posts', 'post_views').
                db_select_column_as('posts', 'post_type').
                db_select_column_as('terms', 'slug').
                db_select_column_as('terms', 'name').
                db_select_column_as('users', 'username').
                db_select_column_as('users', 'id', 'author', '')
            )
            ->where(['post_status' => '1', 'post_type' => $this->type, 'term_id' => $get_term->id])
            ->orderBy('post_pin', 'desc')
            ->orderBy('post_orders', 'asc')
            ->orderBy('post_modified', 'desc')
            ->paginate($this->paginate);

            if ($request->has('page') and $request->get('page') > $posts->lastPage()) {return redirect($posts->url($posts->lastPage()));}

            $data['posts'] = $posts;

            $data = mega_parse_args($data, $this->get_widgets());

            return get_view('knowledgebase.category_knowledgebase', $data);
        }
        else {
            return redirect($this->url);
        }

    }

    // single
    public function single($slug, Request $request)
    {
        if(!is_extensions('knowledgebase')){
            return redirect(url('/'));
        }

        $slug = utf8_uri_encode($slug);
        $post = DB::table(POSTS_TABLE)->where(['post_status' => '1', 'post_type' => $this->type, 'post_name' => $slug])->get();
        if ($post->count()) {
            
            foreach($this->options as $key => $option){
                $data['kb_'.$key] = $option;
            }
    
            $single     = $post->first();
            $views      = $single->post_views+1;
            DB::table(POSTS_TABLE)->where('id', $single->id)->update(['post_views' => $views]);
            $data['the_term_id']    = $single->term_id;
            $data['single']         = $single;
            $data['page_title']     = $single->post_title;
            $data['sub_header']     = $single->post_title;
            $data['post_type']      = $this->type;
            $data['breadcrumbs'][]  = ['link' => url('kb'), 'title' => extension_lang('knowledgebase', 'knowledgebase')];
            $data['breadcrumbs'][]  = ['link' => url('kbc/'.get_term_slug($single->term_id)), 'title' => get_term_name($single->term_id)];
            $data['breadcrumbs'][]  = ['link' => false, 'title' => $single->post_title];
            $data['post_meta']      = query_posts_meta($single->id);
            $data['description']    = $data['post_meta']['meta_desc'];
            $data['keywords']       = $single->post_tags;
            
            $comments               = get_loop_comments_single($single->post_type, $single->id, $request);
            $data['comments']       = $comments;

            $data = mega_parse_args($data, $this->get_widgets());
            return get_view('knowledgebase.single_knowledgebase', $data);

        }
        else {
            return redirect($this->url);
        }
    }

    public function get_widgets()
    {
        $data['categories'] = DB::table('terms')
        ->leftJoin('posts', 'posts'.'.term_id', '=', 'terms'.'.id')
        ->selectRaw(
            db_select_column_as('terms', 'name').
            db_select_column_as('terms', 'slug').
            db_select_column_as('terms', 'id').
            db_select_column_as_count('posts', 'id', 'posts_count', '')
        )
        ->where(['type' => $this->type, 'status' => '1', 'post_status' => '1', 'post_type' => $this->type])
        ->groupBy('posts'.'.term_id')->orderBy('orders', 'asc')->get();

        $data['kb_recent'] = DB::table(POSTS_TABLE)
        ->where(['post_status' => '1', 'post_type' => $this->type])
        ->orderBy('post_modified', 'desc')
        ->limit($this->options['post_per_recent'])
        ->get();

        return $data;
    }
}
