<?php
/**
 * Extension Name: Testimonials
 * Extension URI: http://themearabia.net/extension/testimonials
 * Version: 2.0
 * Requires: 5.0
 * Description: Testimonials
 * Author: Themearabia
 * Author URI: http://themearabia.net
 */

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use hisorange\BrowserDetect\Parser as Browser;

class TestimonialsController extends Controller
{
    private $type;
    private $url;

    public function __construct()
    {
        parent::__construct();
        $this->type         = 'testimonials';
        $this->url          = url('testimonials');
        $default_options    = [
            "style"         => "full",
            "post_per_page" => "6",
            "column"        => "col-md-4",
            "form_status"   => false,
            "form_title"    => "",
            "avatar"        => get_asset('images/avatar.jpg'),
        ];
        $options        = maybe_unserialize(site_config('options_testimonials'));
        $this->options  = mega_parse_args($options, $default_options);
    }
    
    // Index Home
    public function testimonials(Request $request)
    {
        if(!is_extensions('testimonials')){
            return redirect(url('/'));
        }
        foreach($this->options as $key => $option){
            $data['testimonials_'.$key] = $option;
        }
        $this->paginate = $this->options['post_per_page'];
        $testimonials = $this->get_query()->paginate($this->paginate);
        if ($request->get('page') > $testimonials->lastPage()) {return redirect($testimonials->url($testimonials->lastPage()));}
        $data['testimonials']   = $testimonials;
        $data['sub_header']     = extension_lang('testimonials', 'testimonials');
        $data['page_title']     = extension_lang('testimonials', 'testimonials');
        $data['breadcrumbs'][]  = ['link' => false, 'title' => extension_lang('testimonials', 'testimonials')];
        return get_view('testimonials.testimonials', $data);
    }

    // submit Reply
    public function submit_rating(Request $request)
    {
        $this->validate(
            $request,
            [
                'username'  => 'required',
                'rating'    => 'required',
                'message'   => 'required',
            ],
            [
                'username.required' => extension_lang('testimonials', 'username_required'),
                'rating.required' => extension_lang('testimonials', 'rating_required'),
                'message.required' => extension_lang('testimonials', 'message_required'),
            ]
        );
        
        $user = Auth::user();
        $browser_detect = [
            'ip'                => GetRealIp(),
            'useragent'         => Browser::userAgent(),
            'platformname'      => Browser::platformName(),
            'platformfamily'    => Browser::platformFamily(),
            'browserfamily'     => Browser::browserFamily(),
        ];


        $post_id = DB::table(POSTS_TABLE)->insertGetId([
            'post_title'    => safe_input($request->get('username')),
            'post_content'  => safe_input($request->get('message')),
            'post_type'     => $this->type,
            'post_orders'   => get_posts_count($this->type, 1),
            'post_status'   => '0'
        ]);

        update_post_meta('position', '', $post_id);
        update_post_meta('rating', safe_input($request->get('rating')), $post_id); 
        return redirect()->back()->with('success', extension_lang('testimonials', 'rating_successfully'));
    }

    // get query
    public function get_query()
    {
        $query = DB::table('posts')
        ->leftJoin('postsmeta as thumbnails', function ($join) {$join->on('thumbnails.post_id', '=', 'posts.id')->where('thumbnails.meta_key', '=', 'thumbnails');})
        ->leftJoin('postsmeta as position', function ($join) {$join->on('position.post_id', '=', 'posts.id')->where('position.meta_key', '=', 'position');})
        ->leftJoin('postsmeta as rating', function ($join) {$join->on('rating.post_id', '=', 'posts.id')->where('rating.meta_key', '=', 'rating');})
        ->selectRaw(
            db_select_column_as('posts', 'post_title').
            db_select_column_as('posts', 'post_content').
            db_select_column_as('posts', 'id').
            db_select_column_as('position', 'meta_value', 'position').
            db_select_column_as('rating', 'meta_value', 'rating').
            db_select_column_as('thumbnails', 'meta_value', 'thumbnail', '')
        )
        ->where(['post_type' => $this->type, 'post_status' => '1'])
        ->orderBy('post_modified', 'DESC');
        return $query;
    }
}