<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;


class UsersController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        parent::__construct();   
    }

    // singin
    public function profile(Request $request)
    {
        $user = Auth::user();
        $user_id = $user->id;
        if ($request->has('username') && $request->has('email')) {
            
            $rules = [
                'username'  => 'required|unique:users,username,'.$user_id,
                'email'     => 'required|email|unique:users,email,'.$user_id,
            ];

            $messages = [
                'username.required' => lang('error_username_required'),
                'username.unique'   => lang('error_username_unique'),
                'email.required'    => lang('error_email_required'),
                'email.unique'      => lang('error_email_unique'),
                'email.email'       => lang('error_email_correct')
            ];

            if($request->has('password') and $request->get('password')){
                $rules = ['password' => 'required|confirmed'];
                $messages = [
                    'password.required'     => lang('error_password_required'),
                    'password.confirmed'    => lang('error_password_confirmed')
                ];
            }
            $this->validate($request, $rules, $messages);
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update([
                'username'      => safe_input($request->get('username')),
                'email'         => safe_input($request->get('email')),
                'updated_at'    => now(),
            ]);

            if($request->has('password') and $request->get('password')){
                DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['password' => Hash::make($request->get('password'))]);
                update_user_meta('updated_password', time(), $user->id);
            }
            

            return redirect(url('profile'))->with(['success' => lang('msg_update_profile')]);

        }
        else {
            $data['page_title'] = lang('profile');
            $data['sub_header'] = lang('profile');
            $data['profile_class'] = 'class="active"';
            $data['change_password_class'] = '';
            $data['breadcrumbs'][] = ['link' => false, 'title' => lang('profile')];
            return get_view('users.profile', $data);
        }
    }

}
