<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeceasedCorrection extends Model
{
    protected $table="deceased_master_correction";
    use HasFactory;
    protected $fillable=[
        "deceased_id",
        "deceased_name",
        "deceased_father_husband_name",
        "deceased_surname",
        "deceased_surname_gj",
        "deceased_name_gj",
        "deceased_father_husband_name_gj",
        "death_date",
        "dafan_date",
        "place_death",
        "reason_death",
        "birth_date",
        "age",
        "identity_proof",
        "identity_proof_file",
        "hospital_letter_file",
        "address1",
        "address2",
        "address3",
        "city_id",
        "state_id",
        "area_id",
        "country_id",
        "pincode", 
        "created_by",
        "updated_by"
      ];

      public function areainfo()
      {
          //first id should be relationship table and another id is dependent table 
          return $this->hasOne(Area::class ,'area_id', 'id');
      }
      public function cityinfo()
      {
          return $this->hasOne(City::class ,'city_id', 'id');
      }
      public function stateinfo()
      {
          return $this->hasOne(State::class ,'state_id', 'id');
      }
      public function countryinfo()
      {
          return $this->hasOne(State::class ,'country_id', 'id');
      }
   

}
