<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Models\DeceasedInformer;
class File extends Model{

protected $table="deceased_master";
private $deceasedpath="public/Deceasedfiles";
private $informerdpath="public/Informerfiles";

protected $fillable =[
'identity_proof_file',
'hospital_letter_file',
];

public function uploadDeceasedFile(Request $request){
     
      //files stored
     
      $date=date('Y-m-d');
      $identity_proof_file_name =$date .$request->file('identity_proof_file')->getClientOriginalName();
      $hospital_letter_file_name=$date .$request->file('hospital_letter_file')->getClientOriginalName();
      $status_file1= $request->file('identity_proof_file')->move($this->deceasedpath,$identity_proof_file_name);
      $status_file2= $request->file('hospital_letter_file')->move($this->deceasedpath,$hospital_letter_file_name);
      $file=new File();
      $file->identity_proof_file= $identity_proof_file_name;
      $file->hospital_letter_file= $hospital_letter_file_name;
      $file->save();
      if(($status_file1) && ($status_file2)){
         return true;
     }else{
         return false;
     }

}

public function uploadInformerFile(Request $request){
     
    //files stored informer file
   
    $date=date('Y-m-d');
    $informer_id_proof_file_name =$date .$request->file('informer_id_proof_file')->getClientOriginalName();
    $status_file1= $request->file('identity_proof_file')->move($this->informerdpath,$informer_id_proof_file_name);
    $informer=new DeceasedInformer();
    $informer->identity_proof_file= $informer_id_proof_file_name;
    $informer->save();
    if($status_file1){
       return true;
   }else{
       return false;
   }

}


}

?>