<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
class State extends Model
{
    use HasFactory, Notifiable;

    public function country()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(Country::class ,'id', 'country_id');
    }
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $table="state_master";
    protected $fillable = [
        'country_id',
        'state_name',
        'state_name_gj',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
 
}
