<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeceasedMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deceased_master', function (Blueprint $table) {
            $table->bigIncrements('id'); 
            $table->bigInteger('entry_no')->nullable();
            $table->bigInteger('graveyard_book_no')->nullable();
            $table->bigInteger('graveyard_receipt_no')->nullable();
            $table->bigInteger('deceased_identity')->nullable();
            $table->string('graveyard_receipt')->nullable();
            $table->string('deceased_name')->nullable();
            $table->string('deceased_surname')->nullable();
            $table->string('deceased_father_husband_name')->nullable();
            $table->string('deceased_name_gj')->nullable();
            $table->string('deceased_surname_gj')->nullable();
            $table->string('deceased_father_husband_name_gj')->nullable();
            $table->string('deceased_other_name')->nullable();
            $table->enum('gender', array('Male', 'Female'))->nullable();
            $table->date('birth_date')->nullable();
            $table->integer('age')->nullable();
            $table->string('photo')->nullable();
            $table->enum('identity_proof', array('Aadhar Card','Voting Card','Passport Copy'))->nullable();
            $table->string('identity_proof_file')->nullable();
            $table->enum('place_death', array('hospital', 'home'))->nullable();
            $table->integer('reason_death')->nullable();
            $table->string('hospital_letter_file')->nullable();
            $table->enum('is_postmortem', array('Yes', 'No'))->nullable();
            $table->string('postmortem_fileno')->nullable();
            $table->timestamp('postmortem_date')->nullable();
            $table->string('postmortem_file')->nullable();
            $table->integer('graveyard_id')->nullable();
            $table->timestamp('death_date')->nullable();
            $table->timestamp('dafan_date')->nullable();
            $table->double('digging_charge', 15, 8)->nullable();
            $table->double('graveyard_charge', 15, 8)->nullable();
            $table->double('death_certificate_charge', 15, 8)->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deceased_master');
    }
}
