
(function() {

    // Icon
    ArticleEditor.iconmedialibrary = '<span class="arx-popup-item-icon arx-icon-image"></span>';

    // Block
    ArticleEditor.add('block', 'block.medialibrary', {
        mixins: ['block'],
        type: 'medialibrary',
        parser: {
            tag: 'div',
            parse: function($el) {
                return ($el.hasClass('medialibrary')) ? 'medialibrary' : false;
            }
        },
        create: function() {
            return this.dom('<div>').addClass('medialibrary');
        }
    });

    // Plugin
    ArticleEditor.add('plugin', 'medialibrary', {
        translations: {
            en: {
                "medialibrary": {
                    "medialibrary": "Media Library",
                }
            },
            ar: {
                "medialibrary": {
                    "medialibrary": "مكتبة الوسائط",
                }
            }
        },
        defaults: {
            classname: 'img-fluid'
        },
        init: function() {
            this.insertion = this.app.create('insertion');
        },
        start: function() {
            this.app.addbar.add('medialibrary', {
                title: '## medialibrary.medialibrary ##',
                icon: ArticleEditor.iconmedialibrary,
                command: 'medialibrary.popup'
            });
        },
        popup: function() {
            this.app.popup.close();
            this.imageslen = 0, this.imagescount = 0;
            var $this = this,
                tbwidth = $(window).width() - 160, 
                tbheight = $(window).height() - 100;
            tb_show('tbshow_title', media_upload_url+'?type=image&tab=library&TB_iframe=true&height='+tbheight+'&width='+tbwidth+'');
            //this.app.utils.getRandomId()
            window.send_to_editor = function(data) {
                tb_remove();
                var appblock = $this.app.block,
                image_tag = $this.opts.image.tag,
                image_dom = $this.dom('<' + image_tag + '>'),
                image_create = $this.app.create('block.image', image_dom);                
                var response = {
                    "url": data['file'],
                    "id": data['fileid']
                };
                image_item = $this._createImageFromResponseItem(response);
                image_dom.append(image_item);
                appblock.add({'instance': image_create,'type': 'image'});
            }
        },
        '_createImageFromResponseItem': function (response) {
            var image_item = this.dom('<img>').attr('src', response.url).one('load', this._checkImageLoad.bind(this));
            return Object.prototype.hasOwnProperty.call(response, 'id') && image_item.attr('data-image', response.id), Object.prototype.hasOwnProperty.call(response, '2x') && image_item.attr('srcset', response['2x'] + ' 2x'), image_item;
        },
        '_checkImageLoad': function () {
            this.imagescount++, this.imagescount === this.imageslen && (this.app.block.unset(), this.app.block.set(this.$last), this.app.editor.adjustHeight());
        },
    });
})(ArticleEditor);