$(document).ready(function () {

	$('#button-menus-select').on('click', function(){
		var selectid = $('#menus-select').val();
		if(selectid){
			window.location.replace(menuediturl+selectid);
		}
		else {
			window.location.replace(menuediturl);
		}
		
	});

	$('ul#menu-to-edit').nestedSortable({
		forcePlaceholderSize: true,
		maxLevels: 2,
		tabSize: 42,
		opacity: .8,
		listType: 'ul',
		handle: 'div.menu-item-handle',
		rtl: is_rtl,
		items: 'li',
		placeholder: {
			element: function (currentItem) {
				return jQuery("<li style='border: 1px dashed #ccc;height: 42px;width:320px;'>&nbsp;</li>")[0];
			},
			update: function (container, p) {
				return;
			},
		},
		change: function (event, ui) {

		},
		sort: function (event, ui) {

		},
		stop: function (event, ui) {

		},
		update: function (event, ui) {

		}
	}).disableSelection();

	jQuery(document).on('keyup', '.menu-title', function () {
		var menuid = $(this).attr('data-id');
		var title = $(this).val();
		$('.menu-title-' + menuid).html(title);
	});
	jQuery(document).on('keyup', '.menu-icons', function () {
		var icon = $(this).val();
		$(this).parent().find('.preview-icon').html('<i class="' + icon + '"></i>');
	});
	jQuery(document).on('click', '.item-menu-edit', function () {
		var menuid = $(this).attr('data-id');
		if ($('#menu-item-' + menuid).hasClass("menu-open")) {
			$('#menu-item-' + menuid).removeClass('menu-open');
			$('.menu-open-' + menuid).val('0');
		} else {
			$('#menu-item-' + menuid).addClass('menu-open');
			$('.menu-open-' + menuid).val('1');
		}
	});
	jQuery(document).on('click', '.menu-submitdelete', function () {
		var menuid = $(this).attr('data-id');
		$('#menu-item-' + menuid).remove();
	});

	$('body').on('click', "#save_menu_header", function () {
		serialized = $('ul#menu-to-edit').nestedSortable('serialize'); // serialize , toArray , toHierarchy
		serialized += '&action=savemenuitem';
		$.ajax({
            type: 'POST',
            url: admin_ajax_url,
            data: serialized,
            success: function (data) {
				$('input#menu_item_map').val(data);
				$('form#menu-form-edit').submit();
            }
		});
	});
	
	$('.submit-add-custom-link-to-menu').click(function () {
		var Button = $(this),
			Buttonhtml = Button.html(),
			menuadd = 0,
			link_url = $('#custom_links_url'),
			link_title = $('#custom_links_title'),
			menu_item_count = $('#menu_item_count').val();
		if (link_url.val().length >= 1 && link_title.val().length >= 1) {
			Button.prop('disabled', true);
			Button.html('<i class="fas fa-circle-notch fa-spin fa-fw"></i> ' + Buttonhtml);
			menu_item_count++;
			$.ajax({
				type: 'POST',
				url: admin_ajax_url,
				data: 'action=addmenuitem&type=Custom_Link&itemid=' + menu_item_count + '&title=' + link_title.val() + '&url=' + link_url.val(),
				success: function (data) {
					console.log(data);
					var result = $.parseJSON(data);
					if (result['status'] === 'success') {
						$('#menu-to-edit').append(result['html']);
						Button.html(Buttonhtml);
						Button.prop('disabled', false);
					}
				}
			});

			$('#menu_item_count').val(menu_item_count);
		}
	});
	$('.submit-add-to-menu').click(function () {
		var Button = $(this),
			type = Button.attr('data-type'),
			prifx = Button.attr('data-prifx'),
			Buttonhtml = Button.html(),
			menuadd = 0,
			menu_item_count = $('#menu_item_count').val(),
			menulength = $('#accordion-section-add-' + prifx + ' .menu-item-checkbox:checked').length;
		if (menulength) {
			$('#accordion-section-add-' + prifx + ' .menu-item-checkbox:checked').each(function () {
				Button.prop('disabled', true);
				Button.html('<i class="fas fa-circle-notch fa-spin fa-fw"></i> ' + Buttonhtml);
				menu_item_count++;
				var check = $(this),
					title = check.attr('data-title'),
					icon = check.attr('data-icon'),
					url = check.attr('data-url');
				check.parent().parent().append('<i class="fas fa-circle-notch fa-spin fa-fw"></i>');
				$.ajax({
					type: 'POST',
					url: admin_ajax_url,
					data: 'action=addmenuitem&itemid=' + menu_item_count + '&title=' + title + '&icon=' + icon + '&url=' + url + '&type=' + type,
					success: function (data) {
						var result = $.parseJSON(data);
						if (result['status'] === 'success') {
							$('#menu-to-edit').append(result['html']);
							check.prop('checked', false);
							check.parent().parent().find('.fa-circle-notch').remove();
							menuadd++;
						}
						if (menulength == menuadd) {
							Button.html(Buttonhtml);
							Button.prop('disabled', false);
						}
					}
				});
				$('#menu_item_count').val(menu_item_count);
			});
		}
	});
});