@extends('dashboard.layouts.master')
@section('content')

<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active"> <a href="{{ get_admin_url('area') }}">Area</a></li>
        </ol>
    </div>
</div>
    @if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @php session()->forget('success');@endphp
            
            @elseif(session()->has('failure'))
            <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>  
            @php session()->forget('failure');@endphp
        @endif

   <div class="card">
    <div class="card-body">
   
<form method="POST" action="{{ get_admin_url('AreaActions') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="query" value="action">
    <input type="hidden" name="id" value="{{$area->id}}">
    <div class="row">
        
    <div class="col-md-4">   
         <div class="form-group required">
         <label class="control-label">Select City</label><br>
           @php $selectedcity=$area->city @endphp 
         <select name="city_id"  id="city_id" class="custom-select form-select custom-select-sm form-control form-control-sm">
         <option value="" selected>Select City</option>
            @foreach($citys as $city)
            @if($selectedcity->id==$city->id)
            <option value="{{$selectedcity->id}}" selected>{{$selectedcity->city_name}}</option>
            @else
            <option value="{{$city->id}}">{{$city->city_name}}</option>
            @endif
            @endforeach
         </select>
        </div>
    </div>

    <div class="col-md-5"></div>
    <div class="col-md-5">   
         <div class="form-group required">
         <label class="control-label">Area Name</label><br>
         <input type="text" name="area_name" cLass="form-control" placeholder="Area Name"  value="{{$area->area_name}}" onkeyup="autoTypeGujarati('area_name');">       
        </div>
    </div>


    <div class="col-md-5">
        <div class="form-group required">
         <label class="control-label">Area Name[gj]</label><br>
        <input type="text" name="area_name_gj" cLass="form-control col-md-6 guj_text" placeholder="વિસ્તારનું નામ"  value="{{$area->area_name_gj}}">       
        </div>
    </div>
       

  


</div>

        <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Update</button>
        <a href="{{get_admin_url('area')}}" class="btn btn-danger"><span></span>Cancel</a>
    </div>
        
          
</form>
</div>
</div>

@endsection