@extends('dashboard.layouts.master')
@section('content')

<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active"> <a href="{{ get_admin_url('city') }}">City</a></li>
        </ol>
    </div>
</div>
    @if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @php session()->forget('success');@endphp
            
            @elseif(session()->has('failure'))
            <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>  
            @php session()->forget('failure');@endphp
        @endif

   <div class="card">
    <div class="card-body">
   
<form method="POST" action="{{ get_admin_url('CityActions') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="query" value="action">
    <input type="hidden" name="id" value="{{$city->id}}">
    <div class="row">
        
         <div class="col-md-5">   
         <div class="form-group required">
         <label class="control-label">Select Country</label><br>
       
         <select name="country_id" id="ajax_call" class="custom-select form-select custom-select-sm form-control form-control-sm">
         <option value="">Select Country</option>
         @php 
         $selectedstate=$city->state;
         $selectedcountry=$selectedstate->country;
         @endphp
         <option value="{{$selectedcountry->id}}" selected>{{$selectedcountry->country_name}}</option>  
    
          @foreach($states as $key=>$state)
          @php $country=$state->country   @endphp

          @if($country->id==$selectedcountry->id)
      
          @else
          <option value="{{$country->id}}">{{$country->country_name}}</option> 
          @endif
          @endforeach
         </select>
        </div>
    </div>

    <div class="col-md-5">   
         <div class="form-group required">
         <label class="control-label">Select State</label><br>
     <select name="state_id" id="state_id" class="custom-select form-select custom-select-sm form-control form-control-sm">
         <option value="" selected>Select Country</option>  
         <option value="{{$selectedstate->id}}" selected>{{$selectedstate->state_name}}</option> 
         </select>
        </div>
    </div>


    <div class="col-md-5">
        <div class="form-group required">
         <label class="control-label">City Name</label><br>
        <input type="text" name="city_name" id="city_name" cLass="form-control col-md-6" placeholder="City Name"  value="{{$city->city_name}}" onkeyup="autoTypeGujarati('city_name');">       
        </div>
    </div>
       
            <div class="col-md-5">
        <div class="form-group required">
         <label class="control-label">City Name[Gujarati]</label><br>
        <input type="text" name="city_name_gj" id="city_name_gj" cLass="form-control col-md-6 guj_text" placeholder="શહેરનું નામ"  value="{{$city->city_name_gj}}">       
        </div>
    </div>

</div>

        <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Update</button>
        <a href="{{get_admin_url('city')}}" class="btn btn-danger"><span></span>Cancel</a>
    </div>
        
          
</form>
</div>
</div>
<script>
$(document).ready(function(){

    $("#ajax_call").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_state')}}";
        params = {id:Id};
        getlistajax(url,params,'state_id');
        
    });

   
});

 </script>  
@endsection