@extends('dashboard.layouts.master')
@section('content')
@php 
$reasons=config('deceasedinfo.REASONS');
@endphp
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{$data['page_title']}}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="{{ get_admin_url('deceased') }}">Deceased</a></li>
            @if($data['userid'])
            <li class="breadcrumb-item"><a href="{{ get_admin_url('profile/'.$data['userid']) }}">{{ admin_lang('profile') }} :: {{ $data['username'] }}</a></li>
            @elseif((isset($deceased_view)) and $deceased_view =='true')
            <li class="breadcrumb-item"><a  href="{{get_admin_url('deceased_correction/'.$deceased->id)}}"><i class="fa fa-check" style="font-size:20px;"></i></a></li>
            <li class="breadcrumb-item"><a  href="{{get_admin_url('deceased_pdf/'.$deceased->id.'/lang/'.'1')}}" id="confirm_language" ><i class="fa fa-file-pdf-o red" style="font-size:25px;"></i></a></li>
            @else
            <li class="breadcrumb-item active">{{ admin_lang('add_new')}}</li>
            @endif
           
        </ol>
    </div>
</div>

<div class="card">
  <div class="card-body">
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">
<div class="col-md-2">
        <div class="form-group">
         <label>Surname</label><br>
        <span>{{$deceased->deceased_surname}}</span>   
        </div>
        </div>

         <div class="col-md-2">   
        <div class="form-group">
         <label >Deceased Name</label><br>
        <span>{{$deceased->deceased_name}}</span>
        </div>
    </div>

      <div class="col-md-2">
        <div class="form-group">
         <label>Father/Husband Name</label><br>
      <span>{{$deceased->deceased_father_husband_name}}</span>
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Surname[Gujarati]</label><br>
      <span>{{$deceased->deceased_surname_gj}}</span>
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Deceased Name[Gujarati]</label><br>
      <span>{{$deceased->deceased_name_gj}}</span>
        </div>
        </div>
     

        <div class="col-md-2">
        <div class="form-group">
         <label>Father/Husband Name[Gujarati]</label><br>
        <span>{{$deceased->deceased_father_husband_name_gj}}</span>     
        </div>
        </div>

    
        <div class="col-md-2">
        <div class="form-group">
         <label>Gender</label><br>
        <span>{{$deceased->gender}}</span>
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Birth Date</label><br>
      <span>{{$deceased->birth_date}}</span>
        </div>
        </div>

        <div class="col-md-1">
        <div class="form-group">
         <label>Age</label><br>
         <span>{{$deceased->age}}</span>
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Entry No</label><br>
         <span>{{$deceased->entry_no}}</span>
        </div>
        </div>
  </div>
</div>




<div class="card">
  <div class="card-body">
<h5 class="font-size-15">Deceased Identity Information</h5>
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">
<div class="col-md-4">
        <div class="form-group">
         <label>Identity Proof</label><br>
         <span>{{$deceased->identity_proof}}</span>
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Identity Proof File</label><br>
         <span>{{$deceased->identity_proof_file}}</span>
        </div>
        </div>

        
        <div class="col-md-3">
        <div class="form-group">
         <label>Photo</label><br>
         <span>{{$deceased->photo}}</span>  
        </div>
        </div>
  </div>
</div>

      
<div class="card">
<div class="card-body">
<h5 class="font-size-15">Deceased Address</h5>  
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">

         <div class="col-md-4">   
        <div class="form-group">
         <label>Address1</label><br>
         <span>{{$deceased['deceased_address']->address1}}</span>
        </div>
    </div>

      <div class="col-md-4">
        <div class="form-group">
         <label>Address2</label><br>
         <span>{{$deceased['deceased_address']->address2}}</span>
        </div>
        </div>

        <div class="col-md-4">
        <div class="form-group">
         <label>Address3</label><br>
         <span>{{$deceased['deceased_address']->address2}}</span>
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Counrty</label><br>
         <span>{{$deceased['country_info']->country_name}}</span> 
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>State</label><br>
         <span>{{$deceased['state_info']->state_name}}</span>
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>City</label><br>
         <span>{{$deceased['city_info']->city_name}}</span>
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Area</label><br>
         <span>{{$deceased['area_info']->area_name}}</span>
        </div>
        </div>


        <div class="col-md-2">
        <div class="form-group">
         <label>Pincode</label><br>
         <span>{{$deceased['deceased_address']->pincode}}</span>    
        </div>
        </div>
</div>

</div>

<div class="card">
  <div class="card-body">
<h5 class="font-size-15">Graveyard Information</h5>
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">
    
        <div class="col-md-3">
        <div class="form-group">
         <label>Graveyard</label><br>
         <span>{{$deceased['garveyard_info']->graveyard_name}}</span>
        </div>
     
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Graveyard Bookno</label><br>
         <span>{{$deceased->graveyard_book_no}}</span>
        </div>
        </div>


        <div class="col-md-2">
        <div class="form-group">
         <label>Graveyard Receipt No</label><br>
         <span>{{$deceased->graveyard_receipt_no}}</span>
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Graveyard Receipt</label><br>
         <span>{{$deceased->graveyard_receipt_no}}</span>
        </div>
        </div>
</div>
</div>


<div class="card">
  <div class="card-body">
    <h5 class="font-size-15">Death Information</h5>
</div>
    <div class="row" style="margin-top:2px; margin-left:3px;">
    <div class="col-md-2">
        <div class="form-group">
         <label>Reason Death</label><br>
         <span>{{$reasons[$deceased->reason_death]}}</span>
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Place Death</label><br>
         <span>{{$deceased->place_death}}</span>   
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Death Date</label><br>
         <span>{{$deceased->death_date}}</span>
        </div>
     
        </div>

  </div>
</div>


        <div class="card">
          <div class="card-body">
            <h5 class="font-size-15">Hospital Information</h5>
            </div>
            <div class="row" style="margin-top:2px; margin-left:3px;">
            <div class="col-md-2">
              <div class="form-group">
              <label> Hospital Letter File</label><br>
              <span>{{$deceased->graveyard_receipt_no}}</span>
              </div>
              </div>

              <div class="col-md-2">
            <div class="form-group">
            <label>Is Postmortem</label><br>  
            <span>{{$deceased->is_postmortem}}</span>
            </div>
            </div>

            <div class="col-md-2 postmortem_detail">
            <div class="form-group">
            <label>Postmortem Fileno</label><br>
            <span>{{$deceased->graveyard_receipt_no}}</span>
            </div>
        
            </div>

            <div class="col-md-2 postmortem_detail">
            <div class="form-group">
            <label>Postmortem Date</label><br>
            <span>{{$deceased->graveyard_receipt_no}}</span>  
            </div>
        </div>

        <div class="col-md-2 postmortem_detail">
        <div class="form-group">
         <label>Postmortem File</label><br>
         <span>{{$deceased->graveyard_receipt_no}}</span>    
        </div>
        </div>
    
          </div>
        </div>

        <div class="card">
<div class="card-body">
<h5 class="font-size-15">Deceased Informer Information</h5>  
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">

      <div class="col-md-3">
        <div class="form-group">
         <label>Informer Name</label><br>
         <span>{{$deceased['informer_info']->informer_name}}</span>
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Informer Relation</label><br>
         <span>{{$deceased['informer_info']->informer_relation}}</span>
        </div>
        </div>
       

        <div class="col-md-3">
        <div class="form-group">
         <label>Informer Mobileno</label><br>
         <span>{{$deceased['informer_info']->informer_mobileno}}</span>
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Informer AltMobileno</label><br>
         <span>{{$deceased['informer_info']->informer_alt_mobileno}}</span>
        </div>
        </div>
       
        <div class="col-md-3">
        <div class="form-group">
         <label>Informer Address</label><br>
         <span>{{$deceased['informer_info']->informer_address}}</span>
        </div>
        </div>
        <div class="col-md-3">
        <div class="form-group">
         <label>Informer Id Proof</label><br>
         <span>{{$deceased['informer_info']->informer_id_proof_file}}</span>
        </div>
        </div>

        <div class="col-md-6"></div>
        <div class="col-md-3">
        <div class="form-group">
         <label>Counrty</label><br>
         <span>{{$deceased['informer_country_info']->country_name}}</span>
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>State</label><br>
         <span>{{$deceased['informer_state_info']->state_name}}</span>
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>City</label><br>
         <span>{{$deceased['informer_city_info']->city_name}}</span>
        </div>
        </div>
        
        <div class="col-md-2">
        <div class="form-group">
         <label>Area</label><br>
         <span>{{$deceased['informer_area_info']->area_name}}</span>
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Informer Pincode</label><br>
         <span>{{$deceased['informer_info']->informer_pincode}}</span>
        </div>
        </div>
</div>
</div>


        <div class="card">
          <div class="card-body">
            <h5 class="font-size-15">Charges Information</h5>
</div>
            <div class="row" style="margin-top:2px; margin-left:3px;">
            <div class="col-md-2">
        <div class="form-group">
         <label>Digging Charge</label><br>
         <span>{{$deceased->digging_charge}}</span>    
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Graveyard Charge</label><br>
         <span>{{$deceased->graveyard_receipt_no}}</span>
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Death Certificate Charge</label><br>
         <span>{{$deceased->graveyard_receipt_no}}</span>   
        </div>
        </div>

          </div>
        </div>

      <h5 class="font-size-15" style="margin-bottom:18px;">Old Entries</h5>
      @php 
      $reason=config('deceasedinfo.REASONS');
      @endphp

      <table id="jq-table" class="table table-striped table-bordered countrytable">
                <thead>
                    <tr>
         
                        <th>Deceased Name</th>
                        <th>Deceased Name[Gujarati]</th>
                        @action('admin_users_th')
                        <th>Birth Date</th>
                        <th>Age</th>
                        <th>Identity Proof</th>
                        <th>IdentityProof File</th>
                        <th>Hospital_letter_file</th>
                        <th>Death Date</th>
                        <th>Dafan Date</th>
                        <th>Reason Death</th>
                        <th>Place Date</th>
                        <th>Address1</th>
                        <th>Area</th>
                        <th>Pincode</th>
                        <th>City</th>
                        <th>State</th>
                        <th>Country</th>
                        
                    </tr>
                </thead>
                <tbody>
               @php $addressinfo=[]; @endphp
                @foreach($old_deceaseds as  $deceased)
                $old_deceaseds
                <tr>
                        <td>
                        <strong><a href="">{{ $deceased->deceased_surname}}</a></strong>  
                        <strong><a href="">{{ $deceased->deceased_name}}</a></strong>  
                        <strong><a href="">{{ $deceased->deceased_father_husband_name}}</a></strong>   
                        </td>
                   
                       <td>
                        <strong><a href="">{{ $deceased->deceased_surname_gj}}</a></strong>  
                        <strong><a href="">{{ $deceased->deceased_name_gj}}</a></strong>  
                        <strong><a href="">{{ $deceased->deceased_father_husband_name_gj}}</a></strong>  
                       </td>
            
                       <td>
                        <strong><a href="">{{ $deceased->birth_date}}</a></strong> 
                       </td>
                       <td >
                        <strong><a href="">{{ $deceased->age}}</a></strong> 
                       </td>
                      
                       <td>
                        <strong><a href="">{{ $deceased->identity_proof}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{ $deceased->identity_proof_file}}</a></strong> 
                       </td>
                       
                       <td>
                        <strong><a href="">{{ $deceased->hospital_letter_file}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{ $deceased->death_date}}</a></strong> 
                       </td>
                       <td>
                        <strong><a href="">{{ $deceased->dafan_date}}</a></strong> 
                       </td>
                       <td>
                        <strong><a href="">{{$reason[$deceased->reason_death]}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{ $deceased->place_death}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{ $deceased->address1}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{''}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{'pincode'}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{'city'}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{'state'}}</a></strong> 
                       </td>

                       <td>
                        <strong><a href="">{{'country'}}</a></strong> 
                       </td>
       
                     </tr>
            
                @endforeach 
     
                    </tbody>
            </table>
     
        @endsection
      @section('style_files')
      <link href="{{ asset('libs/multiselect/css/multiselect.css') }}" rel="stylesheet" type="text/css">
      @endsection
      @section('script_files')
      <script src="{{ asset('libs/multiselect/js/jquery.multiselect.js') }}"></script>
      <script src="{{ asset('dashboard/js/custom-file-input.min.js') }}"></script>
      <script type="text/javascript">
      bsCustomFileInput.init();
      $(function() {$('#permission').multiSelect();});
</script>

@endsection
        @section('script_files')
        <script>
        var newurl=$("#confirm_language").attr('href');
        newurl=newurl.split('lang');
        $("#confirm_language").confirm({
        title: 'Language',
        content: 'Select Language!',
        position: 'top',
        buttons: {
        English: function () {
        newurl[0]=newurl[0]+'1';
        alert
        window.open(
          newurl[0],
          '_blank' // <- This is what makes it open in a new window.
        );
       // window.location.href=newurl[0];
        },
        Gujarati: function () {
        newurl[0]=newurl[0]+'2';
        window.open(
          newurl[0],
          '_blank' // <- This is what makes it open in a new window.
        );
        // window.location.href=newurl[0];
        },
        Cancel: function () {
           
        },

    }
});
</script>
@endsection
        
          
