@extends('dashboard.layouts.master')
@section('content')

<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active"> <a href="{{ get_admin_url('deceased') }}">Deceased</a></li>
        </ol>
    </div>
</div>
    @if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @php session()->forget('success');@endphp
            
            @elseif(session()->has('failure'))
            <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>  
            @php session()->forget('failure');@endphp
        @endif

        @if($errors->any())
    <div class="alert alert-danger">
        <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
    </div>
@endif
   <div class="card">
    <div class="card-body">
   
@php $identitys=config('deceasedinfo.IDENTITYS');
$death_places=config('deceasedinfo.PLACE_Of_DEATH');
$reasons=config('deceasedinfo.REASONS');
$informer_relation=config('deceasedinfo.INFORMER_RELATION');
@endphp

<form method="POST" action="{{ get_admin_url('DeceasedActions') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="query" value="action">
    <input type="hidden" name="id" value="{{$deceased->id}}">
    <div class="row">
    <div class="col-md-12">
        <div class="form-group required">
         <label class="control-label">Entry No</label><br>
        <input style="width:75px;" type="text" name="entry_no" cLass="form-control" placeholder="Entry No" value="{{$deceased->entry_no}}" readonly>   
        @if ($errors->has('entry_no'))
                    <span class="text-danger">{{ $errors->first('entry_no') }}</span>
                @endif      
        </div>
        </div>

        
    <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Surname</label><br>
        <input type="text" name="deceased_surname" id="deceased_surname" class="form-control" placeholder="Deceased Surname"  value="{{old('deceased_surname', $deceased->deceased_surname)}}")
        @endphp>    
        @if ($errors->has('deceased_surname'))
                    <span class="text-danger">{{ $errors->first('deceased_surname') }}</span>
                @endif     
        </div>
        </div>

         <div class="col-md-4">   
        <div class="form-group required">
         <label class="control-label">Deceased Name</label><br>
        <input type="text" name="deceased_name" id="deceased_name" class="form-control " placeholder="Deceased Name"  value="{{old('deceased_name', $deceased->deceased_name)}}" placeholder="">  
        @if ($errors->has('deceased_name'))
                    <span class="text-danger">{{ $errors->first('deceased_name') }}</span>
                @endif       
        </div>
    </div>

      <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Father/Husband Name</label><br>
        <input type="text" name="deceased_father_husband_name" id="deceased_father_husband_name" class="form-control " placeholder="Deceased father_husband_name"  value="{{old('deceased_father_husband_name',$deceased->deceased_father_husband_name)}}"> 
        @if ($errors->has('deceased_father_husband_name'))
                    <span class="text-danger">{{ $errors->first('deceased_father_husband_name') }}</span>
                @endif          
        </div>
        </div>


        <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Surname[Gujarati]</label><br>
        <input type="text" name="deceased_surname_gj" id="deceased_surname_gj" class="form-control col-md-6" placeholder="ગુજરાતીમાં મૃત અટક" value="{{old('deceased_surname_gj',$deceased->deceased_surname_gj)}}">  
        @if ($errors->has('deceased_surname_gj'))
                    <span class="text-danger">{{ $errors->first('deceased_surname_gj') }}</span>
                @endif         
        </div>
        </div>

        <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Deceased Name[Gujarati]</label><br>
        <input type="text" name="deceased_name_gj" id="deceased_name_gj" class="form-control col-md-6" placeholder="મૃતકનું નામ ગુજરાતીમાં" value="{{old('deceased_name_gj',$deceased->deceased_name_gj)}}">  
        @if ($errors->has('deceased_name_gj'))
                    <span class="text-danger">{{ $errors->first('deceased_name_gj') }}</span>
                @endif        
        </div>
        </div>
     

        <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Father/Husband Name[Gujarati]</label><br>
        <input type="text" name="deceased_father_husband_name_gj" id="deceased_father_husband_name_gj" class="form-control col-md-6 guj_text" placeholder="મૃત પિતા, પતિનું ગુજરાતીમાં નામ" value="{{old('deceased_father_husband_name_gj',$deceased->deceased_father_husband_name_gj)}}"> 
        @if ($errors->has('deceased_father_husband_name_gj'))
                    <span class="text-danger">{{ $errors->first('deceased_father_husband_name_gj') }}</span>
                @endif        
        </div>
        </div>

    
        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Gender</label><br>
      <select name="gender" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select Gender</option>
        <option value="Female" @php if($deceased->gender=='Female') {echo "selected";} @endphp>Female</option>
        <option value="Male"  @php if($deceased->gender=='Male'){
            echo "selected";} @endphp>Male</option>
            <option value="Transgender" @php if($deceased->gender=='Transgender'){
            echo "selected";} @endphp>Transgender</option>
      </select>
      @if($errors->has('gender'))
                    <span class="text-danger">{{ $errors->first('gender') }}</span>
                @endif  
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Birth Date</label><br>
        <input type="date" name="birth_date" id="birth_date" class="form-control" placeholder="Date Of Birth" value="{{old('birth_date',$deceased->birth_date)}}"
      >       
      @if ($errors->has('birth_date'))
                    <span class="text-danger">{{ $errors->first('birth_date') }}</span>
                @endif  
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Age</label><br>
        <input type="text" name="age" id="age" class="form-control" style="width:70px;" placeholder="Age"  maxlength="3" value="{{old('age',$deceased->age)}}" readonly>  
        @if ($errors->has('age'))
                    <span class="text-danger">{{ $errors->first('age') }}</span>
                @endif      
     
        </div>
        </div>

</div>        
</div>
</div>
            <div class="card">
            <div class="card-body">
            <h5 class="font-size-15 mb-2">Deceased Identity Information</h5>
            </div>
            <div class="row" style="margin-top:2px; margin-left:3px;">

            <div class="col-md-4">
        <div class="form-group required">
         <label class="control-label">Identity Proof</label><br>
         <select name="identity_proof" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select Proof</option>
        @php $selected=$deceased->identity_proof;  @endphp
        @foreach($identitys as $key=>$identity) 
            @if($selected==$identity)
                <option value="{{$key}}" selected>{{$identity}}</option>
                @else
                <option value="{{$key}}">{{$identity}}</option>
            @endif
        @endforeach
      </select>
      @if ($errors->has('identity_proof'))
                    <span class="text-danger">{{ $errors->first('identity_proof') }}</span>
                @endif    
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Identity Proof File</label><br>
       
        <input type="file" name="identity_proof_file" cLass="form-control"  value="{{old('',$deceased->identity_proof_file)}}">   
        @if ($errors->has('identity_proof_file'))
                    <span class="text-danger">{{ $errors->first('identity_proof_file') }}</span>
                @endif       
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Photo</label><br>
        <input type="file" name="photo" id="photo" class="form-control" value="">       
        @if ($errors->has('photo'))
                    <span class="text-danger">{{ $errors->first('photo') }}</span>
                @endif   
        </div>
        </div>

</div>
</div>


<div class="card">
<div class="card-body">
<h5 class="font-size-15">Deceased Address</h5>  
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">

         <div class="col-md-4">   
        <div class="form-group required">
         <label class="control-label">Address1</label><br>
        <textarea  name="address1" class="form-control" placeholder="Address 1" >{{old('address1',$deceasedaddress->address1)}}</textarea> 
        @if ($errors->has('address1'))
                    <span class="text-danger">{{ $errors->first('address1') }}</span>
                @endif     
        </div>
    </div>

      <div class="col-md-4">
        <div class="form-group">
         <label>Address2</label><br>
        <textarea name="address2" class="form-control" placeholder="Address 2" > {{old('address2',$deceasedaddress->address2)}}</textarea>    
        @if ($errors->has('address2'))
                    <span class="text-danger">{{ $errors->first('address2') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-4">
        <div class="form-group">
         <label>Address3</label><br>
        <textarea name="address3" class="form-control" placeholder="Address 3">{{old('address3',$deceasedaddress->address3)}}</textarea>   
        @if ($errors->has('address3'))
                    <span class="text-danger">{{ $errors->first('address3') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Counrty</label><br>
         <select name="country_id" id="deceased_country_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
         <option value="">Select Country</option>
        @foreach($countrys as $key=>$country)
        @if($deceasedaddress->country_id==$country->id)
        <option value="{{$country->id}}" selected>{{$country->country_name}}</option>
        @else
      
        <option value="{{$country->id}}">{{$country->country_name}}</option>
        @endif
        @endforeach
         </select>   
         @if ($errors->has('country_id'))
                    <span class="text-danger">{{ $errors->first('country_id') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">State</label><br>
        <select name="state_id" id="deceased_state_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select State</option> 
        @foreach($states as $key=>$state)
        @if($deceasedaddress->state_id==$state->id)
        <option value="{{$state->id}}" selected>{{$state->state_name}}</option>
            @else
            <option value="{{$state->id}}">{{$state->state_name}}</option>
            @endif
        @endforeach
        </select>
        @if ($errors->has('state_id'))
                    <span class="text-danger">{{ $errors->first('state_id') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">City</label><br>
        <select name="city_id" id="deceased_city_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select City</option> 
        @foreach($citys as $key=>$city)
        @if($deceasedaddress->city_id==$city->id)
        <option value="{{$city->id}}" selected>{{$city->city_name}}</option>
        @else
        <option value="{{$city->id}}">{{$city->city_name}}</option>
        @endif
        @endforeach
        </select>
        @if ($errors->has('city_id'))
                    <span class="text-danger">{{ $errors->first('city_id') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Area</label><br>
        <select name="area_id" id="deceased_area_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select Area</option> 
        </select>
        @if ($errors->has('area_id'))
                    <span class="text-danger">{{ $errors->first('area_id') }}</span>
                @endif  
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Pincode</label><br>
        <input type="text" name="pincode" style="height:29px;" class="form-control " placeholder="Pincode" value="{{old('pincode',$deceasedaddress->pincode)}}">
        @if ($errors->has('pincode'))
                    <span class="text-danger">{{ $errors->first('pincode') }}</span>
                @endif         
        </div>
        </div>
</div>

</div>

<div class="card">
<div class="card-body">
<h5 class="font-size-15">Graveyard Information</h5>
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Graveyard</label><br>
         <select name="graveyard_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
         <option value="">Select Graveyard</option>
         @php $selectedgrave=$deceased->graveyard;
     
         @endphp
         @foreach($graveyards as $graveyard)
          @if($selectedgrave!='' && $selectedgrave->id==$graveyard->id)
        <option value="{{$graveyard->id}}" selected>{{$graveyard->graveyard_name}}</option>
          @else
          <option value="{{$graveyard->id}}">{{$graveyard->graveyard_name}}</option>
        @endif
        @endforeach
    
        </select>  
        @if ($errors->has('graveyard_id'))
                    <span class="text-danger">{{ $errors->first('graveyard_id') }}</span>
                @endif
        </div>
     
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Graveyard Bookno</label><br>
        <input type="text" name="graveyard_book_no" id="graveyard_book_no" class="form-control" placeholder="Graveyard_book_no" value="{{old('graveyard_book_no',$deceased->graveyard_book_no)}}">   
        @if ($errors->has('graveyard_book_no'))
                    <span class="text-danger">{{ $errors->first('graveyard_book_no') }}</span>
                @endif    
        </div>
        </div>


        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Graveyard Receipt No</label><br>
        <input type="text" name="graveyard_receipt_no" id="graveyard_receipt_no" class="form-control" placeholder="Graveyard_receipt" value="{{old('graveyard_receipt_no',$deceased->graveyard_receipt_no)}}">    
        @if ($errors->has('graveyard_receipt_no'))
                    <span class="text-danger">{{ $errors->first('graveyard_receipt_no') }}</span>
                @endif      
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Graveyard Receipt</label><br>
        <input type="file" name="graveyard_receipt" cLass="form-control" placeholder="Graveyard_receipt" value="">     
        @if ($errors->has('graveyard_receipt'))
                    <span class="text-danger">{{ $errors->first('graveyard_receipt') }}</span>
                @endif     
        </div>
        </div>
        </div>
        </div>

<div class="card">
  <div class="card-body">
    <h5 class="font-size-15">Death Information</h5>
</div>
    <div class="row" style="margin-top:2px; margin-left:3px;">
    <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Reason Death</label><br>
        <select name="reason_death" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        @php $selected=$deceased->place_death;  @endphp
       @foreach($reasons as $key=>$reason)
       @if($selected==$key)
                <option value="{{$key}}" selected>{{$reason}}</option>
                @else
                <option value="{{$key}}">{{$reason}}</option>
            @endif
    
       @endforeach
  </select> 
  @if ($errors->has('reason_death'))
                    <span class="text-danger">{{ $errors->first('reason_death') }}</span>
                @endif  
        </div>
        </div>
        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Place Death</label><br>
         <select name="place_death" class="form-control  custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select Place Death</option>
        @php $selected=ucfirst($deceased->place_death);  @endphp
         @foreach($death_places as $key=>$death_place)
      
         @if($selected==$death_place)
                 <option value="{{$key}}" selected>{{$death_place}}</option>
                @else
                <option value="{{$key}}">{{$death_place}}</option>
            @endif
       
         @endforeach
      </select>     
      @if ($errors->has('place_death'))
                    <span class="text-danger">{{ $errors->first('place_death') }}</span>
                @endif  
        </div>
        </div>
        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Death Date</label><br>
         <input type="datetime-local" name="death_date" cLass="form-control" placeholder="Death Date"  value="{{old('death_date',$deceased->death_date)}}">  
         @if ($errors->has('death_date'))
                    <span class="text-danger">{{ $errors->first('death_date') }}</span>
                @endif       
        </div>
        </div>

        </div>
        </div>
        <div class="card">
          <div class="card-body">
            <h5 class="font-size-15">Hospital Information</h5>
            </div>
            <div class="row" style="margin-top:2px; margin-left:3px;">
            <div class="col-md-2">
            <div class="form-group required">
         <label class="control-label"> Hospital Letter File</label><br>
        <input type="file" name="hospital_letter_file" cLass="form-control" placeholder="Hospital Letter File" value=""/>
        @if ($errors->has('hospital_letter_file'))
                    <span class="text-danger">{{ $errors->first('hospital_letter_file') }}</span>
                @endif 
        </div>
        </div>

        <div class="col-md-2"> 
        <div class="form-group required">
         <label class="control-label">Is Postmortem</label><br>  
        @php $is_post=old('is_postmortem'); @endphp
             @if((isset($is_post)) && $is_post!="")
            <input type="radio"  name="is_postmortem" value="Yes" class="form-check-input is_postmortem" @php if($is_post=="Yes") echo "checked"; @endphp>Yes
            <input type="radio"  name="is_postmortem" value="No" class="form-check-input is_postmortem" @php if($is_post=="No") echo "checked"; @endphp>No
             @else
            <input type="radio"  name="is_postmortem" value="Yes" class="form-check-input is_postmortem" @php if($deceased->is_postmortem=="Yes") echo "checked";  @endphp >Yes
            <input type="radio"  name="is_postmortem" value="No" class="form-check-input is_postmortem"   @php if($deceased->is_postmortem=="No") echo "checked"; @endphp >No
            @endif
        </div>
        </div>

        <div class="col-md-2 postmortem_detail">
        <div class="form-group required">
         <label class="control-label">Postmortem Fileno</label><br>
         <input type="text" name="postmortem_fileno" class="form-control" placeholder="Postmortem Fileno" value="{{old('postmortem_fileno',$deceased->postmortem_fileno)}}">   
         @if ($errors->has('postmortem_fileno'))
                    <span class="text-danger">{{ $errors->first('postmortem_fileno') }}</span>
                @endif     
        </div>
     
        </div>
      
     
        <div class="col-md-2 postmortem_detail">
        <div class="form-group required">
         <label class="control-label">Postmortem Date</label><br>
         <input type="date" name="postmortem_date" class="form-control"  value="{{old('postmortem_date',$deceased->postmortem_date)}}">    
         @if ($errors->has('postmortem_date'))
                    <span class="text-danger">{{ $errors->first('postmortem_date') }}</span>
                @endif       
        </div>
     
        </div>

        <div class="col-md-2 postmortem_detail">
        <div class="form-group required">
         <label class="control-label">Postmortem File</label><br>
         <input type="file" name="postmortem_file" class="form-control" value="">  
         @if ($errors->has('postmortem_file'))
                    <span class="text-danger">{{ $errors->first('postmortem_file') }}</span>
                @endif       
        </div>
        </div>

</div>
    </div>


<div class="card">
<div class="card-body">
<h5 class="font-size-15">Deceased Informer Information</h5>  
</div>
<div class="row" style="margin-top:2px; margin-left:3px;">

      <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Informer Name</label><br>
        <input type="text" name="informer_name" class="form-control " placeholder="Informer Name" value="{{old('informer_name',$deceasedinformer->informer_name)}}" >       
        @if ($errors->has('informer_name'))
                    <span class="text-danger">{{ $errors->first('informer_name') }}</span>
                @endif  
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Informer Relation</label><br>
         <select name="informer_relation" class="form-control  custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="" selected>Please Select</option>
        @foreach($informer_relation as $key=>$relation)
        @if($deceasedinformer->informer_relation==$relation)
        <option value="{{$relation}}" selected>{{$key}}</option>
        @else
        <option value="{{$relation}}">{{$key}}</option>
        @endif

       @endforeach
          </select>
        @if ($errors->has('informer_relation'))
                    <span class="text-danger">{{ $errors->first('informer_relation') }}</span>
                @endif      
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Informer Mobileno</label><br>
        <input type="text" name="informer_mobileno" class="form-control " placeholder="Informer Mobileno" value="{{old('informer_mobileno',$deceasedinformer->informer_mobileno)}}">  
        @if ($errors->has('informer_mobileno'))
                    <span class="text-danger">{{ $errors->first('informer_mobileno') }}</span>
                @endif          
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Informer AlternateMobile</label><br>
         <input type="text" name="informer_alt_mobileno" class="form-control" placeholder="Informer AltMobileno" value="{{old('',$deceasedinformer->informer_alt_mobileno)}}"> 
         @if ($errors->has('informer_alt_mobileno'))
                    <span class="text-danger">{{ $errors->first('informer_alt_mobileno') }}</span>
                @endif    
        </div>
        </div>

<div class="col-md-6">
        <div class="form-group required">
         <label class="control-label">Informer Address</label><br>
        <textarea name="informer_address" class="form-control">{{old('informer_address',$deceasedinformer->informer_address)}}</textarea>
        @if ($errors->has('informer_address'))
                    <span class="text-danger">{{ $errors->first('informer_address') }}</span>
                @endif    
      
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Informer Id Proof</label><br>
        <input type="file" name="informer_id_proof_file" class="form-control" placeholder="Informer Id Proof" value=""> 
        @if ($errors->has('informer_id_proof_file'))
                    <span class="text-danger">{{ $errors->first('informer_id_proof_file') }}</span>
                @endif           
        </div>
        </div>

        <div class="col-md-3"></div>

        <div class="col-md-3">
        <div class="form-group required">
         <label class="control-label">Counrty</label><br>
         <select name="informer_country_id" id="informer_country_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm ">
         <option value="">Select City</option> 
         @foreach($countrys as $key=>$country)
         @if($deceasedinformer->informer_country_id==$country->id)
        <option value="{{$country->id}}" selected>{{$country->country_name}}</option>
            @else
        <option value="{{$country->id}}">{{$country->country_name}}</option>
            @endif
         @endforeach
         </select>   
         @if ($errors->has('informer_country_id'))
                    <span class="text-danger">{{ $errors->first('informer_country_id') }}</span>
                @endif    
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">State</label><br>
        <select name="informer_state_id" id="informer_state_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select State</option> 
        @foreach($states as $key=>$state)
         @if($deceasedinformer->informer_state_id==$state->id)
        <option value="{{$state->id}}" selected>{{$state->state_name}}</option>
            @else
        <option value="{{$state->id}}">{{$state->state_name}}</option>
            @endif
         @endforeach
        </select>
        @if ($errors->has('informer_state_id'))
                    <span class="text-danger">{{ $errors->first('informer_state_id') }}</span>
                @endif   
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">City</label><br>
        <select name="informer_city_id" id="informer_city_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select City</option> 
        @foreach($citys as $key=>$city)
         @if($deceasedinformer->informer_city_id==$city->id)
        <option value="{{$city->id}}" selected>{{$city->city_name}}</option>
            @else
        <option value="{{$city->id}}">{{$city->city_name}}</option>
            @endif
         @endforeach
        </select>
        @if ($errors->has('informer_city_id'))
                    <span class="text-danger">{{ $errors->first('informer_city_id') }}</span>
                @endif  
        </div>
        </div>
        
        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Area</label><br>
        <select name="informer_area_id" id="informer_area_id" class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
        <option value="">Select Area</option> 
        @foreach($areas as $key=>$area)
         @if($deceasedinformer->informer_area_id==$area->id)
        <option value="{{$area->id}}" selected>{{$area->area_name}}</option>
            @else
        <option value="{{$area->id}}">{{$area->area_name}}</option>
            @endif
         @endforeach
        </select>
        @if ($errors->has('informer_area_id'))
                    <span class="text-danger">{{ $errors->first('informer_area_id') }}</span>
                @endif 
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group required">
         <label class="control-label">Informer Pincode</label><br>
        <input type="text" name="informer_pincode" style="height:29px;" class="form-control" placeholder="Informer Pincode" value="{{old('',$deceasedinformer->informer_pincode)}}"> 
        @if ($errors->has('informer_pincode'))
                    <span class="text-danger">{{ $errors->first('informer_pincode') }}</span>
                @endif       
           </div>
        </div>
    </div>
</div>

       <div class="card">
          <div class="card-body">
            <h5 class="font-size-15">Charges Information</h5>
        </div>
            <div class="row" style="margin-top:2px; margin-left:3px;">
            <div class="col-md-2">
            <div class="form-group">
         <label>Digging Charge</label><br>
         <input type="text" name="digging_charge" id="digging_charge" class="form-control"  value="{{$charges_info['digging_charge']->option_value}}" readonly>       
        </div>
        </div>

        <div class="col-md-2">
        <div class="form-group">
         <label>Graveyard Charge</label><br>
         <input type="text" name="graveyard_charge" id="graveyard_charge" class="form-control"  value="{{$charges_info['graveyard_charge']->option_value}}" readonly>       
        </div>
        </div>

        <div class="col-md-3">
        <div class="form-group">
         <label>Death Certificate Charge</label><br>
         <input type="text" name="death_certificate_charge" id="death_certificate_charge" class="form-control"  value="{{$charges_info['death_certificate_charge']->option_value}}" readonly >       
        </div>
        </div>

          </div>
        </div>
        
       
    

        <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Update</button>
        <a href="{{get_admin_url('deceased')}}" class="btn btn-danger"><span></span>Cancel</a>
        </div>
        
          
</form>
<script>
$(document).ready(function(){

    loadGujarati('deceased_surname_gj');
    loadGujarati('deceased_name_gj');
    loadGujarati('deceased_father_husband_name_gj');

    $("#birth_date").on("change",function(){
    var userDateinput = $(this).val();  
    var today = new Date();
    var birthDate = new Date(userDateinput);
    var age = today.getFullYear() - birthDate.getFullYear();
    var m = today.getMonth() - birthDate.getMonth();
    if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) 
    {
        age--;
    }
    $("#age").val(age);
  });

  var selectradio=$(".is_postmortem:checked").val();
  radiobtnResposne(selectradio);
  $(".is_postmortem").on("change",function(){
    selectradio=$(this).val();
    radiobtnResposne(selectradio);
  });
 
  function radiobtnResposne(radio){
    if(radio=="Yes"){
            $(".postmortem_detail").show();
        }else{
            $(".postmortem_detail").hide();
        }

    }

    $("#graveyard_book_no").on("blur",function(){
        var book_no=$("#graveyard_book_no").val();     
         url = "{{get_admin_url('ajax_book')}}";
        params = {id:book_no};
			getlistajax(url,params); 
    });

    $("#graveyard_receipt_no").on("blur",function(){     
      var receipt_no=$("#graveyard_receipt_no").val();
      var book_no=$("#graveyard_book_no").val();
      url = "{{get_admin_url('ajax_book_receipt')}}";
      params = {id:book_no,receipt_no:receipt_no};
      getlistajax(url,params);   
    });


    $("#deceased_country_id").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_state')}}";
        params = {id:Id};
        getlistajax(url,params,'deceased_state_id');   
    });

    $("#deceased_state_id").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_city')}}";
        params = {id:Id};
        getlistajax(url,params,'deceased_city_id');
        
    });

    $("#deceased_city_id").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_area')}}";
        params = {id:Id};
        getlistajax(url,params,'deceased_area_id');
    });
    

    $("#informer_country_id").on("change",function(){
        var Id=$(this).val();
        url = "{{get_admin_url('ajax_state')}}";
        params = {id:Id};
        getlistajax(url,params,'informer_state_id');   
    });


    $("#informer_state_id").on("change",function(){
      var Id=$(this).val();
        url = "{{get_admin_url('ajax_city')}}";
        params = {id:Id};
        getlistajax(url,params,'informer_city_id');

    });

    $("#informer_city_id").on("change",function(){
      var Id=$(this).val();
        url = "{{get_admin_url('ajax_area')}}";
        params = {id:Id};
        getlistajax(url,params,'informer_area_id');

    });
    
});

 </script>  
@endsection