@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="{{ get_admin_url('extensions') }}">{{ admin_lang('extensions') }}</a></li>
            <li class="breadcrumb-item active">{{ admin_lang('license') }}</li>
        </ol>
    </div>
</div>
@if(session()->has('success'))
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
@endif
<div class="row justify-content-center mt-5">
    <div class="col-md-7">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">{!!admin_lang('extension_activator', ['name' => $extension_title])!!}</h4>
                <hr />
                <form method="post" action="{{ get_admin_url('extensions/verify/license') }}">
                    <input type="hidden" name="ext_id" value="{{$extension_id}}" />
                    <input type="hidden" name="ext_slug" value="{{$extension_slug}}" />
                    @if($errors->has('license'))
                    <div class="alert alert-danger" id="error_alert">{!!$errors->first('license')!!}</div>
                    @endif
                    {{ csrf_field() }}
                    <div class="form-group">
                        <label for="ext_client">{{ admin_lang('envato_username') }} @if ($errors->has('ext_client'))<span class="error">{{ $errors->first('ext_client') }}</span>@endif</label>
                        <input type="text" name="ext_client" id="ext_client" class="form-control" value="{{old('ext_client')}}" placeholder="{{ admin_lang('envato_username_placeholder') }}" />
                    </div>
                    <div class="form-group">
                        <label for="ext_license">{{ admin_lang('envato_license') }} @if ($errors->has('ext_license'))<span class="error">{{ $errors->first('ext_license') }}</span>@endif</label>
                        <input type="text" name="ext_license" id="ext_license" class="form-control" value="{{old('ext_license')}}" placeholder="{{ admin_lang('envato_license_placeholder') }}" />
                        
                    </div>
                    <div class="buttons">
                        <button class="btn btn-success" type="submit">{{admin_lang('activate')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection