<div class="tacf-input mt-3">
    <div class="tacf-repeater">
        <table class="tacf-table">
            <tbody class="tacf-ui-sortable">
                @if(is_array($widgets) and count($widgets))
                @php $key = 0; @endphp
                @foreach($widgets as $widget)
                <tr class="tacf-row">
                    <td class="tacf-field tacf-col-item">
                        <h3 class="tacf-head-item">
                            <span class="tacf-title-item">{{admin_lang('widget')}}: <span>{{$widget['name']}}</span></span> 
                            <span class="tacf-row-handle tacf-action-handle order ui-sortable-handle" title="{{admin_lang('move')}}"><i class="bx bx-move"></i></span>
                            <span class="tacf-remove" data-event="remove-row" title="{{admin_lang('remove')}}"><i class="bx bxs-trash-alt"></i></span>
                            @if($widget['toggle'])
                            <span class="tacf-collapse-button"><i class="fas fa-minus"></i></span> 
                            @else
                            <span class="tacf-collapse-button"><i class="fas fa-plus"></i></span> 
                            @endif
                            <span class="tacf-status status-button set-status-button @if($widget['widget'] and $widget['status']) status-on @else status-off @endif" title="{{admin_lang('status')}}"><i class="fas fa-circle"></i></span>
                            <input type="hidden" class="boxs-status" name="{{$option_name}}[{{$key}}][status]" value="{{$widget['status']}}">
                            <input type="hidden" class="tacf-toggle-input" name="{{$option_name}}[{{$key}}][toggle]" value="{{$widget['toggle']}}">
                        </h3>
                        <div class="tacf-input tacf-toggle-content" @if(!$widget['toggle'])style="display: none;"@endif>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('name')}}</label>
                                        <input type="text" name="{{$option_name}}[{{$key}}][name]" class="form-control tacf_toggle_title" value="{{$widget['name']}}" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('widget')}}</label>
                                        <select class="form-select ajax-homepage-widget-select" name="{{$option_name}}[{{$key}}][widget]" data-widget="{{$option_name}}|{{$key}}">
                                            <option value="0">{{admin_lang('none')}}</option>
                                            @action('admin_blade_action_widgets_homepage_options', $widget['widget'])
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('title')}}</label>
                                        <input type="text" name="{{$option_name}}[{{$key}}][title]" class="form-control" value="{{$widget['title']}}" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('description')}}</label>
                                        <input type="text" name="{{$option_name}}[{{$key}}][description]" class="form-control" value="{{$widget['description']}}" />
                                    </div>
                                </div>
                            </div>
                            <div class="box-widget-options">
                                @action('admin_blade_action_widgets_options_'.$widget['widget'], ['key' => $key, 'widget' => $widget, 'option_name' => $option_name])
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('more_button')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="1" class="option-on @if($widget['more_button']) active @endif">{{admin_lang('on')}}</button>
                                            <button type="button" data-value="0" class="option-off @if(!$widget['more_button']) active @endif">{{admin_lang('off')}}</button>
                                            <input type="hidden" name="{{$option_name}}[{{$key}}][more_button]" value="{{$widget['more_button']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('more_icon')}}</label>
                                        <div class="megapanel-icon-select">
                                            <span class="megapanel-icon-preview"><i class="{{$widget['more_icon']}}"></i></span>
                                            <button type="button" class="btn btn-primary waves-effect waves-light megapanel-icon-add">{{admin_lang('changes')}}</button>
                                            <button type="button" class="btn btn-danger waves-effect waves-light megapanel-icon-remove">{{admin_lang('remove')}}</button>
                                            <input type="hidden" name="{{$option_name}}[{{$key}}][more_icon]" class="megapanel-icon-value" value="{{$widget['more_icon']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('more_txt')}}</label>
                                        <input type="text" name="{{$option_name}}[{{$key}}][more_txt]" class="form-control" value="{{$widget['more_txt']}}" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('more_url')}}</label>
                                        <input type="text" name="{{$option_name}}[{{$key}}][more_url]" class="form-control" value="{{$widget['more_url']}}" />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('class')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="bg_white" class="option-on @if($widget['bgclass'] == 'bg_white') active @endif">{{admin_lang('white')}}</button>
                                            <button type="button" data-value="bg_gray" class="option-on @if($widget['bgclass'] == 'bg_gray') active @endif">{{admin_lang('gray')}}</button>
                                            <button type="button" data-value="bg_black" class="option-on @if($widget['bgclass'] == 'bg_black') active @endif">{{admin_lang('black')}}</button>
                                            <button type="button" data-value="bg_color" class="option-on @if($widget['bgclass'] == 'bg_color') active @endif">{{admin_lang('color')}}</button>
                                            <button type="button" data-value="bg_img" class="option-on @if($widget['bgclass'] == 'bg_img') active @endif">{{admin_lang('image')}}</button>
                                            <input type="hidden" name="{{$option_name}}[{{$key}}][bgclass]" value="{{$widget['bgclass']}}">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>{{admin_lang('bgattachment')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="scroll" class="option-on @if($widget['bgattachment'] == 'scroll') active @endif">{{admin_lang('scroll')}}</button>
                                            <button type="button" data-value="fixed" class="option-on @if($widget['bgattachment'] == 'fixed') active @endif">{{admin_lang('fixed')}}</button>
                                            <button type="button" data-value="local" class="option-on @if($widget['bgattachment'] == 'local') active @endif">{{admin_lang('local')}}</button>
                                            <input type="hidden" name="{{$option_name}}[{{$key}}][bgattachment]" value="{{$widget['bgattachment']}}">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>{{admin_lang('bgrepeat')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="repeat" class="option-on @if($widget['bgrepeat'] == 'repeat') active @endif">{{admin_lang('repeat')}}</button>
                                            <button type="button" data-value="no_repeat" class="option-on @if($widget['bgrepeat'] == 'no_repeat') active @endif">{{admin_lang('no_repeat')}}</button>
                                            <button type="button" data-value="repeat_x" class="option-on @if($widget['bgrepeat'] == 'repeat_x') active @endif">{{admin_lang('repeat_x')}}</button>
                                            <button type="button" data-value="repeat_y" class="option-on @if($widget['bgrepeat'] == 'repeat_y') active @endif">{{admin_lang('repeat_y')}}</button>
                                            <input type="hidden" name="{{$option_name}}[{{$key}}][bgrepeat]" value="{{$widget['bgrepeat']}}">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>{{admin_lang('bgsize')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="auto" class="option-on @if($widget['bgsize'] == 'auto') active @endif">{{admin_lang('auto')}}</button>
                                            <button type="button" data-value="cover" class="option-on @if($widget['bgsize'] == 'cover') active @endif">{{admin_lang('cover')}}</button>
                                            <button type="button" data-value="contain" class="option-on @if($widget['bgsize'] == 'contain') active @endif">{{admin_lang('contain')}}</button>
                                            <input type="hidden" name="{{$option_name}}[{{$key}}][bgsize]" value="{{$widget['bgsize']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('bgbackground')}}</label>
                                        <input class="form-control" data-toggle="fileupload" data-field="boxshomepage-{{$key}}" data-src="true" data-size="full" type="text" name="{{$option_name}}[{{$key}}][image]" value="@if(isset($widget['image'])){{$widget['image']}}@endif">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                @php $key++; @endphp
                @endforeach
                @endif
                <tr class="tacf-row tacf-clone">
                    <td class="tacf-field tacf-col-item">
                        <h3 class="tacf-head-item">
                            <span class="tacf-title-item">{{admin_lang('widget')}}: <span></span></span> 
                            <span class="tacf-row-handle tacf-action-handle order ui-sortable-handle" title="{{admin_lang('move')}}"><i class="bx bx-move"></i></span>
                            <span class="tacf-remove" data-event="remove-row" title="{{admin_lang('remove')}}"><i class="bx bxs-trash-alt"></i></span>
                            <span class="tacf-collapse-button"><i class="fas fa-minus"></i></span> 
                            <span class="tacf-status status-button set-status-button status-on" title="{{admin_lang('status')}}"><i class="fas fa-circle"></i></span>
                            <input type="hidden" class="boxs-status tacf-input-key" data-name="{{$option_name}}[{key}][status]" value="1">
                            <input type="hidden" class="tacf-input-key tacf-toggle-input" data-name="{{$option_name}}[{key}][toggle]" value="1">
                        </h3>
                        <div class="tacf-input tacf-toggle-content">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('name')}}</label>
                                        <input type="text" data-name="{{$option_name}}[{key}][name]" class="form-control tacf-input-key tacf_toggle_title" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('widget')}}</label>
                                        <select class="form-select ajax-homepage-widget-select tacf-input-key tacf-input-widget" data-name="{{$option_name}}[{key}][widget]" data-widget="{{$option_name}}|{key}">
                                            <option value="0">{{admin_lang('none')}}</option>
                                            @action('admin_blade_action_widgets_homepage_options', false)
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('title')}}</label>
                                        <input type="text" data-name="{{$option_name}}[{key}][title]" class="form-control tacf-input-key" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('description')}}</label>
                                        <input type="text" data-name="{{$option_name}}[{key}][description]" class="form-control tacf-input-key" />
                                    </div>
                                </div>
                            </div>
                            <div class="box-widget-options"></div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('more_button')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="1" class="option-on">{{admin_lang('on')}}</button>
                                            <button type="button" data-value="0" class="option-off active">{{admin_lang('off')}}</button>
                                            <input type="hidden" data-name="{{$option_name}}[{key}][more_button]" class="tacf-input-key" value="0">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('more_icon')}}</label>
                                        <div class="megapanel-icon-select">
                                            <span class="megapanel-icon-preview"><i class=""></i></span>
                                            <button type="button" class="btn btn-primary waves-effect waves-light megapanel-icon-add">{{admin_lang('changes')}}</button>
                                            <button type="button" class="btn btn-danger waves-effect waves-light megapanel-icon-remove">{{admin_lang('remove')}}</button>
                                            <input type="hidden" data-name="{{$option_name}}[{key}][more_icon]" class="megapanel-icon-value tacf-input-key">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('more_txt')}}</label>
                                        <input type="text" data-name="{{$option_name}}[{key}][more_txt]" class="form-control tacf-input-key" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('more_url')}}</label>
                                        <input type="text" data-name="{{$option_name}}[{key}][more_url]" class="form-control tacf-input-key" />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('class')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="bg_white" class="option-on active">{{admin_lang('white')}}</button>
                                            <button type="button" data-value="bg_gray" class="option-on">{{admin_lang('gray')}}</button>
                                            <button type="button" data-value="bg_black" class="option-on">{{admin_lang('black')}}</button>
                                            <button type="button" data-value="bg_color" class="option-on">{{admin_lang('color')}}</button>
                                            <button type="button" data-value="bg_img" class="option-on">{{admin_lang('image')}}</button>
                                            <input type="hidden" data-name="{{$option_name}}[{key}][bgclass]" class="tacf-input-key" value="bg_white">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>{{admin_lang('bgattachment')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="scroll" class="option-on">{{admin_lang('scroll')}}</button>
                                            <button type="button" data-value="fixed" class="option-on active">{{admin_lang('fixed')}}</button>
                                            <button type="button" data-value="local" class="option-on">{{admin_lang('local')}}</button>
                                            <input type="hidden" data-name="{{$option_name}}[{key}][bgattachment]" class="tacf-input-key" value="fixed">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>{{admin_lang('bgrepeat')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="repeat" class="option-on">{{admin_lang('repeat')}}</button>
                                            <button type="button" data-value="no_repeat" class="option-on active">{{admin_lang('no_repeat')}}</button>
                                            <button type="button" data-value="repeat_x" class="option-on">{{admin_lang('repeat_x')}}</button>
                                            <button type="button" data-value="repeat_y" class="option-on">{{admin_lang('repeat_y')}}</button>
                                            <input type="hidden" data-name="{{$option_name}}[{key}][bgrepeat]" class="tacf-input-key" value="no_repeat">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>{{admin_lang('bgsize')}}</label>
                                        <div class="megapanel-buttons-options">
                                            <button type="button" data-value="auto" class="option-on">{{admin_lang('auto')}}</button>
                                            <button type="button" data-value="cover" class="option-on active">{{admin_lang('cover')}}</button>
                                            <button type="button" data-value="contain" class="option-on">{{admin_lang('contain')}}</button>
                                            <input type="hidden" data-name="{{$option_name}}[{key}][bgsize]" class="tacf-input-key" value="cover">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{admin_lang('bgbackground')}}</label>
                                        <input class="form-control tacf-input-key tacf-input-fileupload" data-field="boxshomepage-{key}" data-src="true" data-size="full" type="text" data-name="{{$option_name}}[{key}][image]">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                
            </tbody>
        </table>
        <div class="tacf-actions mt-3">
            <a class="tacf-button button button-primary mb-2" href="#" data-event="add-row">{{admin_lang('add_widget')}}</a>
        </div>
    </div>
</div>