@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item active">{{ $page_title }}</li>
        </ol>
    </div>
</div>
@if(session()->has('success'))
    <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{!! session()->get('success') !!}</div>
@endif
<div class="row">
    <div class="col-12">
        <div class="email-leftbar card">
            <div class="mail-list">
                <a href="{{ get_admin_url('messages/contactus') }}" @if($list_class == 'contactus') class="active" @endif><i class="bx bx-envelope mr-2"></i> {{ admin_lang('contactus') }} {!! get_messages_html('contactus') !!}</a>
            </div>
        </div>
        <div class="email-rightbar mb-3">
            <div class="card">
                <form class="form-horizontal" method="POST" action="{{ get_admin_url('MessagesActions') }}">
                    {{ csrf_field() }}
                    <input type="hidden" name="type" value="{{ $post_type }}">
                    <input type="hidden" name="query" value="action">
                    <div class="btn-toolbar p-3" role="toolbar">
                        <div class="actionselect ml-3 mr-3">
                            <select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
                                <option value="-1">{{admin_lang('bulk_actions')}}</option>
                                <option value="markread">{{admin_lang('mark_read')}}</option>
                                <option value="markunread">{{admin_lang('mark_unread')}}</option>
                                <option value="delete">{{admin_lang('delete')}}</option>
                            </select>
                            <input type="submit" class="btn btn-sm btn-primary" value="{{admin_lang('apply')}}" onclick="return confirm(\'{{admin_lang('apply_confirm')}}\');">
                        </div>
                    </div>
                    <ul class="message-list">
                        @foreach($posts as $post)
                        <li @if($post->post_status) class="active" @endif>
                            <div class="col-mail col-mail-1">
                                <div class="checkbox-wrapper-mail">
                                    <input type="checkbox" id="select-{{ $post->id }}" name="mark[]" value="{{ $post->id }}" />
                                    <label for="select-{{ $post->id }}" class="toggle"></label>
                                </div>
                                <a class="title" href="{{ get_admin_url('message/show-'.$post->id) }}">
                                    <span class="teaser">@if($post->post_status){{ $post->post_title }}@else <strong>{{ $post->post_title }}</strong> @endif</span>
                                </a>
                            </div>
                            <div class="col-mail col-mail-2">
                                <a href="{{ get_admin_url('message/show-'.$post->id) }}" class="subject">
                                    <span class="teaser">{{get_post_meta_inarray($post->post_excerpts, 'username')}}</span>
                                </a>
                                <div class="date">{{ time_format($post->post_modified, 'date', 'd/m/Y') }}</div>
                            </div>
                        </li>
                        @endforeach
                    </ul>
                </form>
            </div>
            {{$posts->links('dashboard.layouts.pagination')}}
            <br />
        </div>
    </div>
</div>
@endsection
@section('script_files')
<script>
$(function() {
    $(".th-checkbox input:checkbox").on("click", function() {
        var that = this;
        $(".message-list").find("li input:checkbox").each(function() {
            this.checked = that.checked;
            $(this).closest("li").toggleClass("selected");
        });
    });
});
</script>
@endsection


