@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active">{{ $page_title }}</li>
        </ol>
    </div>
</div>
<div class="row mb-3">
    <div class="col-md-3 data-tables-filter">
        <form method="GET" action="" class="form-filter">
            <input type="search" name="s" class="form-control form-control-sm" value="{{request()->get('s')}}" placeholder="{{admin_lang('search')}}">
            <button type="submit" class="btn btn-sm btn-primary button-form-filter">{{admin_lang('search')}}</button>
        </form>
    </div>
    <div class="col-md-9">
        
    </div>
</div>
<div class="card">
    <div class="card-body">
        @if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
        @endif
        <form class="form-horizontal" method="POST" action="{{ get_admin_url('UsercompanysActions') }}">
            {{ csrf_field() }}
            <input type="hidden" name="query" value="action">
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="actionselect">
                        <select name="action" class="custom-select form-select custom-select-sm form-control form-control-sm" style="width: 150px;">
                            <option value="-1">{{admin_lang('bulk_actions')}}</option>
                            <option value="enable">{{admin_lang('enable')}}</option>
                            <option value="disable">{{admin_lang('disable')}}</option>
                            <option value="delete">{{admin_lang('delete')}}</option>
                        </select>
                        <input type="submit" class="btn btn-sm btn-primary" value="{{admin_lang('apply')}}" onclick="return confirm(\'{{admin_lang('apply_confirm')}}\');">
                    </div>
                </div>
                <div class="col-md-8 align-right">
                    <a href="{{ $url_new }}" class="btn btn-sm btn-primary">{{admin_lang('add_new')}}</a>
                </div>
            </div>
            <table id="jq-table" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th style="width: 15px;" class="text-center th-checkbox">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="selectall" />
                                <label class="custom-control-label" for="selectall"></label>
                            </div>
                        </th>
                        <th>{{admin_lang('username')}}</th>
                        <th class="hidden-phone text-center">{{admin_lang('email')}}</th>
                        @action('admin_users_th')
                        <th class="hidden-phone text-center">{{admin_lang('role')}}</th>
                        <th class="hidden-phone text-center">{{admin_lang('created')}}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                    <tr>
                        <td class="td-checkbox">
                            @if($user->id == env('default_adminid'))
                            <i class="bx bxs-shield-alt-2"></i>
                            @else
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="mark[]" value="{{ $user->id }}" id="select-{{ $user->id }}" />                                        
                                <label class="custom-control-label" for="select-{{ $user->id }}"></label>
                            </div>
                            @endif
                            @if($user->status)<span class="sq-post-status disable"></span>@else<span class="sq-post-status enable"></span>@endif
                        </td>
                        <td>
                            <img src="{{ get_user_avatar($user->id) }}" class="image-table">
                            <strong><a href="{{ get_admin_url('profile/'.$user->id) }}">{{ get_username($user->id) }}</a></strong>
                            <div class="row-actions">
                                <a href="{{ get_admin_url('profile/'.$user->id) }}">{{admin_lang('profile')}}</a>
                                @if($user->id != env('default_adminid'))
                                | 
                                @if($user->status)
                                <a href="{{ get_admin_url('disable'.$url_prefix.'/'.$user->id) }}" class="green">{{admin_lang('disable')}}</a> |
                                @else
                                <a href="{{ get_admin_url('enable'.$url_prefix.'/'.$user->id) }}" class="red">{{admin_lang('enable')}}</a> | 
                                @endif
                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirm-delete" data-href="{{ get_admin_url('deleteuser/'.$user->id.'/'.csrf_token() ) }}" data-body="{{ admin_lang('delete_confirm') }} # {{ $user->username }}?" class="red">{{ admin_lang('delete') }}</a>
                                @endif
                            </div>
                        </td>
                        <td class="hidden-phone text-center"><a href="mailto:{{ $user->email }}">{{ $user->email }}</a></td>
                        @action('admin_users_td', $user)
                        <td class="hidden-phone text-center">{{admin_lang('userlevel_'.$user->userlevel)}}</td>
                        <td class="hidden-phone text-center" dir="ltr">{{ time_format(strtotime($user->created_at),'full','m/d/Y') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </form>
        {{$users->links('dashboard.layouts.pagination')}}
    </div>
</div>
@endsection