@extends('dashboard.layouts.master')
@section('content')

<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{$data['page_title']}}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="{{ get_admin_url('usercompanys') }}">{{ admin_lang('userscompany') }}</a></li>
            @if($data['userid'])
            <li class="breadcrumb-item"><a href="{{ get_admin_url('profile/'.$userid) }}">{{ admin_lang('profile') }} :: {{ $data['username'] }}</a></li>
            <li class="breadcrumb-item active">{{ admin_lang('edit') }}</li>
            @else
            <li class="breadcrumb-item active">{{ admin_lang('add_new') }}</li>
            @endif
        </ol>
    </div>
</div>


@if(session()->has('success'))
<div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
@endif
@if($errors->any())
<div class="alert alert-danger">
    <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
</div>
@endif

<div class="card">
    <div class="card-body">
        @include('dashboard.usercompanys.user_form')
    </div>
</div>
@endsection
@section('style_files')
<link href="{{ asset('libs/multiselect/css/multiselect.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script src="{{ asset('libs/multiselect/js/jquery.multiselect.js') }}"></script>
<script src="{{ asset('dashboard/js/custom-file-input.min.js') }}"></script>
<script type="text/javascript">
bsCustomFileInput.init();
$(function() {$('#permission').multiSelect();});
</script>
@endsection