
<form method="POST" action="{{ get_admin_url('UsersSendForm') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="userid" value="{{$data['userid']}}">
    <div class="row">
        <div class="col-md-12">
            @action('admin_user_form_before', $data['userid'])
            <h4 class="card-title"><i class="bx bx-id-card"></i> {{admin_lang('personal_data')}}</h4>
            <hr />
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="username">{{admin_lang('username')}}</label>
                        <div class="frm-input">
                            <input class="form-control" name="username" type="text" id="username" value="@if(old('username')){{old('username')}}@else{{$data['username']}}@endif" placeholder="{{admin_lang('username')}}">
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="email">{{admin_lang('email')}}</label>
                        <div class="frm-input">
                            <input class="form-control" name="email" type="email" id="email" value="@if(old('email')){{old('email')}}@else{{$data['email']}}@endif" placeholder="{{admin_lang('email')}}">
                        </div>
                    </div>
                </div>
                @if($data['user_userlevel'] == 'admin')
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label>{{admin_lang('status')}}</label>
                        <div>
                            <input type="checkbox" name="status" value="1" class="custom-control-input" switch="bool" id="status_switch" @if($data['user_status']) checked @endif>
                            <label for="status_switch" data-on-label="ON" data-off-label="OFF"></label>
                        </div>
                    </div>
                </div>
                @endif
            </div>
            @action('admin_user_form_personal_data', $data['userid'])
            <h4 class="card-title"><i class="bx bx-lock-alt"></i> {{admin_lang('password')}} <small>{{admin_lang('leave_field_change')}}</small></h4>
            <hr />
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="password">{{admin_lang('password')}}</label>
                        <div class="input-group">
                            <input class="form-control" name="password" type="password" id="password" value="{{old('password')}}" placeholder="{{admin_lang('password')}}">
                            <span class="input-group-text"><i class="bx bx-lock"></i></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="confirm_password">{{admin_lang('confirm_password')}}</label>
                        <div class="input-group">
                            <input class="form-control" name="password_confirmation" type="password" id="confirm_password" value="{{old('password_confirmation')}}" placeholder="{{admin_lang('confirm_password')}}">
                            <span class="input-group-text"><i class="bx bx-lock"></i></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label for="pincode">{{admin_lang('pincode')}} <small>{{admin_lang('admin_only')}}</small></label>
                        <div class="input-group">
                            <input class="form-control" name="pincode" type="password" id="pincode" value="{{old('pincode')}}" placeholder="{{admin_lang('pincode')}}">
                            <span class="input-group-text"><i class="bx bx-dialpad"></i></span>
                        </div>
                    </div>
                </div>
            </div>
            @action('admin_user_form_password_data', $data['userid'])
            @if($data['user_userlevel'] == 'admin')
            <h4 class="card-title"><i class="bx bx-id-card"></i> {{admin_lang('role')}}</h4>
            <hr />
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group mb-4">
                        <label>{{admin_lang('role')}}</label>
                        <div class="buttons-options">
                            <button type="button" data-value="admin" class="option-on {{ get_class_active($data['userlevel'], 'admin', false) }}">{{admin_lang('userlevel_admin')}}</button>
                            <button type="button" data-value="supervisor" class="option-on {{ get_class_active($data['userlevel'], 'supervisor', false) }}">{{admin_lang('userlevel_supervisor')}}</button>
                            <button type="button" data-value="user" class="option-on {{ get_class_active($data['userlevel'], 'user', false) }}">{{admin_lang('userlevel_user')}}</button>
                            <button type="button" data-value="new" class="option-on {{ get_class_active($data['userlevel'], 'new', false) }}">{{admin_lang('userlevel_new')}}</button>
                            <input type="hidden" name="userlevel" value="{{$data['userlevel']}}">
                        </div>
                    </div>
                    
                    <div class="form-group mb-4">
                        <label>{{admin_lang('dashboard')}}</label>
                        <div class="buttons-options">
                        {{-- {!! setting_input_radio_multiple(['en' => admin_lang('english'), 'ar' => admin_lang('arabic')], 'admin_language', $data['admin_language'], '') !!} --}}
                        </div>
                    </div>

                </div>
                <div class="col-md-8">
                    <div class="form-group mb-4">
                        <label>{{admin_lang('permissions')}}</label>
                        <select id="permission" multiple="multiple"  name="permission[]">
                            @foreach (get_array_permission() as $permission)
                            <optgroup label="{{$permission['title']}}">
                                @foreach ($permission['permission'] as $item_key => $item_title)
                                <option value="{{$item_key}}" @if(in_array($item_key, $data['user_permission'])) selected @endif>{{$item_title}}</option>
                                @endforeach
                            </optgroup>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            @endif
            @action('admin_user_form_after', $data['userid'])
        </div>
    </div>
    <hr />
    <div class="form-group mb-0">
        <button type="submit" class="btn btn-primary"><span></span> @if($data['action'] == 'update') {{admin_lang('update')}} @else {{admin_lang('add_new')}} @endif</button>
    </div>
</form>