@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row @if($documentation_style == 'fixed') justify-content-center @endif">
        @if($documentation_style == 'left_sidebar')
        @include(get_extends('documentation.sidebar'))
        @endif
        <div class="@if($documentation_style == 'full') col-lg-12  @elseif($documentation_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            @if($the_cate_name)
            <div class="head-title">
                <h4>{{$the_cate_name}}</h4>
            </div>
            @endif
            <div class="row">
                @foreach ($posts as $item)
                <div class="{{$documentation_column}}">
                    <div class="document-item">
                        <h5><a href="{{url('doc/'.$item->post_name)}}">{{$item->post_title}}</a></h5>
                        <div class="row">
                            <div class="col-md-4 col-sm-4 col-xs-12">
                                <i class="pe-7s-user"></i> {{$item->author}}
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12">
                                <i class="pe-7s-ticket"></i> <a href="{{url('documentation/'.$item->term_slug)}}">{{$item->term_name}}</a>
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12">
                                <i class="pe-7s-clock"></i> {{$item->released}}
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12">
                                <i class="pe-7s-anchor"></i> {{$item->version}}
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12">
                                <i class="pe-7s-notebook"></i> <a href="{{$item->url}}" target="_blank">{{extension_lang('documentation', 'online_document')}}</a>
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12">
                                <i class="pe-7s-cloud-download"></i> <a href="{{$item->download}}" target="_blank">{{extension_lang('documentation', 'download')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            {{ $posts->links(get_include('plugins.pagination')) }}
        </div>
        @if($documentation_style == 'right_sidebar')
        @include(get_extends('documentation.sidebar'))
        @endif
    </div>
</div>
@endsection