@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row @if($faq_style == 'fixed') justify-content-center @endif">
        @if($faq_style == 'left_sidebar')
        @include(get_extends('faqs.sidebar'))
        @endif
        <div class="@if($faq_style == 'full') col-lg-12  @elseif($faq_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            @if($faq_column == '2column')
            <div class="accordion toggle-accordion row">
                @foreach ($posts as $item)
                <div class="col-md-6 col-sm-12">
                    <div class="section-content">
                        <h4 class="accordion-title">
                            <a href="#" class="btn-title">{{$item->post_title}}<i class="pe-7s-angle-down"></i></a>
                            @if($faq_catelink == 'name')
                            <span class="tag-name">{{get_term_name($item->term_id)}}</span>
                            @elseif($faq_catelink == 'nameurl')
                            <span class="tag-name"><a href="{{url('faqs/'.get_term_slug($item->term_id))}}">{{get_term_name($item->term_id)}}</a></span>
                            @endif
                        </h4>
                        <div class="accordion-inner">{!!$item->post_content!!}</div>
                    </div>
                </div>
                @endforeach
            </div>
            @else
            <div class="accordion toggle-accordion">
                @foreach ($posts as $item)
                <div class="section-content">
                    <h4 class="accordion-title">
                        <a href="#" class="btn-title">{{$item->post_title}}<i class="pe-7s-angle-down"></i></a>
                        @if($faq_catelink == 'name')
                        <span class="tag-name">{{get_term_name($item->term_id)}}</span>
                        @elseif($faq_catelink == 'nameurl')
                        <span class="tag-name"><a href="{{url('faqs/'.get_term_slug($item->term_id))}}">{{get_term_name($item->term_id)}}</a></span>
                        @endif
                    </h4>
                    <div class="accordion-inner">{!!$item->post_content!!}</div>
                </div>
                @endforeach
            </div>
            @endif
        </div>
        @if($faq_style == 'right_sidebar')
        @include(get_extends('faqs.sidebar'))
        @endif
    </div>
</div>
@endsection