@extends(get_extends('layouts.master'))
@section('sub_header')
@include(get_extends('knowledgebase.search_form'))
@endsection
@section('content')
<div class="container padding_80">
    <div class="row @if($kb_style == 'fixed') justify-content-center @endif">
        @if($kb_style == 'left_sidebar')
        @include(get_extends('knowledgebase.sidebar'))
        @endif
        <div class="@if($kb_style == 'full') col-lg-12  @elseif($kb_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            <div class="head-title">
                <h4>{{$the_cate_name}}</h4>
            </div>
            <ul class="knowledgebase-list">
                @foreach ($posts as $item)
                <li>
                    <h4><a href="{{url('kb/'.$item->post_name)}}">{{$item->post_title}}</a></h4>
                    <div class="post-meta">
                        <span class="meta-author"><i class="pe-7s-user"></i> {{$item->username}}</span>
                        <span class="meta-comment"><i class="pe-7s-look"></i> {{$item->post_views}} {{lang('views')}}</span>
                        <span class="meta-date"><i class="pe-7s-date"></i> {{time_ago($item->post_modified)}}</span>
                    </div>
                </li>
                @endforeach
            </ul>
            {{ $posts->links(get_include('plugins.pagination')) }}
        </div>
        @if($kb_style == 'right_sidebar')
        @include(get_extends('knowledgebase.sidebar'))
        @endif
    </div>
</div>
@endsection