@extends(get_extends('layouts.master'))
@section('content')
<div class="container padding_80">
    <div class="row @if($page_style == 'fixed') justify-content-center @endif">
        @if($page_style == 'left_sidebar')
        @include(get_extends('pages.sidebar'))
        @endif
        <div class="@if($page_style == 'full') col-lg-12  @elseif($page_style == 'fixed') col-lg-10  @else  col-lg-9 col-md-8 col-sm-12 @endif">
            <div class="post-inner">
                @if($post_thumbnail['medium_large'])
                <div class="post-img"><img src="{{url($post_thumbnail['medium_large'])}}" alt="{{$single->post_title}}" /></div>
                @endif
                <h4 class="post-title">{{$single->post_title}}</h4>
                <div class="post-meta">
                    @if($post_meta['meta_author'])<span class="meta-author"><i class="pe-7s-user"></i> {{get_username($single->post_author)}}</span>@endif
                    @if($post_meta['meta_date'])<span class="meta-date"><i class="pe-7s-date"></i> {{time_format($single->post_modified, 'date')}}</span>@endif
                    @if($post_meta['meta_comments'] and $single->comment_status)<span class="meta-comment"><i class="pe-7s-comment"></i> {{get_count_comments($single->id, $single->post_type)}} {{lang('comments')}}</span>@endif
                    @if($post_meta['meta_views'])<span class="meta-views"><i class="pe-7s-look"></i> {{$post_meta['views']}} {{lang('views')}}</span>@endif
                </div>
                <div class="post-content">{!!$single->post_content!!}</div>
                <div class="clearfix"></div>
            </div>
            @if($post_meta['meta_shareit'])
            <div class="stars-tags">
                @include(get_extends('plugins.share_socials'), ['title' => $single->post_title, 'link' => url('page/'.$single->post_name)])
            </div>
            @endif
            @include(get_extends('plugins.comments'), ['single' => $single])
        </div>
        @if($page_style == 'right_sidebar')
        @include(get_extends('pages.sidebar'))
        @endif
    </div>
</div>
@endsection