<div class="padding_80 {{$options['bgclass']}}" {!!$options['image_style']!!}>
    <div class="container">
        @if($options['title'])
        <div class="main_title">
            <h2>{{$options['title']}}</h2>
            <p>{{$options['description']}}</p>
            <span class="divider"></span>
        </div>
        @endif
        <div class="row">
            @foreach ($books as $item)
            <div class="{{$options['column']}} col-12">
                <div class="book-grid-item">
                    <a href="{{url('book/'.$item->post_name)}}">
                        <img src="{{get_attachment_url($item->thumbnail, 'full')}}" class="book-grid-cover" alt="{{$item->post_title}}">
                    </a>
                    <div class="book-grid-meta">
                        <h4 class="book-grid-title"><a href="{{url('book/'.$item->post_name)}}">{{$item->post_title}}</a></h4>
                        <p class="grid-details"><strong>{{extension_lang('books', 'by')}}:</strong> {{$item->author}}</p>
                        <p class="grid-details"><strong>{{extension_lang('books', 'year')}}:</strong> {{$item->year}}</p>
                        <p class="grid-details"><strong>{{extension_lang('books', 'type')}}:</strong> {{$item->type}}</p>
                        <p class="grid-details"><strong>{{extension_lang('books', 'paperback')}}:</strong> {{$item->paperback}} {{extension_lang('books', 'pages')}}</p>
                        <p class="grid-details"><strong>{{extension_lang('books', 'price')}}:</strong> {{$item->price}}</p>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @if($options['more_button'])
        <div class="row">
            <div class="col-md-12">
                <div class="home-more">
                    <a href="@if($options['more_url']){{$options['more_url']}}@else{{url('books')}}@endif">@if($options['more_icon'])<i class="{{$options['more_icon']}}"></i>@endif {{$options['more_txt']}}</a>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>