<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\FrontController;
use App\Http\Controllers\Dashboard\DashboardController;

/**
 * Frontend
 */

//maintenance
Route::get('/maintenance', [FrontController::class, 'maintenance']);

Route::middleware(['visitor', 'frontend'])->group(function () {
    Route::get('/', [FrontController::class, 'home']);
    Route::get('/page/{slug}', [FrontController::class, 'page']);
    Route::post('/sendcomment', [FrontController::class, 'send_comment'])->name('sendcomment');
    Route::post('/sendcontact', [FrontController::class, 'send_contact'])->name('sendcontact');
    $front_real_path = realpath(__DIR__).DIRECTORY_SEPARATOR.'front_routes'.DIRECTORY_SEPARATOR;
    $routes_front = glob( $front_real_path . '*.php', GLOB_BRACE );
    foreach($routes_front as $route){
        if(file_exists($route)){
            include_once($route);
        }
    }

    Route::get('/dashboard', [DashboardController::class, 'index_dashboard']);
    Route::get('/generate-pdf', [DashboardController::class, 'generatePDF']);

    
});

/**
 * Dashboard
 */
Route::group(['prefix' => get_admin_url(), 'middleware' => ['admin', 'admin.pincodeconfirm']], function () {
    $admin_real_path = realpath(__DIR__).DIRECTORY_SEPARATOR.'admin_routes'.DIRECTORY_SEPARATOR;
    $routes_admin = glob( $admin_real_path . '*.php', GLOB_BRACE );
    foreach($routes_admin as $route){
        if(file_exists($route)){
            include_once($route);
        }
    }
});