<!DOCTYPE html>
<html lang="<?php echo e($site_lang); ?>" dir="<?php echo e($site_dir); ?>">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo e(get_option('sitename')); ?> - <?php echo e((isset($page_title))? $page_title : ''); ?></title>
    <link rel="icon" href="<?php echo e(get_asset('images/favicon.png')); ?>">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500">
    <link href="<?php echo e(get_asset('css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <?php if($site_dir == 'rtl'): ?><link rel="stylesheet" href="<?php echo e(get_asset('css/auth.rtl.min.css')); ?>" type="text/css" /><?php else: ?><link rel="stylesheet" href="<?php echo e(get_asset('css/auth.min.css')); ?>" type="text/css" />><?php endif; ?>
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body class="signin <?php echo e($site_dir); ?>">
    <div class="container padding_60">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5 col-xl-4">
                <div class="card overflow-hidden">
                    <div class="bg-cover">
                        <div class="row">
                            <div class="col-7">
                                <div class="text-primary p-4">
                                    <h5 class="text-primary"><?php echo e(lang('welcome_back')); ?></h5>
                                    <p><?php echo e(lang('signin_continue')); ?></p>
                                </div>
                            </div>
                            <div class="col-5 align-self-end">
                                <img src="<?php echo e(get_asset('images/auth.png')); ?>" alt="" class="img-fluid">
                            </div>
                        </div>
                    </div>
                    <div class="card-body signin-form-wrap">
                        <div class="home-icon-wid mb-4">
                            <a href="<?php echo e(url('/')); ?>">
                                <span class="home-icon rounded-circle">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" width="24"><path fill="currentColor" d="M541 229.16l-61-49.83v-77.4a6 6 0 0 0-6-6h-20a6 6 0 0 0-6 6v51.33L308.19 39.14a32.16 32.16 0 0 0-40.38 0L35 229.16a8 8 0 0 0-1.16 11.24l10.1 12.41a8 8 0 0 0 11.2 1.19L96 220.62v243a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-128l64 .3V464a16 16 0 0 0 16 16l128-.33a16 16 0 0 0 16-16V220.62L520.86 254a8 8 0 0 0 11.25-1.16l10.1-12.41a8 8 0 0 0-1.21-11.27zm-93.11 218.59h.1l-96 .3V319.88a16.05 16.05 0 0 0-15.95-16l-96-.27a16 16 0 0 0-16.05 16v128.14H128V194.51L288 63.94l160 130.57z" class=""></path></svg>
                                </span>
                            </a>
                        </div>
                        <?php if(session()->has('errorlogin')): ?><div class="alert alert-warning mt-3"><?php echo e(lang('error_login')); ?></div><?php endif; ?>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-warning mt-3">
                                <ul><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($error); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>
                            </div>
                        <?php endif; ?>
                        <form class="form-horizontal" method="POST" action="<?php echo e(url('login')); ?>">
                            <?php echo e(csrf_field()); ?>

                            <div class="mb-3">
                                <label class="form-label"><?php echo e(lang('email_address')); ?></label>
                                <div class="icon-group">
                                    <div class="form-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M464 64H48C21.5 64 0 85.5 0 112v288c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM48 96h416c8.8 0 16 7.2 16 16v41.4c-21.9 18.5-53.2 44-150.6 121.3-16.9 13.4-50.2 45.7-73.4 45.3-23.2.4-56.6-31.9-73.4-45.3C85.2 197.4 53.9 171.9 32 153.4V112c0-8.8 7.2-16 16-16zm416 320H48c-8.8 0-16-7.2-16-16V195c22.8 18.7 58.8 47.6 130.7 104.7 20.5 16.4 56.7 52.5 93.3 52.3 36.4.3 72.3-35.5 93.3-52.3 71.9-57.1 107.9-86 130.7-104.7v205c0 8.8-7.2 16-16 16z" class=""></path></svg>    
                                    </div>
                                    <input type="email" class="form-control" name="email" id="useremail" placeholder="<?php echo e(lang('enter_email')); ?>" value="<?php echo e(old('email')); ?>">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(lang('password')); ?></label>
                                <div class="icon-group">
                                    <div class="form-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path fill="currentColor" d="M48 480a16 16 0 0 1-16-16v-41.6A102.47 102.47 0 0 1 134.4 320c19.6 0 39.1 16 89.6 16s70-16 89.6-16c2.7 0 5.3.6 7.9.8a79.45 79.45 0 0 1 13.1-30.7 132.34 132.34 0 0 0-21.1-2.1c-28.7 0-42.5 16-89.6 16s-60.8-16-89.6-16C60.2 288 0 348.2 0 422.4V464a48 48 0 0 0 48 48h288.4a78.34 78.34 0 0 1-14.8-32zm176-224A128 128 0 1 0 96 128a128 128 0 0 0 128 128zm0-224a96 96 0 1 1-96 96 96.15 96.15 0 0 1 96-96zm272 336a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm96-80h-16v-48a80 80 0 0 0-160 0v48h-16a48 48 0 0 0-48 48v128a48 48 0 0 0 48 48h192a48 48 0 0 0 48-48V336a48 48 0 0 0-48-48zm-144-48a48 48 0 0 1 96 0v48h-96zm160 224a16 16 0 0 1-16 16H400a16 16 0 0 1-16-16V336a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z" class=""></path></svg>
                                    </div>
                                    <input type="password" class="form-control" name="password" id="userpassword" placeholder="<?php echo e(lang('enter_password')); ?>" value="<?php echo e(old('password')); ?>">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="remember" value="1" id="remember_me" checked>
                                        <label class="form-check-label" for="remember_me"><?php echo e(lang('remember_me')); ?></label>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="recover-password">
                                        <a href="<?php echo e(url('forgot-password')); ?>"><?php echo e(lang('forgot_password')); ?></a>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3">
                                <button class="btn btn-primary btn-block" type="submit"><?php echo e(lang('login')); ?></button>
                            </div>
                        </form>
                        <div class="box-singup">
                            <?php echo e(lang('dont_have_account')); ?> <a href="<?php echo e(url('/register')); ?>"><?php echo e(lang('signup_now')); ?></a>
                        </div>
                    </div>
                </div>
                <div class="mt-3 text-center">
                    <p class="copyright"><?php echo e(lang('site_copyright', ['sitename' => get_option('sitename')])); ?></p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\wamp64\www\waqf_new\resources\views/frontend/default/auth/login.blade.php ENDPATH**/ ?>