
<?php $__env->startSection('content'); ?>
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18"><?php echo e($page_title); ?></h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('/')); ?>"><?php echo e(admin_lang('dashboard')); ?></a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(get_admin_url('media')); ?>"><?php echo e(admin_lang('media_library')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e($page_title); ?></li>
        </ol>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <div class="media-upload-form-wrap" id="async-upload-wrap">
            <form enctype="multipart/form-data" method="post" action="<?php echo e(get_admin_url('mediaajax')); ?>" id="media-upload-form">
                <div class="upload-console-drop" id="drop-zone">
                    <h3><?php echo e(admin_lang('drop_files_here')); ?></h3>
                    <span><?php echo e(admin_lang('or')); ?></span>
                    <input type="file" name="files[]" id="standard-upload-files" multiple="multiple" />
                    <input type="hidden" name="action" value="async_upload" />
                    <input type="hidden" name="type" value="normal" id="type-upload-files" />
                    <button type="button" class="btn" id="plupload-browse-button" /><?php echo e(admin_lang('select_files')); ?></button>
                    <div class="maximum_upload_file_size"><?php echo e(admin_lang('maximum_uploadfile_size', ['size' => format_size(file_upload_max_size())])); ?></div>
                    <div class="bar hidden" id="bar">
                        <div class="bar-fill" id="bar-fill">
                            <div class="bar-fill-text" id="bar-fill-text"></div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<div id="media-items"><div class="media-attachments"></div></div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('style_files'); ?>
<link rel="stylesheet" href="<?php echo e(asset('dashboard/css/drag-drop.css')); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script_files'); ?>
<script type="text/javascript">
    var pageload = 1;
    var media_upload_url = '<?php echo e(get_admin_url('medialibrary')); ?>';
    var ajaxRequests = [];
    var admin_media_upload_url = '<?php echo e(get_admin_url('mediaaction')); ?>';
    var admin_ajax_url = '<?php echo e(get_admin_url('mediaajax')); ?>';
</script>
<script type="text/javascript" src="<?php echo e(asset('dashboard/js/drag-drop.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\waqf_new\resources\views/dashboard/medialibrary/index_media_upload.blade.php ENDPATH**/ ?>