<!DOCTYPE html>
<html lang="<?php echo e($site_lang); ?>" dir="<?php echo e($site_dir); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e((isset($page_title))? $page_title. ' | ' : ''); ?><?php echo e(get_option('sitename')); ?></title>
    <?php app('eventy')->action('blade_action_header_before'); ?>
    <?php echo $__env->make(get_extends('plugins.head_seo'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('stylesheet'); ?>
    <?php echo $__env->yieldPushContent('stylesheet'); ?>
    <?php if(get_theme_option('minify_css')): ?>
    <link href="<?php echo e(get_asset('app.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('libs/fonticons/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <?php else: ?>
    <link href="<?php echo e(asset('libs/fonticons/fontawesome.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('libs/fonticons/boxicons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('libs/fonticons/linearicons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('libs/fonticons/pe-icon-7-stroke.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(get_asset('style.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(get_asset('css/responsive.css')); ?>" rel="stylesheet" type="text/css">
    <?php endif; ?>
    <?php if($site_dir == 'rtl'): ?><link href="<?php echo e(get_asset('css/rtl.min.css')); ?>" rel="stylesheet" type="text/css"><?php endif; ?>
    <?php if($site_lang == 'ar'): ?><link href="<?php echo e(get_asset('css/ar.min.css')); ?>" rel="stylesheet" type="text/css"><?php endif; ?>
    <?php echo $__env->yieldContent('header_extensions'); ?>
    <?php echo $__env->yieldContent('header_code'); ?>
    <?php app('eventy')->action('blade_action_header_after'); ?>
</head>
<body class="<?php echo $__env->yieldContent('body_class'); ?> <?php app('eventy')->action('blade_body_class'); ?> <?php echo e($site_lang); ?>">
    <?php echo $__env->make(get_extends('plugins.pageloader'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make(get_extends('plugins.alert_flash'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="wrapper">
        <?php echo $__env->make(get_extends('layouts.header'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make(get_extends('layouts.sub_header'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make(get_extends('layouts.footer'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="modal fade modal-confirm-delete" id="confirm-delete" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title mt-0"><?php echo e(admin_lang('confirm_delete')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(admin_lang('cancel')); ?></button>
                    <a class="btn btn-danger btn-confirmdelete"><?php echo e(admin_lang('confirm')); ?></a>
                </div>
            </div>
        </div>
    </div> 
    <?php app('eventy')->action('blade_action_footer_before'); ?>
    <?php if(get_theme_option('minify_css')): ?>
    <script src="<?php echo e(get_asset('js/app.min.js')); ?>"></script>
    <?php else: ?>
    <script src="<?php echo e(get_asset('js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(get_asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(get_asset('js/jquery.easing.min.js')); ?>"></script>
    <script src="<?php echo e(get_asset('js/modernizr.min.js')); ?>"></script>
    <?php endif; ?>
    
    <?php if(get_theme_option('sticky_sidebar')): ?>
    <script src="<?php echo e(get_asset('js/ResizeSensor.min.js')); ?>"></script>
    <script src="<?php echo e(get_asset('js/theia-sticky-sidebar.min.js')); ?>"></script>
    <?php endif; ?>
    <script src="<?php echo e(get_asset('js/parallax.min.js')); ?>"></script>
    <script src="<?php echo e(get_asset('js/owl.carousel.min.js')); ?>"></script>
    <?php if(get_theme_option('class_header') == 'jpinning'): ?><script src="<?php echo e(get_asset('js/jPinning.min.js')); ?>"></script><?php endif; ?>
    <script>
    $.ajaxSetup({headers: {'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'}});
    var ajaxRequest = '<?php echo e(url('ajaxRequest')); ?>', cookie_id= '<?php echo e(get_theme_option('cookie_id')); ?>';
    <?php echo $__env->yieldPushContent('scripts_var'); ?>
    (function($) {
        "use strict";
        $('#confirm-delete').on('shown.bs.modal', function(e) {
            $(this).find('.modal-body').html($(e.relatedTarget).data('body'));
            $(this).find('.btn-confirmdelete').attr('href', $(e.relatedTarget).data('href'));
        });
        <?php echo $__env->yieldPushContent('scripts_code'); ?>
    })(jQuery);
    </script>
    <script src="<?php echo e(get_asset('js/custom.min.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <?php echo $__env->make(get_extends('plugins.cookie_box'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make(get_extends('plugins.crisp_chat'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php app('eventy')->action('blade_action_footer_after'); ?>
</body>
</html><?php /**PATH C:\wamp64\www\smartfund\resources\views/frontend/default/layouts/master.blade.php ENDPATH**/ ?>