<?php if(get_theme_option('cookie_status') == 'on'): ?>
<?php if(get_theme_option('cookie_style') == 'style2'): ?>
<div class="cookieinfo cookiebox">
    <div class="cookieinfo-close cookie-consent loading"><?php echo e(get_theme_option('cookie_consent')); ?></div>
    <span><?php echo get_theme_option('cookie_desc'); ?></span>
</div>
<?php elseif(get_theme_option('cookie_style') == 'style3'): ?>
<div class="cookies-banner cookiebox">
    <div class="cookies-banner-container container">
        <p class="cookies-banner-text" style="background-image: url(<?php echo e(get_theme_option('cookie_image', get_asset('images/cookie2.svg'))); ?>)"><?php echo get_theme_option('cookie_desc'); ?></p>
        <span class="cookies-banner-action">
            <button class="cookies-banner-button cookie-consent loading"><?php echo e(get_theme_option('cookie_consent')); ?></button>
        </span>
    </div>
</div>
<?php else: ?>
<div class="cookie-box cookiebox <?php echo e(get_theme_option('cookie_position')); ?>">
    <div class="cookie-box-inner">
        <img src="<?php echo e(get_theme_option('cookie_image', get_asset('images/cookie.svg'))); ?>" alt="cookie">
        <div class="cookie-content">
            <h3><?php echo e(get_theme_option('cookie_title')); ?></h3>
            <p><?php echo get_theme_option('cookie_desc'); ?></p>
            <div class="buttons">
                <button class="button cookie-decline"><?php echo e(get_theme_option('cookie_decline')); ?></button>
                <button class="button cookie-consent loading"><?php echo e(get_theme_option('cookie_consent')); ?></button>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<script src="<?php echo e(get_asset('js/jquery.cookie.js')); ?>"></script>
<script src="<?php echo e(get_asset('js/cookie.min.js')); ?>"></script>
<?php endif; ?><?php /**PATH C:\wamp64\www\php-help-manager\v5\script\project\resources\views/frontend/default/plugins/cookie_box.blade.php ENDPATH**/ ?>