<?php
/**
 * Extension Name: Pricings
 * Extension URI: http://themearabia.net/extension/pricings
 * license: free
 * Version: 1.0
 * Requires: 5.0
 * Description: Pricings
 * Author: Themearabia
 * Author URI: http://themearabia.net
*/

if (!class_exists('extensions_pricings')) {
    class extensions_pricings
    {
        protected $veiwdir      = 'posts.pricings';
        protected $ex_id        = 'pricings';
        protected $ex_type      = 'pricings';
        protected $option_name  = 'options_pricings';
        protected $path         = '';
        protected $ex_url       = '';
        protected $ex_lang      = 'pricings';
        protected $ex_icon      = 'bx bx-dollar-circle';
        protected $ex_order     = '80';
        protected $version      = '1.0';

        /**
         * __construct()
         */
        function __construct()
        {
            $this->path     = extension_path($this->ex_id);
            $this->ex_url   = extension_url($this->ex_id);
            $this->options  = maybe_unserialize(get_option($this->option_name));
            if(is_admin()){
                Eventy::addAction('admin_dashboard_counter', [$this, 'admin_dashboard_counter'], $this->ex_order, 1);
                Eventy::addAction('admin_sidebar_menu', [$this, 'admin_sidebar_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_posts_sendform_'.$this->ex_type, [$this, 'admin_posts_sendform'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_identifier_types', [$this, 'supports_post_type'], $this->ex_order, 1);
                Eventy::addFilter('admin_permissions_args', [$this, 'admin_permissions_args'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_newpost_'.$this->ex_type, [$this, 'filter_newpost'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_editpost_'.$this->ex_type, [$this, 'filter_editpost'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_default_postmeta_'.$this->ex_type, [$this, 'default_postmeta'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_page_template', [$this, 'page_template'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_homepage_options', [$this, 'widgets_homepage_options'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_options_pricings_posts', [$this, 'widgets_options_pricings_posts_echo'], $this->ex_order, 1);
                Eventy::addFilter('action_widgets_options_pricings_posts', [$this, 'widgets_options_pricings_posts'], $this->ex_order, 1);
                Eventy::addFilter('action_widget_get_boxs_element_pricings_posts', [$this, 'widget_get_boxs_element_pricings_posts'], $this->ex_order, 1);
            }
            else {
                Eventy::addFilter('widgets_homepage_start', [$this, 'widgets_homepage_start'], $this->ex_order, 1);
                Eventy::addFilter('widgets_homepage_data_pricings_posts', [$this, 'filter_data_home'], $this->ex_order, 1);
                Eventy::addFilter('filter_data_page_pricings', [$this, 'data_page_pricings'], $this->ex_order, 1);
                
            }
        }

        /**
         * filter_data_home($data)
         */
        public function filter_data_home($data)
        {
            if(is_extensions('pricings'))
            {
                $default_options['title']           = '';
                $default_options['description']     = '';
                $default_options['more_button']     = false;
                $default_options['more_icon']       = '';
                $default_options['more_txt']        = '';
                $default_options['more_url']        = false;
                $default_options['bgclass']         = 'bg_white';
                $default_options['bgattachment']    = 'fixed';
                $default_options['bgrepeat']        = 'no_repeat';
                $default_options['bgsize']          = 'cover';
                $default_options['image']           = false;
                $default_options['image_style']     = '';
                $default_options['column']          = 'col-md-3';
                $default_options['posts']           = [];
                $options = mega_parse_args($data, $default_options);
                $newdata = [];
                $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
                if($options['bgclass'] == 'bg_img')
                {
                    $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                    $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
                }

                $post_ids = [];
                $post_ids = $data['boxs'];
            
                $newdata['options'] = $options;
                $newdata['column']  = $options['column'];
                $newdata['pricings']= $this->get_query()->whereIn('posts.id', $post_ids)->get();
                return $newdata;
            }
            else
            {
                return $data;
            }
        }

        /**
         * data_page_pricings($arg)
         */
        public function data_page_pricings($data)
        {
            if(is_extensions('pricings'))
            {
                $default_options['title']           = '';
                $default_options['description']     = '';
                $default_options['more_button']     = false;
                $default_options['more_icon']       = '';
                $default_options['more_txt']        = '';
                $default_options['more_url']        = false;
                $default_options['bgclass']         = 'bg_white';
                $default_options['bgattachment']    = 'fixed';
                $default_options['bgrepeat']        = 'no_repeat';
                $default_options['bgsize']          = 'cover';
                $default_options['image']           = false;
                $default_options['image_style']     = '';
                $default_options['column']          = 'col-md-3';
                $default_options['posts']           = [];
                $options = mega_parse_args($data, $default_options);
                $newdata = [];
                $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
                if($options['bgclass'] == 'bg_img')
                {
                    $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                    $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
                }
                $newdata['options'] = $options;
                $newdata['column']  = $options['column'];
                $newdata['pricings']   = $this->get_query()->get();
                return mega_parse_args( $newdata, $data );
            }
            else
            {
                return $data;
            }
        }

        /**
         * get_query()
         */
        public function get_query()
        {
            $query = DB::table('posts')
            ->leftJoin('postsmeta as price', function ($join) {$join->on('price.post_id', '=', 'posts.id')->where('price.meta_key', '=', 'price');})
            ->leftJoin('postsmeta as priceold', function ($join) {$join->on('priceold.post_id', '=', 'posts.id')->where('priceold.meta_key', '=', 'priceold');})
            ->leftJoin('postsmeta as payeach', function ($join) {$join->on('payeach.post_id', '=', 'posts.id')->where('payeach.meta_key', '=', 'payeach');})
            ->leftJoin('postsmeta as currency', function ($join) {$join->on('currency.post_id', '=', 'posts.id')->where('currency.meta_key', '=', 'currency');})
            ->leftJoin('postsmeta as regularly', function ($join) {$join->on('regularly.post_id', '=', 'posts.id')->where('regularly.meta_key', '=', 'regularly');})
            ->leftJoin('postsmeta as url', function ($join) {$join->on('url.post_id', '=', 'posts.id')->where('url.meta_key', '=', 'url');})
            ->leftJoin('postsmeta as bgcolor', function ($join) {$join->on('bgcolor.post_id', '=', 'posts.id')->where('bgcolor.meta_key', '=', 'bgcolor');})
            ->leftJoin('postsmeta as color', function ($join) {$join->on('color.post_id', '=', 'posts.id')->where('color.meta_key', '=', 'color');})
            ->leftJoin('postsmeta as featured', function ($join) {$join->on('featured.post_id', '=', 'posts.id')->where('featured.meta_key', '=', 'featured');})
            ->selectRaw(
                db_select_column_as('posts', 'post_title').
                db_select_column_as('posts', 'post_name').
                db_select_column_as('posts', 'id', 'post_id').
                db_select_column_as('price', 'meta_value', 'price').
                db_select_column_as('priceold', 'meta_value', 'priceold').
                db_select_column_as('payeach', 'meta_value', 'payeach').
                db_select_column_as('currency', 'meta_value', 'currency').
                db_select_column_as('regularly', 'meta_value', 'regularly').
                db_select_column_as('url', 'meta_value', 'url').
                db_select_column_as('bgcolor', 'meta_value', 'bgcolor').
                db_select_column_as('color', 'meta_value', 'color').
                db_select_column_as('featured', 'meta_value', 'featured', '')
            )
            ->where(['post_type' => $this->ex_type, 'post_status' => '1'])
            ->orderBy('post_orders', 'ASC')
            ->orderBy('post_modified', 'DESC');
            
            return $query;
        }

        /**
         * widgets_homepage_options($value)
         */
        public function widgets_homepage_options($value)
        {
            $options = [
                'pricings_posts' => [
                    'title' => extension_lang($this->ex_lang, 'pricings'), 
                    'option' => 'pricings_posts'
                ]
            ];
            echo foreach_widgets_homepage_options($options, $value, extension_lang($this->ex_lang, 'pricings'));
        }

        /**
         * widget_get_boxs_element_pricings_posts()
         */
        public function widget_get_boxs_element_pricings_posts($data)
        {
            $option_boxs = [];
            $get_posts = DB::table(POSTS_TABLE)
            ->where(['post_type' => $this->ex_type])
            ->orderBy('post_orders', 'ASC')
            ->orderBy('post_modified', 'DESC')
            ->get();
            foreach($get_posts as $post)
            {
                $option_boxs[] = ['id' => $post->id, 'title' => $post->post_title];
            }
            return $option_boxs;
        }

        /**
         * widgets_options_pricings_posts()
         */
        public function widgets_options_pricings_posts($data)
        {
            $newdefboxs     = [];
            $option_boxs    = [];
            $column         = (isset($data['widget']['column']))? $data['widget']['column'] : 'col-md-3';
            $boxs           = (isset($data['widget']['boxs']))? $data['widget']['boxs'] : [];
            $get_posts = DB::table(POSTS_TABLE)
            ->where(['post_type' => $this->ex_type])
            ->orderBy('post_orders', 'ASC')
            ->orderBy('post_modified', 'DESC')
            ->get();
            foreach($get_posts as $box)
            {
                $newdefboxs[$box->id] = ['id' => $box->id, 'title' => $box->post_title];
            }
            foreach($boxs as $key){
                if(isset($newdefboxs[$key])){
                    $option_boxs[] = $newdefboxs[$key];
                }
            }
            $option_column = ['id' => $data['option_name'].'['.$data['key'].'][column]', 'box_class' => 'form-group', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                'col-md-3' => '4 '.admin_lang('column'), 
                'col-md-4' => '3 '.admin_lang('column'), 
                'col-md-6' => '2 '.admin_lang('column')
            ]];
            $options_boxs = ['id' => $data['option_name'].'['.$data['key'].'][boxs][]', 'modal_title' => admin_lang('add_box'), 'modal_size' => 'smaller', 'modal_search' => '1', 'option_action' => 'pricings_posts', 'option_key' => $data['key'], 'option_name' => $data['option_name'], 'box_class' => 'form-group', 'name' => admin_lang('boxs'), 'options' => $option_boxs];
            return '
            <div class="row">
                <div class="col-md-6">
                    '.field_radio_input($option_column, false).'
                </div>
                <div class="col-md-6">
                    '.field_boxs_sortable_input($options_boxs, false).'
                </div>
            </div>
            ';
        }

        /**
         * widgets_options_pricings_posts_echo($data)
         */
        public function widgets_options_pricings_posts_echo($data)
        {
            echo $this->widgets_options_pricings_posts($data);
        }

        /**
         * widgets_homepage_start($value)
         */
        public function widgets_homepage_start($arg)
        {
            $support = [
                'pricings_posts'    => 'widgets.widget_pricings'
            ];
            return mega_parse_args( $support, $arg );
        }

        /**
         * page_template($value)
         */
        public function page_template($value)
        {
            $select = ($value == 'pricings')? 'selected=""' : '';
            echo '<option value="pricings" '.$select.'>'.extension_lang($this->ex_lang, 'pricings').'</option>';
        }

        /**
         * supports_post_type($arg)
         */
        public function supports_post_type($arg = [])
        {
            $support = [$this->ex_type => ['slug' => $this->ex_type]];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_permissions_args($arg = [])
         */
        public function admin_permissions_args($arg = [])
        {
            $permission = [
                $this->ex_id  => [
                    'title' => extension_lang($this->ex_lang, 'pricings'), 
                    'permission' => [
                        $this->ex_type => extension_lang($this->ex_lang, 'pricings'),
                    ]
                ]
            ];
            return mega_parse_args( $permission, $arg );
        }

        /**
         * admin_dashboard_counter()
         */
        public function admin_dashboard_counter()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'count'     => get_post_count($this->ex_type),
                'title'     => extension_lang($this->ex_lang, 'pricings'),
            ];
            echo get_admin_view('hooks.admin_dashboard_counter', $data)->render();
        }

        /**
         * admin_sidebar_menu()
         */
        public function admin_sidebar_menu()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'badge'     => false,
                'title'     => extension_lang($this->ex_lang, 'pricings'),
                'submenu'   => [
                    ['title' => extension_lang($this->ex_lang, 'pricings'), 'url' => get_admin_url('posts/'.$this->ex_type), 'badge' => ''],
                    ['title' => admin_lang('add_new'), 'url' => get_admin_url('postnew/'.$this->ex_type), 'badge' => '']
                ]
            ];
            if(is_permission($this->ex_type)){
                echo get_admin_view('hooks.admin_sidebar_menu', $data)->render();
            }
        }

        /**
         * default_postmeta($arg)
         */
        public function default_postmeta($arg = [])
        {
            $postmeta = [
                'regularly' => '0'
            ];
            return mega_parse_args( $postmeta, $arg );
        }

        /**
         * filter_newpost($arg)
         * arg = ['data', 'request']
         * data = ['type', 'post_id']
         */
        public function filter_newpost($arg = [])
        {
            $newdata['featured']    = [];
            $newdata['bgcolor']     = '';
            $newdata['color']       = '';
            $newdata['price']       = '';
            $newdata['priceold']    = '';
            $newdata['payeach']     = '';
            $newdata['currency']    = '';
            $newdata['regularly']   = '0';
            $newdata['url']         = '';
            return mega_parse_args( $newdata, (array) $arg );
        }

        /**
         * filter_editpost($arg)
         * arg = ['data', 'request']
         * data = ['type', 'post_id']
         */
        public function filter_editpost($arg = [])
        {
            $featured               = maybe_unserialize(get_post_meta('featured', $arg['post_id']));
            $newdata['featured']    = (is_array($featured))? $featured: [];
            $newdata['bgcolor']     = get_post_meta('bgcolor', $arg['post_id']);
            $newdata['color']       = get_post_meta('color', $arg['post_id']);
            $newdata['price']       = get_post_meta('price', $arg['post_id']);
            $newdata['priceold']    = get_post_meta('priceold', $arg['post_id']);
            $newdata['payeach']     = get_post_meta('payeach', $arg['post_id']);
            $newdata['currency']    = get_post_meta('currency', $arg['post_id']);
            $newdata['regularly']   = get_post_meta('regularly', $arg['post_id']);
            $newdata['url']         = get_post_meta('url', $arg['post_id']);
            return mega_parse_args( $newdata, (array) $arg );
        }

        /**
         * admin_posts_sendform()
         */
        public function admin_posts_sendform($data)
        {
            update_post_meta('featured', maybe_serialize($data['request']->get('featured')), $data['post_id']);
        }
    }

    new extensions_pricings();
}
