<?php
/**
 * Extension Name: Testimonials
 * Extension URI: http://themearabia.net/extension/testimonials
 * license: free
 * Version: 2.0
 * Requires: 5.0
 * Description: Testimonials
 * Author: Themearabia
 * Author URI: http://themearabia.net
 */

if (!class_exists('extensions_testimonials')) {
    class extensions_testimonials
    {

        protected $veiwdir      = 'posts.testimonials';
        protected $ex_id        = 'testimonials';
        protected $ex_type      = 'testimonials';
        protected $option_name  = 'options_testimonials';
        protected $path         = '';
        protected $ex_url       = '';
        protected $ex_lang      = 'testimonials';
        protected $ex_icon      = 'bx bx-user-pin';
        protected $ex_order     = '50';

        /**
         * __construct()
         */
        function __construct()
        {
            $this->path     = extension_path($this->ex_id);
            $this->ex_url   = extension_url($this->ex_id);
            $this->options  = maybe_unserialize(get_option($this->option_name));
            if(is_admin()){
                Eventy::addAction('admin_dashboard_counter', [$this, 'admin_dashboard_counter'], $this->ex_order, 1);
                Eventy::addAction('admin_sidebar_menu', [$this, 'admin_sidebar_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_menu', [$this, 'admin_options_menu'], $this->ex_order, 1);
                Eventy::addAction('admin_options_content', [$this, 'admin_options_content'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_identifier_types', [$this, 'supports_post_type'], $this->ex_order, 1);
                Eventy::addFilter('admin_permissions_args', [$this, 'admin_permissions_args'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_newpost_'.$this->ex_type, [$this, 'filter_newpost'], $this->ex_order, 1);
                Eventy::addFilter('admin_filter_editpost_'.$this->ex_type, [$this, 'filter_editpost'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_homepage_options', [$this, 'widgets_homepage_options'], $this->ex_order, 1);
                Eventy::addAction('admin_blade_action_widgets_options_testimonials_posts', [$this, 'widgets_options_testimonials_posts_echo'], $this->ex_order, 1);
                Eventy::addFilter('action_widgets_options_testimonials_posts', [$this, 'widgets_options_testimonials_posts'], $this->ex_order, 1);
            }
            else
            {
                Eventy::addFilter('widgets_homepage_start', [$this, 'widgets_homepage_start'], $this->ex_order, 1);
                Eventy::addFilter('widgets_homepage_data_testimonials_posts', [$this, 'filter_data_home'], $this->ex_order, 1);
            }
        }

        /**
         * filter_data_home($data = [])
         */
        public function filter_data_home($data = [])
        {
            if(is_extensions('testimonials'))
            {
                $default_options['widgetid']        = 'testimonials';
                $default_options['title']           = '';
                $default_options['description']     = '';
                $default_options['more_button']     = false;
                $default_options['more_icon']       = '';
                $default_options['more_txt']        = '';
                $default_options['more_url']        = false;
                $default_options['bgclass']         = 'bg_white';
                $default_options['bgattachment']    = 'fixed';
                $default_options['bgrepeat']        = 'no_repeat';
                $default_options['bgsize']          = 'cover';
                $default_options['image']           = false;
                $default_options['image_style']     = '';
                $default_options['style']           = 'normal';
                $default_options['column']          = 'col-md-3';
                $default_options['owlrespc']        = '3';
                $default_options['owlrestablet']    = '2';
                $default_options['owlresphone']     = '1';
                $default_options['limit']           = 4;
                $options = mega_parse_args($data, $default_options);
                $newdata = [];
                $options['avatar']  = $this->options['avatar'];
                $options['bgclass'] = (in_array($options['bgclass'], ['bg_black', 'bg_color']))? $options['bgclass'].' title-white' : $options['bgclass'];
                if($options['bgclass'] == 'bg_img')
                {
                    $options['bgclass'] = 'bg-image title-white '.$options['bgattachment'].' '.$options['bgrepeat'].' '.$options['bgsize'];
                    $options['image_style'] = ' style="background-image: url('.$options['image'].')"';
                }
                $newdata['options'] = $options;
                $newdata['column']  = $options['column'];
                $newdata['testimonials']   = $this->get_query()->limit($options['limit'])->get();
                return $newdata;
            }
            else
            {
                return $data;
            }
        }

        /**
         * get_query()
         */
        public function get_query()
        {
            $query = DB::table('posts')
            ->leftJoin('postsmeta as thumbnails', function ($join) {$join->on('thumbnails.post_id', '=', 'posts.id')->where('thumbnails.meta_key', '=', 'thumbnails');})
            ->leftJoin('postsmeta as position', function ($join) {$join->on('position.post_id', '=', 'posts.id')->where('position.meta_key', '=', 'position');})
            ->leftJoin('postsmeta as rating', function ($join) {$join->on('rating.post_id', '=', 'posts.id')->where('rating.meta_key', '=', 'rating');})
            ->selectRaw(
                db_select_column_as('posts', 'post_title').
                db_select_column_as('posts', 'post_content').
                db_select_column_as('posts', 'id').
                db_select_column_as('position', 'meta_value', 'position').
                db_select_column_as('rating', 'meta_value', 'rating').
                db_select_column_as('thumbnails', 'meta_value', 'thumbnail', '')
            )
            ->where(['post_type' => $this->ex_type, 'post_status' => '1'])
            ->orderBy('post_orders', 'ASC')
            ->orderBy('post_modified', 'DESC');
            
            return $query;
        }

        /**
         * widgets_homepage_options($value)
         */
        public function widgets_homepage_options($value)
        {
            $options = [
                'testimonials_posts' => [
                    'title' => extension_lang($this->ex_lang, 'testimonials'), 
                    'option' => 'testimonials_posts'
                ]
            ];
            echo foreach_widgets_homepage_options($options, $value, extension_lang($this->ex_lang, 'testimonials'));
        }

        /**
         * widgets_options_testimonials_posts()
         */
        public function widgets_options_testimonials_posts($data)
        {
            $limit          = (isset($data['widget']['limit']))? $data['widget']['limit'] : 4;
            $column         = (isset($data['widget']['column']))? $data['widget']['column'] : 'col-md-3';
            $style          = (isset($data['widget']['style']))? $data['widget']['style'] : 'normal';
            $owlrespc       = (isset($data['widget']['owlrespc']))? $data['widget']['owlrespc'] : '3';
            $owlrestablet   = (isset($data['widget']['owlrestablet']))? $data['widget']['owlrestablet'] : '2';
            $owlresphone    = (isset($data['widget']['owlresphone']))? $data['widget']['owlresphone'] : '1';
            $option_style = ['id' => $data['option_name'].'['.$data['key'].'][style]', 'box_class' => 'form-group', 'name' => admin_lang('style'), 'value' => $style, 'options' => [
                'normal' => admin_lang('normal'),
                'owlcarousel' => 'Owl Carousel',
            ]];
            $option_column = ['id' => $data['option_name'].'['.$data['key'].'][column]', 'box_class' => 'form-group', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                'col-md-3'  => '4 '.admin_lang('column'),
                'col-md-4'  => '3 '.admin_lang('column'),
                'col-md-6'  => '2 '.admin_lang('column'),
                'col-md-12' => '1 '.admin_lang('column'),
            ]];
            $option_limit = ['id' => $data['option_name'].'['.$data['key'].'][limit]', 'box_class' => 'form-group', 'name' => admin_lang('post_per_page'), 'value' => $limit, 'min' => '1', 'max' => '32', 'step' => '1'];
            $options_owlres = ['type' => 'input_group','name' => 'Owl Responsive', 'box_class' => 'form-group', 'box_class2' => 'd-flex', 'class' => 'text-center', 'grouptext' => admin_lang('items'), 'options' => [
                ['id' => $data['option_name'].'['.$data['key'].'][owlrespc]', 'type' => 'number' ,'value' => $owlrespc, 'grouptext' => '<i class="fas fa-laptop"></i>'],
                ['id' => $data['option_name'].'['.$data['key'].'][owlrestablet]', 'type' => 'number', 'value' => $owlrestablet, 'grouptext' => '<i class="fas fa-tablet-alt"></i>'],
                ['id' => $data['option_name'].'['.$data['key'].'][owlresphone]', 'type' => 'number', 'value' => $owlresphone, 'grouptext' => '<i class="fas fa-mobile-alt"></i>'],
            ]];
            return '
            <div class="row">
                <div class="col-md-6">
                    '.field_radio_input($option_style, false).'
                </div>
                <div class="col-md-6">
                    '.field_radio_input($option_column, false).'
                </div>
                <div class="col-md-6">
                    '.field_text_input_group($options_owlres, false).'
                </div>
                <div class="col-md-6">
                    '.field_slider_number_input($option_limit, false).'
                </div>
            </div>
            ';
        }

        /**
         * widgets_options_testimonials_posts_echo($data)
         */
        public function widgets_options_testimonials_posts_echo($data)
        {
            echo $this->widgets_options_testimonials_posts($data);
        }

        /**
         * widgets_homepage_start($value)
         */
        public function widgets_homepage_start($arg)
        {
            $support = [
                'testimonials_posts'    => 'widgets.widget_testimonials'
            ];
            return mega_parse_args( $support, $arg );
        }

        /**
         * supports_post_type($arg)
         */
        public function supports_post_type($arg = [])
        {
            $support = [$this->ex_type => ['slug' => $this->ex_type]];
            return mega_parse_args( $support, $arg );
        }

        /**
         * admin_permissions_args($arg = [])
         */
        public function admin_permissions_args($arg = [])
        {
            $permission = [
                $this->ex_id  => [
                    'title' => extension_lang($this->ex_lang, 'testimonials'), 
                    'permission' => [
                        $this->ex_type => extension_lang($this->ex_lang, 'testimonials'),
                    ]
                ]
            ];
            return mega_parse_args( $permission, $arg );
        }

        /**
         * admin_dashboard_counter()
         */
        public function admin_dashboard_counter()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'count'     => get_post_count($this->ex_type),
                'title'     => extension_lang($this->ex_lang, 'testimonials'),
            ];
            echo get_admin_view('hooks.admin_dashboard_counter', $data)->render();
        }

        /**
         * admin_sidebar_menu()
         */
        public function admin_sidebar_menu()
        {
            $data = [
                'icon'      => $this->ex_icon,
                'badge'     => false,
                'title'     => extension_lang($this->ex_lang, 'testimonials'),
                'submenu'   => [
                    ['title' => extension_lang($this->ex_lang, 'testimonials'), 'url' => get_admin_url('posts/'.$this->ex_type), 'badge' => ''],
                    ['title' => admin_lang('add_new'), 'url' => get_admin_url('postnew/'.$this->ex_type), 'badge' => '']
                ]
            ];
            if(is_permission($this->ex_type)){
                echo get_admin_view('hooks.admin_sidebar_menu', $data)->render();
            }
        }

        /**
         * admin_options_menu()
         */
        public function admin_options_menu()
        {
            $data = ['id' => $this->ex_id, 'icon' => $this->ex_icon, 'title' => extension_lang($this->ex_lang, 'testimonials')];
            echo get_admin_view('hooks.admin_options_menu_tab', $data)->render();
        }

        /**
         * admin_options_content()
         */
        public function admin_options_content()
        {
            $avatar             = (isset($this->options['avatar']))? $this->options['avatar'] : get_asset('images/avatar.jpg');
            $style              = (isset($this->options['style']))? $this->options['style'] : 'full';
            $post_per_page      = (isset($this->options['post_per_page']))? $this->options['post_per_page'] : '6';
            $column             = (isset($this->options['column']))? $this->options['column'] : 'col-md-4';
            $form_status        = (isset($this->options['form_status']))? $this->options['form_status'] : '';
            $form_title         = (isset($this->options['form_title']))? $this->options['form_title'] : '';
            $data['options'][$this->ex_id]['section_general'] = [
                'title'     => admin_lang('general'),
                'options'   => [
                    ['name' => admin_lang('style'), 'id' => $this->option_name.'[style]', 'type' => 'radio', 'value' => $style, 'options' => [
                        'fixed'         => ['label' => admin_lang('centered'), 'img' => asset('dashboard/images/options/fixed.png')],
                        'full'          => ['label' => admin_lang('full_width'), 'img' => asset('dashboard/images/options/full.png')],
                    ]],
                    ['type' => 'slider_number', 'id' => $this->option_name.'[post_per_page]', 'name' => admin_lang('post_per_page'), 'value' => $post_per_page, 'min' => '1', 'max' => '40', 'step' => '1'],
                    ['type' => 'radio', 'id' => $this->option_name.'[column]', 'name' => admin_lang('column'), 'value' => $column, 'options' => [
                        'col-md-3'  => '4 '.admin_lang('column'),
                        'col-md-4'  => '3 '.admin_lang('column'),
                        'col-md-6'  => '2 '.admin_lang('column'),
                        'col-md-12' => '1 '.admin_lang('column'),
                    ]],
                    ['type' => 'upload', 'id' => $this->option_name.'[avatar]', 'name' => admin_lang('default_avatar'), 'value' => $avatar, 'src' => 'src'],   
                    ['type' => 'checkbox', 'id' => $this->option_name.'[form_status]', 'name' => admin_lang('form'), 'value' => $form_status],
                    ['type' => 'text', 'id' => $this->option_name.'[form_title]', 'name' => admin_lang('form_title'), 'value' => $form_title],
                ]
            ];
            echo get_admin_view('hooks.admin_options_menu_content', $data)->render();
        }

        /**
         * filter_newpost($arg)
         * arg = ['data', 'request']
         * data = ['type', 'post_id']
         */
        public function filter_newpost($arg = [])
        {
            $newdata['position']   = '';
            $newdata['rating']      = '';
            return array_merge( $newdata, (array) $arg );
        }

        /**
         * filter_editpost($arg)
         * arg = ['data', 'request']
         * data = ['type', 'post_id']
         */
        public function filter_editpost($arg = [])
        {
            $newdata['position']   = get_post_meta('position', $arg['post_id']);
            $newdata['rating']      = get_post_meta('rating', $arg['post_id']);
            return array_merge( $newdata, (array) $arg );
        }

    }

    new extensions_testimonials();
}
