<?php

namespace App\Http\Controllers\APi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Token;
use Validator;
use Hash;
use Auth;

class AuthController extends Controller
{
    public function return($status, $message, $errors, $data)
    {
        return response()->json([
            'status' => $status,
            'message' => $message,
            'errors' => $errors,
            'data' => $data
        ]);
    }
    public function loginUser(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required',
            'pincode' => 'required',
        ]);

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }
        $user = User::where('email', $request->email)->where('pincode', md5($request->pincode))->first();
        if ($user && Hash::check($request->password, $user->password)) {
            if ($user->userlevel == 'supervisor' || $user->userlevel == 'user') {
                if ($user->two_factor == 1) {
                    $this->sendOtp($user, 'otp');
                        return $this->return(true, "Otp Send Successfully.", [], []);
                }else{
                    if (Auth::attempt(['email' => $request->email, 'password' => $request->password, 'pincode' => md5($request->pincode)])) {
                        $user = Auth::user();
                        $token = $user->createToken('MyAppToken')->plainTextToken;
                        $data['user'] = $user;
                        $data['token'] = $token;
                        return $this->return(true, "User Login successfully.", [], $data);
                    } else {
                        return $this->return(false, "Unauthorized", ['message' => 'Credentials Do Not Match.'], []);
                    }
                }
            }else if($user->userlevel == 'admin'){
                if (Auth::attempt(['email' => $request->email, 'password' => $request->password, 'pincode' => md5($request->pincode)])) {
                    $user = Auth::user();
                    $token = $user->createToken('MyAppToken')->plainTextToken;
                    $data['user'] = $user;
                    $data['token'] = $token;
                    return $this->return(true, "User Login Successfully.", [], $data);
                } else {
                    return $this->return(false, "Unauthorized", ['message' => 'Credentials Do Not Match.'], []);
                }
            }
        }else{
            return $this->return(false, "Unauthorized.", ['message' => "Credentials Do Not Match."], []);
        }
    }

    public function verify_email(Request $request)
    {
        $data['user'] = User::where('email', $request->email)->first();
        if ($data['user']) {
            return $this->return(true, 'Email Verified Successfully.', [], $data);
        } else {
            return $this->return(false, "Error Occured.", ['message' => "InCorrect Email."], []);
        }
    }

    public function change_password($id)
    {
        $id = md5($id);
        $data['user'] = User::whereRaw("MD5(id) = '{$id}'")->first();
        if ($data['user']) {
            return $this->return(true, "User Fetched Successfully.", [], $data);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'User Not Found.'], []);
        }
    }

    public function change_password_check(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'password' => 'required',
            'confirm_password' => 'required|same:password',
            'user_id' => 'required'
        ], [
                'password.required' => 'Password is required',
                'confirm_password.required' => 'Confirm Password is required',
                'confirm_password.same' => 'Password and Confirm Password must match',
            ]);

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $user = User::find($request->user_id);
        if ($user) {
            $user->password = Hash::make($request->password);
            $user->pincode = md5($request->pincode);
            $user->update();
            $data['user'] = $user;
            return $this->return(true, "Data Has Been Updated Successfully.", [], $data);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }
    }

    public function verification($id)
    {
        $id = md5($id);
        $data['user'] = User::whereRaw("MD5(id) = '{$id}'")->first();
        if ($data['user']) {
            $this->sendOtp($data['user']);
            return $this->return(true, "User Fetched Successfully.", [], $data);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }
    }

    public function verifiedOtp(Request $request)
    {
        $user = User::where('id', $request->user_id)->first();
        $token = Token::where('token', $request->token)->first();
        if (!$token) {
            return $this->return(false, "Wrong OTP.", ['message' => 'You entered wrong OTP.'], []);
        } else {
            $currentTime = time();
            $time = $token->created_at;
            if ($currentTime >= $time && $time >= $currentTime - (60)) {
                $auth = Auth::attempt(['email' => $user->email, 'password' => $user->password]);
                $data = Auth::guard('api')->user();
            return $this->return(true, "Mail has been verified.", [], $data);
            } else {
            return $this->return(false, "Error Occured.", ['message' => 'Your OTP has been Expired.'], []);
            }
        }
    }

    public function sendOtp($user, $mode = '')
    {
        if ($mode == 'resend' || $mode == 'otp') {
            $token = rand(100000, 999999);
            $time = time();

            Token::updateOrCreate(
                ['user_id' => $user->id],
                [
                    'user_id' => $user->id,
                    'token' => $token,
                    'created_at' => $time
                ]
            );

            $data['email'] = $user->email;
            $data['username'] = $user->username;
            $data['title'] = 'Two Factor Authentication';

            $data['body'] = 'Your OTP is:- ' . $token;
        }

        $mode = '';

    }

    public function resendOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required'
        ]);

        if($validator->fails()){
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $user = User::where('id', $request->user_id)->first();
        $tokenData = Token::where('user_id', $request->user_id)->first();

        $currentTime = time();
        $time = $tokenData->created_at;

        if ($currentTime >= $time && $time >= $currentTime - (60)) { //90 seconds
            return $this->return(false, "Error Occured.", ['message' => 'Please try after some time'], []);
        } else {
            $this->sendOtp($user, 'resend'); //OTP SEND
            return $this->return(true, "Otp Has Been Sent.", [], []);
        }
    }
}
