<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Driver;
use App\Models\User;
use App\Models\DriverFund;
use App\Models\DriverStatus;
use Auth;
use Validator;
use Hash;
use DB;

class DriverController extends Controller
{
    public function return ($status, $message, $errors, $data)
    {
        return response()->json([
            'status' => $status,
            'message' => $message,
            'errors' => $errors,
            'data' => $data,
        ]);
    }
    public function drivers()
    {
        $user = Auth::guard('api')->user();
        if ($user) {
            if ($user->userlevel == 'admin') {
                $data['driver'] = Driver::all();
            } else {
                $data['driver'] = Driver::where('MEM_ID', $user->id)->get();
            }
            return $this->return(true, 'Listing Successfully', [], $data);
        } else {
            return $this->return(false, 'Error Occured.', ['message' => 'Access Denied.'], []);
        }
    }

    public function ajaxlist_driver(Request $request)
    {
        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['messsage' => 'Access Denied.'], []);
        }
        if ($user->userlevel == 'admin') {
            $driver = Driver::orderBy('CREATED_DATE', 'DESC');
        } else {
            $driver = Driver::where('MEM_ID', $user->id)->orderBy('CREATED_DATE', 'DESC');
        }
        if ($request->has('s') || $request->has('company_name') || $request->has('driver_status')) {
            $driver->where(function ($query) use ($request) {
                $user = Auth::guard('api')->user();
                if ($request->has('sort')) {
                    if ($request->sort == 'asc') {
                        if ($user->userlevel == 'admin') {
                            $driver = Driver::orderBy('FIRST_NAME', 'ASC');
                        } else {
                            $driver = Driver::where('MEM_ID', $user->id)->orderBy('FIRST_NAME', 'ASC');
                        }
                    } else if ($request->sort == 'desc') {
                        if ($user->userlevel == 'admin') {
                            $driver = Driver::orderBy('FIRST_NAME', 'DESC');
                        } else {
                            $driver = Driver::where('MEM_ID', $user->id)->orderBy('FIRST_NAME', 'DESC');
                        }
                    }
                }
                $search = $request->input('s');
                $company_name = $request->input('company_name');
                $driver_status = $request->input('driver_status');
                if ($search != '') {
                    $query->where(function ($querysearch) use ($search) {
                        $querysearch->where('FIRST_NAME', 'LIKE', '%' . $search . '%')
                            ->orWhere('LAST_NAME', 'LIKE', '%' . $search . '%')
                            ->orWhere('CARD_NUM', 'LIKE', '%' . $search . '%')
                            ->orWhere('DRIVER_PHONE', 'LIKE', '%' . $search . '%')
                            ->orWhere('SUB_STATUS', 'LIKE', '%' . $search . '%');
                    });
                }

                if ($driver_status != '') {
                    $query->Where('STATUS', $driver_status);
                }

                if ($user->userlevel == 'admin' && $company_name != '') {
                    $query->Where('MEM_ID', $company_name);
                }
            });
        }
        $driver = $driver->get();
        if ($driver->count() > 0) {
            return $this->return(true, "Driver Listing Successfully.", [], $driver);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found'], []);
        }
    }

    public function driver_fund(Request $request, $type = '')
    {
        $driver_fund = DriverFund::with('drivers')->get();
        if ($driver_fund->count() > 0) {
            return $this->return(true, "Driver Fund Listing Successfully.", [], $driver_fund);
        } else {
            return $this->return(false, "Error Occured.", ['message' => "No Data Found"], []);
        }
    }

    public function ajaxlist_driver_fund(Request $request)
    {
        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => "Access Denied."], []);
        }
        $driver = DriverFund::pluck('driver_id');
        $item = Driver::whereIn('SMART_DRIVERID', $driver)->where('MEM_ID', $user->id)->pluck('SMART_DRIVERID');
        $ab = DriverFund::whereIn('driver_id', $item)->orderBy('id', 'DESC');

        if ($request->get('s')) {
            $search = $request->get('s');
            $ab->where(function ($query) use ($search) {
                $query->Where('amount', 'LIKE', '%' . $search . '%')
                    ->orWhere('issue_to', 'LIKE', '%' . $search . '%')
                    ->orWhere('notes', 'LIKE', '%' . $search . '%')
                    ->orWhere('ref_id', 'LIKE', '%' . $search . '%')
                    ->orWhereHas('drivers', function ($query) use ($search) {
                        $query->where('USERNAME', 'LIKE', '%' . $search . '%');
                    });
            });
        }
        $ab = $ab->get();
        if ($ab->count() > 0) {
            return $this->return(true, "Driver Fund Listing Successfully.", [], $ab);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found'], []);
        }
    }

    public function add_driver($mode = '')
    {
        $data['companies'] = User::where('userlevel', 'supervisor')->get();
        if ($data['companies']->count() > 0) {
            return $this->return(true, 'Company Lising Successfully.', [], $data);
        } else {
            return $this->return(false, 'No Data Found.', ['message' => 'No Data Found.'], []);
        }
    }

    public function store_driver(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'FIRST_NAME' => 'required',
            'LAST_NAME' => 'required',
            'ADDRESS' => 'required',
            'CITY' => 'required',
            'STATE' => 'required',
            'POSTAL' => 'required',
            'COUNTRY' => 'required',
            'DOB' => 'required',
            'SSN_NUM' => 'required',
            'DRIVER_EMAIL' => 'required|unique:smartpay_driver',
            'DRIVER_PHONE' => 'required',
            'STATUS' => 'required',
            'SUB_STATUS' => 'required',
            'USERNAME' => 'required',
            'PASSWORD' => 'required',
            'pin_number' => 'required',
        ]);

        if ($validator->fails()) {
            return $this->return(false, 'Validation Error.', $validator->errors(), []);
        }

        $driverEmail = $request->DRIVER_EMAIL;
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return $this->return(false, 'Validation Error.', ['message' => 'Email is Already Been Taken Pls Use Another Email.'], []);
        }

        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }

        $driver = Driver::create([
            "FIRST_NAME" => $request->input('FIRST_NAME'),
            "LAST_NAME" => $request->input("LAST_NAME"),
            "ADDRESS" => $request->input('ADDRESS'),
            "CITY" => $request->input('CITY'),
            "STATE" => $request->input('STATE'),
            "POSTAL" => $request->input('POSTAL'),
            "COUNTRY" => $request->input('COUNTRY'),
            "DOB" => $request->input('DOB'),
            "SSN_NUM" => $request->input('SSN_NUM'),
            "DRIVER_EMAIL" => $request->input('DRIVER_EMAIL'),
            "DRIVER_PHONE" => $request->input('DRIVER_PHONE'),
            "STATUS" => $request->input('STATUS'),
            "SUB_STATUS" => $request->input('SUB_STATUS'),
            "USERNAME" => $request->input('USERNAME'),
            "PASSWORD" => $request->input('PASSWORD'),
            "pin_number" => $request->input('pin_number'),
            "MEM_ID" => $user->id,
            "CREATED_DATE" => date('Y-m-d'),
        ]);

        $lastDriverId = $driver->SMART_DRIVERID;

        $mailurl = "https://tms.tmdashboard.com/sendgrid/newcard_order.php?ID=" . $lastDriverId;
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $mailurl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);

        $user = User::create([
            "username" => $request->input('USERNAME'),
            "email" => $request->input("DRIVER_EMAIL"),
            "password" => Hash::make($request->input('PASSWORD')),
            'pincode' => md5($request->input('pin_number')),
            "userlevel" => 'user',
            "status" => 1,
        ]);
        $lastUserId = $user->id;
        $driverUpdate = Driver::find($lastDriverId);
        $driverUpdate->CLIENT_ID = $lastUserId;
        $driverUpdate->save();

        if ($driver && $user) {
            return $this->return(true, 'Driver Added Successfully!', [], $driver);
        } else {
            return $this->return(false, 'Error Occured.', ['message' => 'Driver Not Added.'], []);
        }
    }

    public function quick_driver_add(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'FIRST_NAME' => 'required',
                'LAST_NAME' => 'required',
            ]
        );

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $driverEmail = $request->input('FIRST_NAME') . $request->input('LAST_NAME') . '@tmsdashboard.com';
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return $this->return(false, "Validation Error.", ['message' => 'First Name And Last Name Already Taken Pls Use Another Name.'], []);
        }

        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }

        $driver = Driver::create([
            "FIRST_NAME" => $request->input('FIRST_NAME'),
            "LAST_NAME" => $request->input("LAST_NAME"),
            "USERNAME" => $request->input('FIRST_NAME') . $request->input('LAST_NAME'),
            "DRIVER_EMAIL" => $request->input('FIRST_NAME') . $request->input('LAST_NAME') . '@tmsdashboard.com',
            "PASSWORD" => date('mdY'),
            "pin_number" => 1234,
            "STATUS" => 0,
            "MEM_ID" => $user->id,
            "CREATED_DATE" => date('Y-m-d'),
        ]);

        $lastDriverId = $driver->SMART_DRIVERID;

        $mailurl = "https://tms.tmdashboard.com/sendgrid/newcard_order.php?ID=" . $lastDriverId;
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $mailurl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);

        $user = User::create([
            "username" => $driver->USERNAME,
            "email" => $driver->DRIVER_EMAIL,
            "password" => Hash::make($driver->PASSWORD),
            'pincode' => md5($driver->pin_number),
            "userlevel" => 'user',
            "status" => 1,
        ]);
        $lastUserId = $user->id;
        $driverUpdate = Driver::find($lastDriverId);
        $driverUpdate->CLIENT_ID = $lastUserId;
        $driverUpdate->save();

        if ($driver && $user) {
            return $this->return(true, "Driver Added Successfully.", [], $driver);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'Driver Not Added.'], []);
        }
    }

    public function admin_driver_add(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'FIRST_NAME' => 'required',
                'LAST_NAME' => 'required',
                'ADDRESS' => 'required',
                'CITY' => 'required',
                'STATE' => 'required',
                'POSTAL' => 'required',
                'COUNTRY' => 'required',
                'DOB' => 'required',
                'SSN_NUM' => 'required',
                'DRIVER_EMAIL' => 'required|unique:smartpay_driver',
                'DRIVER_PHONE' => 'required',
                'STATUS' => 'required',
                'SUB_STATUS' => 'required',
                'USERNAME' => 'required',
                'PASSWORD' => 'required',
                'pin_number' => 'required',
                'MEM_ID' => 'required',
            ],
            [
                'MEM_ID.required' => 'Company is required.'
            ]
        );

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $driverEmail = $request->DRIVER_EMAIL;
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return $this->return(false, "Validation Error.", ['message' => 'Email is Already Been Taken Pls Use Another Email'], []);
        }

        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied'], []);
        }
        $driver = Driver::create([
            "FIRST_NAME" => $request->input('FIRST_NAME'),
            "LAST_NAME" => $request->input("LAST_NAME"),
            "ADDRESS" => $request->input('ADDRESS'),
            "CITY" => $request->input('CITY'),
            "STATE" => $request->input('STATE'),
            "POSTAL" => $request->input('POSTAL'),
            "COUNTRY" => $request->input('COUNTRY'),
            "DOB" => $request->input('DOB'),
            "SSN_NUM" => $request->input('SSN_NUM'),
            "DRIVER_EMAIL" => $request->input('DRIVER_EMAIL'),
            "DRIVER_PHONE" => $request->input('DRIVER_PHONE'),
            "STATUS" => $request->input('STATUS'),
            "SUB_STATUS" => $request->input('SUB_STATUS'),
            "USERNAME" => $request->input('USERNAME'),
            "PASSWORD" => $request->input('PASSWORD'),
            "pin_number" => $request->input('pin_number'),
            "MEM_ID" => $request->MEM_ID,
            "CREATED_DATE" => date('Y-m-d'),
        ]);

        $lastDriverId = $driver->SMART_DRIVERID;

        $mailurl = "https://tms.tmdashboard.com/sendgrid/newcard_order.php?ID=" . $lastDriverId;
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $mailurl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);

        $user = User::create([
            "username" => $request->input('USERNAME'),
            "email" => $request->input("DRIVER_EMAIL"),
            "password" => Hash::make($request->input('PASSWORD')),
            'pincode' => md5($request->input('pin_number')),
            "userlevel" => 'user',
            "status" => 1,
        ]);
        $lastUserId = $user->id;
        //dd($lastUserId);
        $driverUpdate = Driver::find($lastDriverId);
        $driverUpdate->CLIENT_ID = $lastUserId;
        $driverUpdate->save();

        if ($driver && $user) {
            return $this->return(true, "Driver Added Successfully.", [], $driver);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'Driver Not Added.'], []);
        }
    }

    public function admin_quick_driver_add(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'FIRST_NAME' => 'required',
                'LAST_NAME' => 'required',
                'MEM_ID' => 'required'
            ],
            [
                'MEM_ID.required' => 'Company Name Is Required.'
            ]
        );

        if ($validator->fails()) {
            return $this->return(false, 'Validation Error.', $validator->errors(), []);
        }

        $driverEmail = $request->input('FIRST_NAME') . $request->input('LAST_NAME') . '@tmsdashboard.com';
        $emailExists = User::where('email', $driverEmail)->exists();

        if ($emailExists) {
            return $this->return(false, 'Validation Error.', ['message' => 'First Name And Last Name Already Taken Pls Use Another Name.'], []);
        }

        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }

        $driver = Driver::create([
            "FIRST_NAME" => $request->input('FIRST_NAME'),
            "LAST_NAME" => $request->input("LAST_NAME"),
            "USERNAME" => $request->input('FIRST_NAME') . $request->input('LAST_NAME'),
            "DRIVER_EMAIL" => $request->input('FIRST_NAME') . $request->input('LAST_NAME') . '@tmsdashboard.com',
            "PASSWORD" => date('mdY'),
            "pin_number" => 1234,
            "STATUS" => 0,
            "MEM_ID" => $request->MEM_ID,
            "CREATED_DATE" => date('Y-m-d'),
        ]);

        $lastDriverId = $driver->SMART_DRIVERID;

        $mailurl = "https://tms.tmdashboard.com/sendgrid/newcard_order.php?ID=" . $lastDriverId;
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $mailurl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            )
        );
        $response = curl_exec($curl);
        curl_close($curl);

        $user = User::create([
            "username" => $driver->USERNAME,
            "email" => $driver->DRIVER_EMAIL,
            "password" => Hash::make($driver->PASSWORD),
            'pincode' => md5($driver->pin_number),
            "userlevel" => 'user',
            "status" => 1,
        ]);
        $lastUserId = $user->id;
        //dd($lastUserId);
        $driverUpdate = Driver::find($lastDriverId);
        $driverUpdate->CLIENT_ID = $lastUserId;
        $driverUpdate->save();

        if ($driver && $user) {
            return $this->return(true, "Driver Added Successfully.", [], $driver);
        } else {
            return $this->return(false, "Error Occured.", ['messsage' => 'Driver Not Added.'], []);
        }
    }

    public function add_load_funds($id)
    {
        $driver = Driver::find($id);
        if ($driver) {
            $data['driver'] = $driver;
            $data['status'] = 'INACTIVE';
            if ($driver->CARD_NUM != '') {
                $efs_data = array('clientID' => getEFSClientID(), 'cardNumber' => $driver->CARD_NUM);
                $return_data = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getcard_api.php', $efs_data);
                $clean_xml = str_ireplace(['soapenv:', 'SOAP:'], '', $return_data);
                $xml = simplexml_load_string($clean_xml);
                $response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $return_data);
                $xml = new \SimpleXMLElement($response);
                $body = $xml->xpath('//soapenvBody')[0];
                $array_getCard = json_decode(json_encode((array) $body), TRUE);
                $data['status'] = $array_getCard['ns5getCardResponse']['result']['header']['status'];
            }
            return $this->return(true, "Driver Fetched Successfully.", [], $data);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found'], []);
        }
    }

    public function store_load_funds(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'amount' => 'required',
            'issue_to' => 'required',
            'driver_id' => 'required'
        ]);

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }
        if ($request->amount <= 0) {
            return $this->return(false, "Validation Error.", ['message' => 'Amount Must Be Greater Then 0.'], []);
        }

        $user = Auth::guard('api')->user();
        $driver = Driver::find($request->driver_id);
        if ($driver) {
            $card = $driver->CARD_NUM;
            $load_fund = new DriverFund();

            $load_fund->driver_id = $request->driver_id;
            $load_fund->amount = $request->amount;
            $load_fund->issue_to = $request->issue_to;
            $load_fund->notes = $request->notes;
            $load_fund->created_at = date('Y-m-d');
            $load_fund->save();
            $lastId = $load_fund->id;
            if (!empty(Auth::user()->contract_id)) {
                $data = [
                    'clientID' => getEFSClientID(),
                    'cardNumber' => $card,
                    'amount' => $load_fund->amount,
                    'refNumber' => $load_fund->issue_to,
                    'notes' => $load_fund->notes,
                    'currency' => 'USD'
                ];
                if (env('EFS_ON', 0) == 1) {
                    $return_data = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/loadCash_api.php', $data);
                    $output = json_decode($return_data);
                    $output1 = json_decode($return_data, true);
                    if (!empty($output1['ns5issueMoneyCodeResponse']['result']['code'])) {
                        $res_code = $output1['ns5issueMoneyCodeResponse']['result']['code'];
                        $load_fund = DriverFund::find($lastId);
                        $load_fund->ref_id = $res_code;
                        $load_fund->update();
                    }
                }
            }
            if ($load_fund) {
                return $this->return(true, "Driver Fund Added Successfully.", [], $load_fund);
            } else {
                return $this->return(false, "Error Occured.", ['message' => 'Driver Fund Not Added.'], []);
            }
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'Driver Fund Not Added.'], []);
        }

    }

    public function driver_edit(Request $request, $id, $mode = '')
    {
        $curre_user = Auth::guard('api')->user();
        if (!$curre_user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied'], []);
        }
        $user_id = ($id) ? $id : $curre_user->id;
        $driver = Driver::where('SMART_DRIVERID', $id)->first();
        if ($driver) {
            $getuser = User::find($driver->CLIENT_ID);
            $data['user'] = $getuser;
            $data['driver'] = $driver;
            if (Auth::user()->userlevel == 'admin') {
                $data['driver_fund'] = DriverFund::with('drivers')->where('driver_id', $id)->orderBy('id', 'DESC')->limit(10)->get();
            } else if (Auth::user()->userlevel == 'supervisor') {
                $abc = DriverFund::where('driver_id', $id)->pluck('driver_id');
                $item = Driver::whereIn('SMART_DRIVERID', $abc)->where('MEM_ID', Auth::user()->id)->pluck('SMART_DRIVERID');
                $data['driver_fund'] = DriverFund::whereIn('driver_id', $item)->orderBy('id', 'DESC')->limit(10)->get();
            }
            $apiData = [];
            $array_getCard = [];
            if ($driver->CARD_NUM) {
                $efsData = [
                    'clientID' => getEFSClientID(),
                    'cardNumber' => $driver->CARD_NUM
                ];
                $response = CallApi('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getSmartPayDriver_api.php', $efsData);
                $responseData = json_decode($response);
                if (!empty($responseData->ns5getSmartPayDriverResponse->result)) {
                    $apiData = $responseData->ns5getSmartPayDriverResponse->result;
                    $data['driver']->FIRST_NAME = $apiData->firstName;
                    $data['driver']->LAST_NAME = $apiData->lastName;
                    $data['driver']->ADDRESS = $apiData->address;
                    $data['driver']->CITY = $apiData->city;
                    $data['driver']->STATE = $apiData->state;
                    $data['driver']->POSTAL = $apiData->postalCode;
                    $data['driver']->COUNTRY = $apiData->country;
                    $data['driver']->DOB = $apiData->dob;
                    if (empty($data['driver']->SSN_NUM)) {
                        $data['driver']->SSN_NUM = '000-00-' . $apiData->last4ss;
                    }
                    $data['driver']->DRIVER_EMAIL = $apiData->email;
                    $data['driver']->DRIVER_PHONE = $apiData->phone;
                }
            }
            return $this->return(true, "Profile Fetched Successfully.", [], $data);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found.'], []);
        }
    }

    public function driver_card_details(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'CARD_NUM' => 'required',
                'CSV_NUM' => 'required|digits:3',
                'EXPIRES' => 'required',
                'id' => 'required'
            ],
            [
                'CSV_NUM.digits' => 'Please Enter 3-digits CSV Number.'
            ]
        );

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $driver = Driver::find($request->id);
        if ($driver) {
            $driver->CARD_NUM = $request->CARD_NUM;
            $driver->CSV_NUM = $request->CSV_NUM;
            $driver->EXPIRES = $request->EXPIRES;
            $driver->SUB_STATUS = 'Processed';
            $driver->update();
            if ($driver) {
                return $this->return(true, "Driver's Details Updated Successfully.", [], $driver);
            } else {
                return $this->return(false, "Error Occured.", ['message' => "Driver's Data Not Updated."], []);
            }
        } else {
            return $this->return(false, "Error Occured.", ['message' => "Driver's Data Not Updated."], []);
        }

    }

    public function driver_actions(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'username' => 'required',
            'password_confirmation' => 'same:password',
            'userid' => 'required'
        ]);

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $driverEmail = $request->email;
        $emailExists = User::where('id', '!=', $request->userid)->where('email', $driverEmail)->exists();

        if ($emailExists) {
            return $this->return(false, "Validation Error.", ['message' => 'Email is Already Been Taken Pls Use Another Email'], []);
        }

        $user = User::find($request->input('userid'));
        if ($user) {
            $driver = Driver::where('CLIENT_ID', $user->id)->first();
            $driver->DRIVER_EMAIL = $request->input('email');
            $driver->USERNAME = $request->input('username');
            $driver->PASSWORD = $request->input('password');
            $driver->pin_number = $request->input('pin_number');
            $driver->save();
            $userID = $driver->CLIENT_ID;
            if (!empty($userID)) {
                $userUpdate = User::find($userID);
                $userUpdate->username = $request->input('username');
                $userUpdate->email = $request->input("email");
                $userUpdate->password = Hash::make($request->input('password'));
                $userUpdate->pincode = md5($request->input('pin_number'));
                $userUpdate->two_factor = $request->input('two_factor');
                $userUpdate->save();
            }
            if ($driver && $userUpdate) {
                return $this->return(true, "Driver Updated Successfully.", [], $driver);
            } else {
                return $this->return(false, "Error Occured.", ['message' => 'Driver Not Updated.'], []);
            }
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found.'], []);
        }

    }

    public function driver_card_pin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'CARD_PIN' => 'required|digits:4',
            'driverid' => 'required',
            'STATUS' => 'required'
        ], [
                'CARD_PIN.digits' => 'Please enter a 4-digit card PIN.',
            ]);

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }
        $driver = Driver::find($request->driverid);
        if ($driver) {
            $driver->STATUS = $request->get('STATUS');
            $driver->CARD_PIN = $request->get('CARD_PIN', null);
            $name = $driver->FIRST_NAME . ' ' . $driver->LAST_NAME;

            if ($driver->STATUS != $request->input('STATUS')) {
                $driver_status = new DriverStatus();
                $driver_status->new_status = $request->input('STATUS');
                $driver_status->old_status = $driver->STATUS;
                $driver_status->driver_id = $driver->SMART_DRIVERID;
                $driver_status->date_time = date('Y-m-d');
                $driver_status->user_id = $user->id;
                $driver_status->save();
            }


            if (!empty($driver->CARD_NUM)) {
                $cardNumber = $driver->CARD_NUM;
                $pin = $request->get('CARD_PIN');
                if (!empty($pin)) {
                    $efsdata = [
                        'clientID' => getEFSClientID(),
                        'cardNumber' => $cardNumber,
                        'newPin' => $pin
                    ];
                    $response = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/setcardpin_api.php', $efsdata);
                }
            }

            if (!empty($driver->CARD_NUM)) {
                $data = array('clientID' => getEFSClientID(), 'cardNumber' => $driver->CARD_NUM);
                $return_data = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getcard_api.php', $data);
                $clean_xml = str_ireplace(['soapenv:', 'SOAP:'], '', $return_data);

                $xml = simplexml_load_string($clean_xml);
                $response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $return_data);
                $xml = new \SimpleXMLElement($response);
                $body = $xml->xpath('//soapenvBody')[0];
                $array_getCard = json_decode(json_encode((array) $body), TRUE);
                $status = $driver->STATUS == '1' ? 'ACTIVE' : 'INACTIVE';

                if (!empty($array_getCard['ns5getCardResponse']['result']['header'])) {
                    $header = $array_getCard['ns5getCardResponse']['result']['header'];
                } else {
                    $header = array(
                        'companyXRef' => '',
                        'handEnter' => '',
                        'infoSource' => 'BOTH',
                        'limitSource' => '',
                        'locationOverride' => '',
                        'locationSource' => '',
                        'overrideAllLocations' => '',
                        'originalStatus' => '',
                        'payrollStatus' => 'FOLLOWS',
                        'override' => 0,
                        'policyNumber' => '0',
                        'status' => $status,
                        'timeSource' => 'BOTH',
                        'lastUsedDate' => '',
                        'lastTransaction' => '',
                        'payrollUse' => 'N',
                        'payrollAtm' => 'DISALLOW',
                        'payrollChk' => 'DISALLOW',
                        'payrollAch' => 'DISALLOW',
                        'payrollWire' => 'DISALLOW',
                        'payrollDebit' => 'DISALLOW'
                    );
                }
                $data = array('clientID' => getEFSClientID(), 'cardNumber' => $driver->CARD_NUM, 'status' => $status, 'NAME' => $name, 'UNIT' => '0', 'DRID' => $driver->SMART_DRIVERID, 'companyXRef' => $header['companyXRef'], 'handEnter' => $header['handEnter'], 'infoSource' => $header['infoSource'], 'limitSource' => $header['limitSource'], 'locationOverride' => $header['locationOverride'], 'locationSource' => $header['locationSource'], 'overrideAllLocations' => $header['overrideAllLocations'], 'originalStatus' => '', 'payrollStatus' => $header['payrollStatus'], 'override' => $header['override'], 'policyNumber' => $header['policyNumber'], 'timeSource' => $header['timeSource'], 'lastUsedDate' => '', 'lastTransaction' => $header['lastTransaction'], 'payrollUse' => $header['payrollUse'], 'payrollAtm' => $header['payrollAtm'], 'payrollChk' => $header['payrollChk'], 'payrollAch' => $header['payrollAch'], 'payrollWire' => $header['payrollWire'], 'payrollDebit' => $header['payrollDebit']);
                $data_setcard = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/setcard_api.php', $data);
                $data_return = json_decode($data_setcard, true);
            }
            $driver->update();
            if ($driver) {
                return $this->return(true, "Driver's Details Updated Successfully", [], $driver);
            } else {
                return $this->return(false, "Error Occured.", ['message' => 'Driver Not Updated.'], []);
            }
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found.'], []);
        }

    }

    public function driver_personal_data(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ADDRESS' => 'required',
            'CITY' => 'required',
            'STATE' => 'required',
            'POSTAL' => 'required',
            'COUNTRY' => 'required',
            'DOB' => 'required',
            'SSN_NUM' => 'required',
            'DRIVER_PHONE' => 'required',
            'SUB_STATUS' => 'required',
            'userid' => 'required'
        ]);

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }
        $auth_user = Auth::guard('api')->user();
        if(!$auth_user){
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }
        $user = User::find($request->input('userid'));
        $driver = Driver::where('CLIENT_ID', $user->id)->first();
        if ($request->set_smart_driver != '' && !empty($driver->CARD_NUM)) {
            $efsdata = [
                'clientID' => getEFSClientID(),
                'cardNumber' => $driver->CARD_NUM,
                'firstName' => $driver->FIRST_NAME,
                'lastName' => $driver->LAST_NAME,
                'address' => $request->input('ADDRESS'),
                'city' => $request->input('CITY'),
                'state' => $request->input('STATE'),
                'postalCode' => $request->input('POSTAL'),
                'country' => $request->input('COUNTRY'),
                'dob' => date('d/m/Y', strtotime($request->input('DOB'))),
                'last4ss' => substr($request->input('SSN_NUM'), -4),
                'email' => $driver->DRIVER_EMAIL,
                'phone' => str_replace(['(', ')', '-'], '', $request->input('DRIVER_PHONE'))
            ];
            $response = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/setSmartPayDriver_api.php', $efsdata);
        }
        if ($driver->SUB_STATUS != $request->input('SUB_STATUS')) {
            $driver_status = new DriverStatus();
            $driver_status->new_sub_status = $request->input('SUB_STATUS');
            $driver_status->old_sub_status = $driver->SUB_STATUS;
            $driver_status->driver_id = $driver->SMART_DRIVERID;
            $driver_status->date_time = date('Y-m-d');
            $driver_status->user_id = $auth_user->id;
            $driver_status->save();
        }
        $driver->ADDRESS = $request->input('ADDRESS');
        $driver->CITY = $request->input('CITY');
        $driver->STATE = $request->input('STATE');
        $driver->POSTAL = $request->input('POSTAL');
        $driver->COUNTRY = $request->input('COUNTRY');
        $driver->DOB = $request->input('DOB');
        $driver->SSN_NUM = $request->input('SSN_NUM');
        $driver->DRIVER_PHONE = $request->input('DRIVER_PHONE');
        $driver->SUB_STATUS = $request->input('SUB_STATUS');
        $driver->save();
        if ($driver) {
            return $this->return(true, "Driver Updated Successfully", [], $driver);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'Driver Not Updated'], []);
        }
    }

    public function driver_delete($id)
    {
        $driver = Driver::find($id);
        if ($driver) {
            $userID = $driver->CLIENT_ID;
            if (!empty($userID)) {
                $userUpdate = User::find($userID);
                $userUpdate->delete();
            }
            $driver = $driver->delete();
            if ($driver) {
                return $this->return(true, "Driver Deleted Successfully.", [], []);
            } else {
                return $this->return(false, "Error Occured.", ['message' => "Driver Not Delete."], []);
            }
        } else {
            return $this->return(false, "Error Occured.", ['message' => "No Data Found."], []);
        }

    }

    public function get_cashavailable($driverId)
    {
        $driver = Driver::find($driverId);
        if ($driver) {
            if ($driver->CARD_NUM != '') {
                $efsdata = [
                    'clientID' => getEFSClientID(),
                    'cardNumber' => $driver->CARD_NUM
                ];
                $response = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getcurrentcashall_api.php', $efsdata);
                $responseData = json_decode($response);
                $cashAvailable = 0;
                if (!empty($responseData->ns5getCurrentCashAllAmountsResponse)) {
                    $cashAvailable = $responseData->ns5getCurrentCashAllAmountsResponse->result->value->cashAvailable;
                    $driver->cashAvailable = $cashAvailable;
                    $driver->save();
                }
                $data['cash'] = $cashAvailable;
                return $this->return(true, "Balance Fetched Successfully.", [], $data);
            } else {
                $data['cash'] = '0.00';
                return $this->return(false, "Error Occcured.", ['message' => 'Error When Fetching The Data.'], $data);
            }
        } else {
            return $this->return(false, "Error Occcured.", ['message' => 'No Data Found.'], []);
        }

    }

    public function card_info($driverId)
    {
        $driver = Driver::find($driverId);
        if ($driver) {
            if ($driver->CARD_NUM != '') {
                $efs_data = array('clientID' => getEFSClientID(), 'cardNumber' => $driver->CARD_NUM);
                $return_data = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getcard_api.php', $efs_data);
                $clean_xml = str_ireplace(['soapenv:', 'SOAP:'], '', $return_data);
                $xml = simplexml_load_string($clean_xml);
                $response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $return_data);
                $xml = new \SimpleXMLElement($response);
                $body = $xml->xpath('//soapenvBody')[0];
                $array_getCard = json_decode(json_encode((array) $body), TRUE);
                $data['card_info'] = $array_getCard['ns5getCardResponse']['result'];
                return $this->return(true, "Card Data Fetched Successfully.", [], $data);
            } else {
                $data['card_info'] = [];
                return $this->return(false, "Error Occured.", ['message' => 'Card Data Not Fetched.'], $data);
            }
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found.'], []);
        }
    }

    public function liveSmartDriverData($id)
    {
        $driver = Driver::find($id);
        if (!empty($driver->CARD_NUM)) {
            $efsData = [
                'clientID' => getEFSClientID(),
                'cardNumber' => $driver->CARD_NUM
            ];
            $response = CallApi('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getSmartPayDriver_api.php', $efsData);
            $responseData = json_decode($response);
            if (!empty($responseData->ns5getSmartPayDriverResponse->result)) {
                return $this->return(true, 'Driver Fetched Successfully.', [], $responseData->ns5getSmartPayDriverResponse->result);
            } else {
                return $this->return(false, 'Error Occured.', ['message' => 'No Data Found'], []);
            }
        } else {
            return $this->return(false, 'Error Occured.', ['message' => 'No Data Found'], []);
        }
    }

    public function driver_profile(Request $request, $id = false)
    {
        $curre_user = Auth::guard('api')->user();
        if (!$curre_user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }
        $user_id = ($id) ? $id : $curre_user->id;
        $getuser = DB::table(USERS_TABLE)->where('id', '=', $user_id)->first();
        $driver = Driver::where('CLIENT_ID', $user_id)->first();

        $data['driver'] = $driver;
        $data['user'] = $getuser;
        $apiData = [];
        if (!empty($driver->CARD_NUM)) {
            $efsData = [
                'clientID' => getEFSClientID(),
                'cardNumber' => $driver->CARD_NUM
            ];
            $response = CallApi('POST', 'https://tms.tmdashboard.com/api/esfAPIS/getSmartPayDriver_api.php', $efsData);
            $responseData = json_decode($response);
            if (!empty($responseData->ns5getSmartPayDriverResponse->result)) {

                $apiData = $responseData->ns5getSmartPayDriverResponse->result;
                $data['driver']->FIRST_NAME = $apiData->firstName;
                $data['driver']->LAST_NAME = $apiData->lastName;
                $data['driver']->ADDRESS = $apiData->address;
                $data['driver']->CITY = $apiData->city;
                $data['driver']->STATE = $apiData->state;
                $data['driver']->POSTAL = $apiData->postalCode;
                $data['driver']->COUNTRY = $apiData->country;
                $data['driver']->DOB = $apiData->dob;
                if (empty($data['driver']->SSN_NUM)) {
                    $data['driver']->SSN_NUM = '000-00-' . $apiData->last4ss;
                }
                $data['driver']->DRIVER_EMAIL = $apiData->email;
                $data['driver']->DRIVER_PHONE = $apiData->phone;
            }
        }
        if ($data['driver']) {
            return $this->return(true, "Driver Fetched Successfully.", [], $data);
        } else {
            return $this->return(false, "Error Occured.", ['message' => 'Driver Not Fetched.'], []);
        }
    }

    public function user_send_form(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'username' => 'required|unique:users,username',
            'email' => 'required|email|unique:users,email',
            'CARD_PIN' => 'required',
            'driverid' => 'required',
            'two_factor' => 'required',
            'password' => 'required',
            'pincode' => 'required',
            'userid' => 'required'
        ], [
                'username.required' => admin_lang('username_required'),
                'username.unique' => admin_lang('username_not_unique'),
                'email.required' => admin_lang('email_required'),
                'email.email' => admin_lang('email_correct'),
                'email.unique' => admin_lang('email_not_unique'),
            ]);

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $user = Auth::guard('api')->user();
        if (!$user) {
            return $this->return(false, "Error Occured.", ['message' => 'Access Denied.'], []);
        }
        if ($request->get('action') == 'setcardpin') {
            $driverId = safe_input($request->get('driverid'), false);
            $driver = Driver::where('CLIENT_ID', $user->id)->first();
            $driver->CARD_PIN = $request->get('CARD_PIN', null);
            if (!empty($driver->CARD_NUM)) {
                $cardNumber = $driver->CARD_NUM;
                $pin = $request->get('CARD_PIN');
                if (!empty($pin)) {
                    $efsdata = [
                        'clientID' => getEFSClientID(),
                        'cardNumber' => $cardNumber,
                        'newPin' => $pin
                    ];
                    $response = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/setcardpin_api.php', $efsdata);
                }
            }
            $driver->save();
            return $this->return(true, 'Card PIN Is Set Successfully.', [], []);
        }

        $user_id = $request->get('userid');
        DB::table(USERS_TABLE)->where(['id' => $user_id])->update([
            'username' => safe_input($request->get('username'), false),
            'email' => safe_input($request->get('email'), false),
            'two_factor' => safe_input($request->get('two_factor'), false),
            'updated_at' => now(),
        ]);
        if ($user->userlevel == "user") {
            $driver = Driver::where('CLIENT_ID', $user_id)->first();
            if($driver){
                $driver->DRIVER_EMAIL = safe_input($request->get('email'), false);
                $driver->USERNAME = safe_input($request->get('username'), false);
                $driver->update();
            }else{
                return $this->return(false, 'Error Occured.', ['message' => 'Driver Not Found'], []);
            }

        } else {
            $user_id = DB::table(USERS_TABLE)->insertGetId([
                'username' => safe_input($request->get('username'), false),
                'email' => safe_input($request->get('email'), false),
                'remember_token' => NULL,
                'active_key' => NULL,
                'updated_at' => now(),
                'created_at' => now(),
            ]);
        }

        if ($user->userlevel == 'admin') {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update([
                'userlevel' => safe_input($request->get('userlevel'), false),
                'status' => safe_input($request->get('status'), false)
            ]);
        }

        if ($request->has('password') and !empty($request->get('password'))) {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['password' => Hash::make($request->get('password'))]);
            if ($user->userlevel == "user") {
                $driver = Driver::where('CLIENT_ID', $user_id)->first();
                $driver->PASSWORD = safe_input($request->get('password'), false);
                $driver->update();
            }
        }

        if ($request->has('pincode') and !empty($request->get('pincode'))) {
            DB::table(USERS_TABLE)->where(['id' => $user_id])->update(['pincode' => md5($request->get('pincode'))]);
            if ($user->userlevel == "user") {
                $driver = Driver::where('CLIENT_ID', $user_id)->first();
                $driver->pin_number = safe_input($request->get('pincode'), false);
                $driver->update();
            }
        }
        if ($driver) {
            return $this->return(true, 'Driver Updated Successfully.', [], $driver);
        } else {
            return $this->return(false, 'Error Occured.', ['message' => 'Driver Not Updated'], []);
        }
    }

    public function personal_data_add(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ADDRESS' => 'required',
            'CITY' => 'required',
            'STATE' => 'required',
            'POSTAL' => 'required',
            'COUNTRY' => 'required',
            'DOB' => 'required',
            'SSN_NUM' => 'required',
            'DRIVER_PHONE' => 'required',
            'driverid' => 'required'
        ]);

        if ($validator->fails()) {
            return $this->return(false, "Validation Error.", $validator->errors(), []);
        }

        $driver = Driver::find($request->driverid);
        if($driver){
            $driver->ADDRESS = $request->ADDRESS;
            $driver->CITY = $request->CITY;
            $driver->STATE = $request->STATE;
            $driver->POSTAL = $request->POSTAL;
            $driver->COUNTRY = $request->COUNTRY;
            $driver->DOB = $request->DOB;
            $driver->SSN_NUM = $request->SSN_NUM;
            $driver->DRIVER_PHONE = $request->DRIVER_PHONE;

            if (!empty($driver->CARD_NUM)) {
                $efsdata = [
                    'clientID' => getEFSClientID(),
                    'cardNumber' => $driver->CARD_NUM,
                    'firstName' => $driver->FIRST_NAME,
                    'lastName' => $driver->LAST_NAME,
                    'address' => $driver->ADDRESS,
                    'city' => $driver->CITY,
                    'state' => $driver->STATE,
                    'postalCode' => $driver->POSTAL,
                    'country' => $driver->COUNTRY,
                    'dob' => date('d/m/Y', strtotime($driver->DOB)),
                    'last4ss' => substr($driver->SSN_NUM, -4),
                    'email' => $driver->DRIVER_EMAIL,
                    'phone' => str_replace(['(', ')', '-'], '', $driver->DRIVER_PHONE)
                ];
                $response = CallAPI('POST', 'https://tms.tmdashboard.com/api/esfAPIS/setSmartPayDriver_api.php', $efsdata);
            }
            $driver->update();
            if ($driver) {
                return $this->return(true, "Personal Data Updated Successfully.", [], $driver);
            } else {
                return $this->return(false, "Error Occured.", ['message' => 'Personal Data Not Updated.'], []);
            }
        }else{
            return $this->return(false, "Error Occured.", ['message' => 'No Data Found.'], []);
        }

    }

}
