<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers;

use Illuminate\Routing\Controller as BaseController;
use hisorange\BrowserDetect\Parser as Browser;
use Illuminate\Support\Facades\DB;
use Illuminate\Foundation\Validation\ValidatesRequests;

class Controller extends BaseController
{
    use ValidatesRequests;
    private $get_extensions;

    public function __construct()
    {
        set_site_config();
        $this->lood_extension();
        $this->lood_theme();
    }

    public function admin_handle_permission($type)
    {
        return redirect(get_admin_url('/'));
    }

    public function query_comments($type, $id, $cparent = 0){
        
        $comments = DB::table(COMMENTS_TABLE)->where([
            ['ctype', '=', $type], 
            ['cpid', '=', $id], 
            ['cstatus', '=', '1'], 
            ['cparent', '=', $cparent], 
            ['spam_trash', '=', '0']
        ])->orderBy('cmodified', 'ASC')->latest('cmodified');

        return $comments;
    }

    public function browser_detect(){
        $browser_detect = [
            'ip'                => GetRealIp(),
            'useragent'         => Browser::userAgent(),
            'platformname'      => Browser::platformName(),
            'browserfamily'     => Browser::browserFamily(),
        ];
        return $browser_detect;
    }

    public function lood_extension()
    {
        $extensions = (is_serialized(get_option('start_extensions')))? maybe_unserialize(get_option('start_extensions')) : array();
        foreach($extensions as $extension){
            if(file_exists(extension_path($extension.'/extension.php')) && array_key_exists($extension, $this->get_extensions)){
                include(extension_path($extension.'/extension.php'));
            }
        }
    }

    public function lood_theme()
    {
        $theme = get_option('theme', 'default') ;
        include(theme_path($theme.'/options.php'));
    }

}
