<?php
/**
 * Project: PHP Help Manager
 * @link http://themearabia.net
 * @copyright 2021
 * @author Hossam Hamed <themearabia@gmail.com> <0201094140448>
 * @version 5.0
 */

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use TorMorten\Eventy\Facades\Events as Eventy;
use File;

class AdminAjaxController extends Controller
{

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
    }
    
    public function adminajax(Request $request)
    {
        if($request->has('action') and $request->get('action') == 'megapanel_geticons'){
            $json_files['linearicons'] = ['title' => 'Linearicons', 'file' => public_path('public/dashboard/json/linearicons.json')];
            $json_files['peicon7stroke'] = ['title' => 'Pe Icon 7 Stroke', 'file' => public_path('public/dashboard/json/peicon7stroke.json')];
            $json_files['boxicons'] = ['title' => 'Box icons', 'file' => public_path('public/dashboard/json/boxicons.json')];
            $json_files['fontawesome'] = ['title' => 'Font Awesome', 'file' => public_path('public/dashboard/json/fontawesome.json')];
            foreach($json_files as $key => $file){
                echo '<div class="megapanel-options-head-items">
                <h3><span class="megapanel-title-item">'.$file['title'].'</span><span class="megapanel_tools collapse-button"><i class="fa fa-minus"></i></span></h3>
                <div class="megapanel-options-content megapanel-toggle-content ">';
                if( file_exists($file['file']) ) {
                    $object = json_decode(File::get($file['file']));
                    if( is_object( $object ) ) {
                        foreach ( $object->icons as $icon ) {
                            echo '<a class="tacf-icon-selector" data-seticon="'. $icon .'"><i class="'. $icon .'"></i></a>';
                        }
                    } else {
                        echo '<h4 class="megapanel-dialog-title">Error! Can not load json file.</h4>';
                    }
                }
                else
                {
                    echo '<h4 class="megapanel-dialog-title">Error! not found json file.</h4>';
                }
                echo '</div></div>';
            }
        }
        elseif($request->has('action') and $request->get('action') == 'savemenuitem'){
            return json_encode($request->get('menu-item'));
        }
        elseif($request->has('action') and $request->get('action') == 'addmenuitem'){
            $key                = intval($request->get('itemid'));
            $value['title']     = ($request->has('title'))? $request->get('title') : '';
            $value['icon']      = ($request->has('icon'))? $request->get('icon') : '';
            $value['url']       = ($request->has('url'))? $request->get('url') : '';
            $value['type']      = ($request->has('type'))? $request->get('type') : '';
            $value['linkhtml']  = '';
            $value['linkphp']   = '';
            $value['classes']   = '';
            $value['target']    = '';
            $value['depth']     = '';
            $value['parent']    = '';
            $html = get_loop_nav_menu_list($key, $value);
            $arr = array('status' => 'success', 'html' => $html);
            return json_encode($arr);
        }
        elseif($request->has('action') and $request->get('action') == 'options_widget_homepage'){
            if(safe_input($request->get('option')))
            {
                $widget_data = explode('|', safe_input($request->get('widget')));
                $data = ['key' => $widget_data[1], 'widget' => [], 'option_name' => $widget_data[0]];
                $options = Eventy::filter('action_widgets_options_'.safe_input($request->get('option')), $data);
                return response()->json(['status' => true, 'html' => $options]);
            }
            else {
                return response()->json(['status' => 0, 'html' => '']);
            }
        }
        elseif($request->has('action') and $request->get('action') == 'widget_get_boxs_element'){
            if(safe_input($request->get('option')))
            {
                $opkey  = safe_input($request->get('opkey'));
                $opname = safe_input($request->get('opname'));
                $data   = ['key' => $opkey, 'widget' => [], 'option_name' => $opname];
                $boxs   = Eventy::filter('action_widget_get_boxs_element_'.safe_input($request->get('option')), $data);
                echo '<div class="ul-element-widget">';
                if($boxs and is_array($boxs))
                {
                    foreach ( $boxs as $box ) {
                        echo '<a class="element-box-select itme-search" data-search="'.$box['title'].'">
                        '.$box['title'].'
                            <li style="display: none;" class="tacf-row-sub tacf-set-element">
                                <span class="ui-sortable-handle-sub" title="move"><i class="bx bx-move"></i></span>
                                <span class="tacf-remove-sub" title="Remove"><i class="bx bxs-trash-alt"></i></span>
                                <input type="hidden" name="'.$opname.'['.$opkey.'][boxs][]" value="'.$box['id'].'">
                                <label>'.$box['title'].'</label>
                            </li>
                        </a>';
                    }
                }
                echo '</div>';
            }
            else {
                echo 'error 21E';
            }
        }
    }

    public function adminajax_articleeditor($action = false, Request $request)
    {
        if($action == 'upload'){
            $upfiles = [];
            $user = Auth::user();
            $path_upload = public_path() . '/uploads/megaeditor/';
            $url_upload  = url('/uploads/megaeditor');
            if ($request->hasFile('file')) {
                $x = 0;
                foreach ($request->file('file') as $file) {
                    $x++;
                    $mimes  = $file->getClientOriginalExtension();
                    $name   = $file->getClientOriginalName();
                    $size   = $file->getSize();
                    $file_name = 'attach_' . $x . '-' . time() . '.' . $mimes;
                    $file->move($path_upload, $file_name);
                    $post_id = insert_post(['post_author' => $user->id, 'post_title' => $name, 'post_type' => 'attachment']); 
                    update_post_meta('file', $file_name, $post_id);
                    update_post_meta('mimes', $mimes, $post_id);
                    update_post_meta('size', $size, $post_id);
                    $upfiles['file'.$post_id] = array(
                        'url' => url('/uploads/megaeditor/'.$file_name),
                        'id'  => 'image-'.$post_id,
                    );
                }
                return response()->json($upfiles);
            }
            else
            {

            }
        }
        elseif($action == 'images'){
            $attachments = DB::table(ATTACHMENTS_TABLE)->orderBy('at_modified', 'desc')->get();
            if($attachments->count())
            {
                foreach($attachments as $attach)
                {
                    $file = get_attachment_url($attach->at_id, 'full');;
                    $images[] = array(
                        'id'    => $attach->at_id,
                        'title' => $attach->at_title,
                        'thumb' => $file,
                        'url'   => $file,
                    );
                }
            }
            return response()->json($images);

        }
        elseif($action == 'templates'){
            $templates['numbers'] = array(
                'name' => 'Numbers',
                'html' => '
                <div class="numbers">
                    <div class="number-item">
                        <p class="number-heading">200</p>
                        <p class="number-description">The Milky Way contains over 200 billion stars, and enough dust and gas to make billions more.</p>
                    </div>
                    <div class="number-item">
                        <p class="number-heading">30,000</p>
                        <p class="number-description">The solar system lies about 30,000 light-years from the galactic center, and about 20 light-years above the plane of the galaxy.</p>
                    </div>
                    <div class="number-item">
                        <p class="number-heading">400</p>
                        <p class="number-description">Recent measurements of the Milky Way have weighed the galaxy at between 400 billion and 780 billion times the mass of the sun.</p>
                    </div>
                </div>'
                );
                
                $templates['numbers2'] = array(
                'name' => 'Numbers2',
                'html' => '
                <div class="numbers">
                    <div class="number-item">
                        <p class="number-heading">200</p>
                        <p class="number-description">The Milky Way contains over 200 billion stars, and enough dust and gas to make billions more.</p>
                    </div>
                    <div class="number-item">
                        <p class="number-heading">30,000</p>
                        <p class="number-description">The solar system lies about 30,000 light-years from the galactic center, and about 20 light-years above the plane of the galaxy.</p>
                    </div>
                    <div class="number-item">
                        <p class="number-heading">400</p>
                        <p class="number-description">Recent measurements of the Milky Way have weighed the galaxy at between 400 billion and 780 billion times the mass of the sun.</p>
                    </div>
                </div>'
                );

                $templates['numbers3'] = array(
                'name' => 'Numbers3',
                'html' => '
                <div class="numbers">
                    <div class="number-item">
                        <p class="number-heading">200</p>
                        <p class="number-description">The Milky Way contains over 200 billion stars, and enough dust and gas to make billions more.</p>
                    </div>
                    <div class="number-item">
                        <p class="number-heading">30,000</p>
                        <p class="number-description">The solar system lies about 30,000 light-years from the galactic center, and about 20 light-years above the plane of the galaxy.</p>
                    </div>
                    <div class="number-item">
                        <p class="number-heading">400</p>
                        <p class="number-description">Recent measurements of the Milky Way have weighed the galaxy at between 400 billion and 780 billion times the mass of the sun.</p>
                    </div>
                </div>'
                );
                        
                return response()->json($templates)->header('Content-Type', 'application/json');
        }
        else {

        }
    }

}
