<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Country;
use App\Models\Area;
use App\Models\State;
use App\Models\City;
use PHPUnit\Framework\Constraint\Count;

use Illuminate\Http\Request;

class AreaController extends Controller
{
 
    private $url_prefix;
    private $page_title;
    private $url_new;
    private $btn_new;
    private $paginate;

    public function __construct()
    {
        $this->middleware('admin');
        parent::__construct();
        $this->url_prefix   = 'Area';
        $this->page_title   = 'Area';
        $this->btn_new      = 'add_new';
        $this->url_new      = get_admin_url('areaadd');
        $this->paginate     = 5;
    }

    public function index_area($type = '',Request $request)
    {
       
       
        $data['type']       = 'users';
        $data['page_class'] = 'area';
        $data['url_prefix'] = $this->url_prefix;
        $data['page_title'] = $this->page_title;
        $data['btn_new']    = $this->btn_new;
        $data['url_new']    = $this->url_new;    
        return get_admin_view('area.index_area',["data"=> $data]);
    }

    public function ajaxlist_area(Request $request){
    
        if($request->ajax())
        {
            $data['type']       = 'users';
            $data['page_class'] = 'area';
            $data['url_prefix'] = $this->url_prefix;
            $data['page_title'] = $this->page_title;
            $data['btn_new']    = $this->btn_new;
            $data['url_new']    = $this->url_new;
            $area=new Area();
         
            $area = Area::orderBy('created_at', 'DESC');
          
            if($request->get('s')){
                $search = $request->get('s');
                $area->orWhere('city_id', 'LIKE', "%{$search}%");                             
                $area->orWhere('area_name', 'LIKE', "%{$search}%");
                $area->orWhere('area_name_gj', 'LIKE', "%{$search}%");
                $area->orWhere('created_at', 'LIKE', "%{$search}%");
                $area->orWhere(function ($query) use ($search) {
                    $query->whereHas('city', function ($q) use ($search) {
                        $q->where('city_name', 'LIKE', '%' . $search . '%');
                    });
                });

            }
            $area = $area->paginate($this->paginate);
            if($request->has('page') and $request->get('page') > $area->lastPage()) {return redirect($area->url($area->lastPage()));}
            return get_admin_view('area.ajaxlist_area', ["data"=> $data,'areas'=>$area]);


        }
        
       }

    // index profile
    public function index_areaadd(Request $request)
    {
        $user = Auth::user();
      
          
        $data['page_title']         = "Add Area";
        $type                       = 'users';
        $data['type']               = $type;
        $data['page_class']         = $type;
        $data['action']             = 'addnew';
        $data['user_userlevel']     = $user->userlevel;
        $data['userlevel']          = 'user';
        $data['user_vip']           = '0';
        $data['user_viptime']       = '';
        $data['userid']             = '0';
        $data['user_status']        = '1';
        $data['username']           = '';
        $data['email']              = '';
        $data['admin_language']     = 'en';
        $data['user_permission']    = [];
        $city=City::all();
        return get_admin_view('area.area_edit', ['data'=>$data,"citys"=>$city]);
    }
  
          // add City
          public function area_sendform(Request $request)
          {
         
              $user = Auth::user();
          
               $userid = $request->get('userid');
               $area=Area::create(["city_id"=>$request->input('city_id'),
              "area_name"=>$request->input("area_name"),
              "area_name_gj"=>$request->input("area_name_gj")]);
              if($area){
                  return redirect()->back()->with('success','Area '.$request->input('area_name') . ' added Successfully!');
                }
                else{
                  return redirect()->back()->with('failure', "Area ".$request->input('area_name') . ' Not added');
                }
           
          
          }


          //area profile
          public function area_profile($id =0, Request $request)
          {
  
              $curre_user = Auth::user();
             
              $user_id =  $curre_user->id;
         
              $area=Area::find($id);
              $city=City::all();
           
              if($area){
              
              $getuser = User::find($user_id);
             
              if ($getuser->count()) {
                 
                  $type               = 'users';
                  $user               = $getuser->first();
                  $data['user']       = $user;
                  $data['type']       = $type;
                  $data['page_class'] = $type;
                  $data['action']     = 'update';
                  $data['page_title'] = 'Update Area';
                  $data['user_meta']  = query_user_meta($data['user']->id);
              
                  $datauser                   = $user;
                  $data['user_userlevel']     = $curre_user->userlevel;
                  $data['userlevel']          = $datauser->userlevel;
                  $data['type']               = $datauser->userlevel;
                  $data['page_class']         = $datauser->userlevel;
                  $data['action']             = 'update';
                  $data['userid']             = $datauser->id;
                  $data['username']           = $datauser->username;
                  $data['email']              = $datauser->email;
                  $data['user_status']        = $datauser->status;
                  $data['admin_language']     = get_user_meta('admin_language', $user_id, 'en');
                  $permission                 = maybe_unserialize(get_user_meta('permission', $user_id, []));
                  $data['user_permission']    = (is_array($permission))? $permission : [];
    
                  return get_admin_view('area.profile_area', ["data"=>$data,"area"=>$area,"citys"=>$city]);
              }
          }
      }

           // actions of area
    public function area_actions(Request $request)
    { 
    

        if($request->has('query') && $request->get('query') == 'action')
        {
          
             if($request->get('action') == 'update')
            {
               
                $area=Area::find($request->input('id'));
                $area->city_id = $request->input('city_id');
                $area->area_name = $request->input('area_name');
                $area->area_name_gj = $request->input('area_name_gj');
                if($area->save()){
                  
                    $request->session()->put('success', "Area Updated successfully!");
                    return redirect()->back();
                }else{
                    $request->session()->put('failure', "Area Not Updated!");
                    return redirect()->back();
                }
            }
     else{
      
            $marks = $request->get('mark');
             if(empty($marks)){
                return redirect()->back();
             }
            
             $faileditem=0;
            if($request->get('action') == 'delete' and is_array($marks))
            {
             
                foreach($marks as $markid)
                {
                    $area=Area::find($markid);
                    $success= $area->delete();
                   if(empty($success)){
                    $faileditem= $faileditem+1;
                   }
                }
                if($faileditem==0){
                    $request->session()->put('success', "Selected Area Items are Deleted Successfully!");
                    return redirect()->back();
                }
                else if($faileditem!=0){
                    $request->session()->put('failure', "Selected Area Items are deleted except $faileditem 
                    Area");
                }
                else{
                    $request->session()->put('failure', "Selected Area Items are not deleted");
                    return redirect()->back();
                }
            }       
        }
    }
    }

     // action delete area
     public function index_deletearea($id, $token ,Request $request)
     { 

       $area=Area::find($id);
       $areaname=$area->area_name;
       $area=$area->delete();
       if($area){
         
           $request->session()->put("success", "Area $areaname deleted Successfully!");
           return redirect()->back();
       }else{
         $request->session()->put("failure", "Area $areaname deleted");
         return redirect()->back();
       }
     }



}
