<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DeceasedRequest extends FormRequest
{
  
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
      
        $is_postmortem=$this->input('is_postmortem');
       
       return  [
            #deceased validation rules
            'deceased_surname' => 'required|regex:/^[a-zA-ZÑñ\s]+$/',
            'deceased_name' => 'required|regex:/^[a-zA-ZÑñ\s]+$/',
            'deceased_father_husband_name' => 'required|regex:/^[a-zA-ZÑñ\s]+$/',
            'deceased_surname_gj' => 'required',
            'deceased_name_gj' => 'required',
            'deceased_father_husband_name_gj' => 'required',
            'gender' => 'required',
            'age' => 'not_in:0',
            'birth_date' => 'required',
            'identity_proof' => 'required',
            'identity_proof_file' => 'required|mimes:csv,txt,xlx,xls,pdf,doc,docx',
            'photo' => 'required|mimes:jpeg,png,jpg',
            'entry_no' => 'required|numeric',
           

            //deceased address validation
            'address1' => 'required',
            'country_id' => 'required',
            'state_id' => 'required',
            'city_id' => 'required',
            'area_id' => 'required',
            'pincode' => 'required|numeric|digits:6',

            //graveyard validation
            'graveyard_book_no' => 'required',
            'graveyard_receipt_no' => 'required',
            'graveyard_receipt' => 'required|mimes:csv,txt,xlx,xls,pdf,doc,docx|max:2048',
            'graveyard_id' => 'required',

            // death information validation
            'place_death' => 'required',
            'death_date' => 'required',
            'reason_death' => 'required',
           
            //hospital information validation
            'hospital_letter_file' => 'required|mimes:csv,txt,xlx,xls,pdf,doc,docx',
            "postmortem_fileno"=>"required_if:$is_postmortem,==,Yes",
            "postmortem_date"=>"required_if:$is_postmortem,==,Yes",
            "postmortem_file"=>"required_if:$is_postmortem,==,Yes|mimes:csv,txt,xlx,xls,pdf,doc,docx",
        
            //informer validation
            'informer_name' => 'required|regex:/^[a-zA-ZÑñ\s]+$/',
            'informer_relation' => 'required',

            //informer mobileno validation
            'informer_mobileno' => 'required|regex:/^[-0-9\+]+$/',
            // 'informer_alt_mobileno' => 'regex:/^[-0-9\+]+$/',
         

            //informer address validation
            'informer_address' => 'required',
            'informer_country_id' => 'required',
            'informer_state_id' => 'required',
            'informer_city_id' => 'required',
            'informer_state_id' => 'required',
            'informer_area_id' => 'required',
            'informer_pincode' => 'required|numeric|digits:6',
           
            //informer identity proof file
            'informer_id_proof_file' => 'required|mimes:png,jpeg,csv,txt,xlx,xls,pdf,doc,docx|max:2048',
       

            
        ];
    }

    public function messages()
    {
        return [
            //deceased validation messages
            'deceased_surname.required' => 'Please enter deceased surname',
            'deceased_surname.regex' => 'Please enter valid surname',
            'deceased_name.required' => 'Please enter deceased name',
            'deceased_name.regex' => 'Please enter valid name',
            'deceased_father_husband_name.required' => 'Please enter deceased father or husband name',
            'deceased_father_husband_name.regex' => 'Please enter deceased father or husband valid name',
            'deceased_surname_gj.required' => 'Please enter deceased surname',
            'deceased_name_gj.required' => 'Please enter deceased surname',
            'deceased_father_husband_name_gj.required' => 'Please enter deceased father or husband name valid name',
            'deceased_surname_gj.required' => 'Please enter deceased surname',
            'deceased_name_gj.required' => 'Please enter deceased surname',
            'gender.required' => 'Please select deceased gender',
            'age.not_in' => 'Invalid age please select deceased correct date of birth',
            'birth_date.required' => 'Please select deceased birthdate',
            'identity_proof.required' => 'Please select deceased available identity proof',
            'identity_proof_file.required' => 'Please upload deceased identity proof file',
            'photo.required' => 'Please upload deceased photo',

            //deceased Address validation message
            'address1.required' => 'Please enter deceased address1',
            'country_id.required' => 'Please select deceased country',
            'state_id.required' => 'Please select deceased state',
            'city_id.required' => 'Please select deceased city',
            'area_id.required' => 'Please select deceased area',
            'pincode.required' => 'Please enter deceased area pincode',
            'pincode.numeric' => 'Please enter valid deceased area pincode',
            'pincode.digits' => 'Please enter 6 digit pincode',
            
            //deceased graveyard validation message
            'entry_no.required' => 'Please enter entryno',
            'entry_no.numeric' => 'Please enter valid entryno', 
            'graveyard_book_no' => 'Please enter graveyard bookno',
            'graveyard_receipt_no' => 'Please enter graveyard receipt no',
            'graveyard_receipt' => 'Please upload graveyard receipt',
            'graveyard_id' => 'Please select graveyard',

             // death information validation message
            'place_death.required' => 'Please select deceased death place',
            'reason_death.required' => 'Please select death reason of deceased',

            // hospital information validation message
            'hospital_letter_file.required' => 'Please upload hospital letter file',
            "postmortem_fileno.required"=>"Please enter postmortem fileno",
            "postmortem_file.required"=>"Please upload postmortem file",
            

            //informer validation message
            'informer_name.required' => 'Please enter informer name',
            'informer_name.regex' => 'Please enter valid informer name',
            'informer_relation.required' =>'Please select informer relation with deceased',

            //informer mobileno validation message
            'informer_mobileno.required' => 'Please enter informer mobileno',
            'informer_mobileno.regex' => 'Please enter informer valid mobileno',
            // 'informer_alt_mobileno.regex' => 'Please enter valid informer alt mobileno',

              //informer address validation message
              'informer_address.required' => 'Please enter informer address',
              'informer_country_id.required' => 'Please select informer country',
              'informer_state_id.required' => 'Please select informer state',
              'informer_city_id.required' => 'Please select informer city',
              'informer_area_id.required' => 'Please select informer city area',
              'informer_pincode.required' => 'Please enter area pincode of informer',
              'informer_pincode.numeric' => 'Please enter valid area pincode of informer',
              'informer_pincode.digits' => 'Please enter 6 digit',
              
        ];
    }
}
