<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreStateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        
        return [
            'country_id' => 'required',
            'state_name' => 'required|regex:/^[a-zA-Z]+$/u|max:100',
            'state_name_gj' =>'required|regex:/^[a-zA-Z]+$/u|max:100',
        ];


        
    }
    public function messages()
    {
        return [
            'country_id.required' => 'Country field is required',
            'state_name.required' => 'State name field is required',
            'state_name_gj.required' =>'State name gujarati field is required',
            'state_name_gj.regex'=>'State name gujarati format is invalid',
        ];
    }
}
