<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;

class DeceasedAddress extends Model
{ 
    use HasFactory, Notifiable;
    protected $table="deceased_address";


    public function deceased()
    {
        //first id should be relationship table and another id is dependent table 
        return $this->hasOne(Deceased::class ,'id', 'deceased_id');
    }

    protected $fillable=[
      "deceased_id",
      "address1",
      "address2",
      "address3",
      "city_id",
      "state_id",
      "area_id",
      "country_id",
      "pincode",  
    ];

}