<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
class Driver extends Model{
    use HasFactory, Notifiable;

    protected $table="smartpay_driver";
    protected $primaryKey  = 'SMART_DRIVERID';
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $timestamps = false;
    protected $fillable = [
        'FIRST_NAME',
        'LAST_NAME',
        'ADDRESS',
        'CITY',
        'STATE',
        'POSTAL',
        'COUNTRY',
        'DOB',
        'SSN_NUM',
        'DRIVER_EMAIL',
        'DRIVER_PHONE',
        'STATUS',
        'SUB_STATUS',
        'USERNAME',
        'PASSWORD',
        'CREATED_DATE',
        'CLIENT_ID',
        'MEM_ID',
        'cashAvailable',
        'pin_number',
    ];

     /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */

    public function estate()
    {
        //first id should be relationship table and another id is dependent table
        return $this->hasOne(estate::class ,'SMART_DRIVERID','estate_id');
    }

    public function city()
    {
        //first id should be relationship table and another id is dependent table
        return $this->hasOne(City::class ,'SMART_DRIVERID','city_id');
    }
    public function area()
    {
        //first id should be relationship table and another id is dependent table
        return $this->hasOne(Area::class ,'SMART_DRIVERID','area_id');
    }

    public function users()
    {
        return $this->belongsTo('App\Models\User', 'MEM_ID', 'id');
    }


}
