<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCommentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('comments', function (Blueprint $table) {
            $table->bigIncrements('cid');
            $table->integer('cpid');
            $table->tinyInteger('cuid');
            $table->string('cuname')->nullable();
            $table->string('cuemail')->nullable();
            $table->text('ccontent')->nullable();
            $table->tinyInteger('crating')->nullable();
            $table->bigInteger('cmodified');
            $table->string('ctype', '32');
            $table->ipAddress('ip')->nullable();
            $table->text('useragent')->nullable();
            $table->text('platformname')->nullable();
            $table->text('platformfamily')->nullable();
            $table->text('browserfamily')->nullable();
            $table->integer('cparent')->nullable();
            $table->tinyInteger('cstatus');
            $table->tinyInteger('spam_trash');
        });
    }



    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('comments');
    }
}
