@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{get_admin_url('/')}}">{{admin_lang('dashboard')}}</a></li>
            <li class="breadcrumb-item active"> <a href="{{ get_admin_url('bookmaster') }}">{{ $data['page_title'] }}</a></li>
        </ol>
    </div>
</div>
@if(session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
            @php session()->forget('success');@endphp
            
            @elseif(session()->has('failure'))
            <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>  
            @php session()->forget('failure');@endphp
        @endif
        
<form method="POST" action="{{ get_admin_url('bookmasterActions') }}" class="form-horizontal" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="action" value="{{$data['action']}}">
    <input type="hidden" name="query" value="action">
    <input type="hidden" name="id" value="{{$bookmaster->id}}">
    <div class="row">
        
         <div class="col-md-4">   
        <div class="form-group required">
         <label class="control-label">Book Number</label><br>
        <input type="number" name="book_no" id="book_no" class="form-control col-md-6" placeholder="bookmasterName" value="{{$bookmaster->book_no}}" >
        @if ($errors->has('book_no'))
                    <span class="text-danger">{{ $errors->first('book_no') }}</span>
                @endif        
        </div>
    </div>
       
    <div class="col-md-4">
         <div class="form-group required">
            <label class="control-label">Receipt Start</label><br>
                <input type="number" name="receipt_start" id="receipt_start" class="form-control col-md-6 " placeholder=""  value="{{$bookmaster->receipt_start}}" >  
                @if ($errors->has('receipt_start'))
                    <span class="text-danger">{{ $errors->first('receipt_start') }}</span>
                @endif      
            </div>
    </div>
    <div class="col-md-4">
         <div class="form-group required">
            <label class="control-label">Receipt End</label><br>
                <input type="number" name="receipt_end" id="receipt_end" class="form-control col-md-6 " placeholder=""  value="{{$bookmaster->receipt_end}}" >      
                @if ($errors->has('receipt_end'))
                    <span class="text-danger">{{ $errors->first('receipt_end') }}</span>
                @endif  
            </div>
    </div>

          
</div>

        <div class="form-group mt-2">
        <button type="submit" class="btn btn-primary"><span></span>Update</button>
        <a href="{{get_admin_url('bookmaster')}}" class="btn btn-danger"><span></span>Cancel</a>
    </div>
        </div>
          
</form>
@endsection