<table id="jq-table" class="table table-striped table-bordered mt-3">
    <thead>
        <tr>
            <th style="width: 15px;" class="text-center th-checkbox">#</th>
            <th class="hidden-phone">{{admin_lang('author')}}</th>
            <th style="width: 60%">{{admin_lang('comment')}}</th>
            <th style="width: 180px;" class="hidden-phone text-center">{{admin_lang('date')}}</th>
        </tr>
    </thead>
    <tbody>
        @foreach($data['loop_comments'] as $comment)
        <tr>
            <td class="td-checkbox">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" name="mark[]" value="{{ $comment->cid }}" id="select-{{ $comment->cid }}" />                                        
                    <label class="custom-control-label" for="select-{{ $comment->cid }}"></label>
                </div>
                @if($comment->cstatus)<span class="sq-post-status disable"></span>@else<span class="sq-post-status enable"></span>@endif
                <div>#{{$comment->cid}}</div>
            </td>
            <td>
                <div class="avatar2"><img src="@if($comment->cuid){{get_user_avatar($comment->cuid)}}@else{{get_user_avatar_username($comment->cuname)}}@endif" alt="@if($comment->cuid){{ get_username($comment->cuid) }}@else{{$comment->cuname}}@endif"></div>
                <ul class="tdul-list">
                    <li>
                        <h6>@if($comment->cuid)<a href="{{get_admin_url('profile/'.$comment->cuid)}}">{{ get_username($comment->cuid) }}</a>@else{{$comment->cuname}}@endif</h6>
                        <h6 class="mb-1"><a href="mailto:{{$comment->cuemail}}">{{$comment->cuemail}}</a></h6>
                    </li>
                    <li>
                        <small>
                            <a href="{{get_admin_url('comments/ip/'.$comment->ip)}}">{{$comment->ip}}</a> | 
                            <a href="{{get_admin_url('comments/platfrom/'.$comment->platformname)}}">{{$comment->platformname}}</a> | 
                            <a href="{{get_admin_url('comments/browser/'.$comment->browserfamily)}}">{{$comment->browserfamily}}</a>
                        </small>
                    </li>
                </ul>
            </td>
            <td>
                <h6>{!!get_post_title_from_comment($comment->cpid, $comment->ctype)!!}</h6>
                <p>{!! nl2br($comment->ccontent) !!}</p>
                <div class="row-actions">
                    <a href="{{ get_admin_url('editcomment/'.$comment->cid) }}">{{admin_lang('edit')}}</a> | 
                    @if($comment->cstatus)
                    <a href="{{ get_admin_url('disablecomment/'.$comment->cid) }}" class="red">{{admin_lang('unapproved')}}</a> |
                    @else
                    <a href="{{ get_admin_url('enablecomment/'.$comment->cid) }}" class="green">{{admin_lang('approve')}}</a> |
                    @endif
                    <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirm-delete" data-href="{{ get_admin_url('deletecomment/'.$comment->cid.'/'.csrf_token() ) }}" data-body="{{ admin_lang('delete_confirm') }} # {{ $comment->cid }}?" class="red">{{ admin_lang('delete') }}</a>
                </div>
            </td>
            <td class="hidden-phone text-center" dir="ltr">{{ time_format($comment->cmodified, 'date', 'd/m/Y') }}<br />{{ time_format($comment->cmodified, 'time') }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
{{$data['loop_comments']->links('dashboard.layouts.pagination')}}