         @php $estate_name = "";
         $city_name="";
         $area_name="";

         @endphp

         @if(session()->has('success'))
         <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
         @elseif(session()->has('failure'))
         <div class="alert alert-warning alert-dismissible fade show"><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('failure') }}</div>

         @endif

         @if(Auth::user()->userlevel == 'admin')
        <div class="col-md-12 align-right">
            <a href={{ get_admin_url('driveradd/admin_driver_add') }} class="btn btn-sm btn-primary float-end mb-2">{{admin_lang('add_new')}}</a>
            <a href="{{ get_admin_url('driveradd/admin_quick_driver_add') }}" style="margin-right: 3px;" class="btn btn-sm btn-primary">{{ admin_lang('quick_add') }}</a>
        </div>
        @else

        <div class="col-md-12 align-right">
             <a href="{{ get_admin_url('driveradd/quickAdd') }}" class="btn btn-sm btn-primary">{{ admin_lang('quick_add') }}</a>
             <a href="{{ $data['url_new'] }}" class="btn btn-sm btn-primary">{{admin_lang('add_new')}}</a>
        </div>
         @endif

         <table id="jq-table" class="table table-striped table-bordered drivertable mt-4">
             <thead>
                 <tr>
                     <th>First Name</th>
                     <th>Last Name</th>
                     <th>Card #</th>
                     <th><strong><b>Cash</b></strong></th>
                     <th>Phone</th>
                     <th>Status</th>
                     <th>Sub Status</th>
                     @if (Auth::user()->userlevel == 'admin')
                     <th>Company</th>
                     @endif
                     <th>Action</th>
                 </tr>
             </thead>
             <tbody>



                 @foreach($drivers as $key => $driver)
                 @php $estate = $driver->estate;
                 $city = $driver->city;
                 $area = $driver->area;

                 if(empty($estate))
                 $estate_name="";
                 else
                 $estate_name =$estate->estate_name;


                 if(empty($city))
                 $city_name = "";
                 else
                 $city_name =$city->city_name;


                 if(empty($area))
                 $area_name = "";
                 else
                 $area_name =$area->area_name;

                 @endphp


                 <tr>
                     <td>
                         <a href="{{get_admin_url('driver/'.$driver->SMART_DRIVERID )}}">{{ $driver->FIRST_NAME }}</a></strong>
                     </td>
                     <td>
                         {{ $driver->LAST_NAME }}
                     </td>
                     <td>
                         @if(!empty($driver->CARD_NUM))
                            @if(Auth::user()->userlevel == 'admin')
                                    {{ $driver->CARD_NUM }}
                            @else
                            {{ substr( $driver->CARD_NUM, 0, 6 )}}******{{ substr( $driver->CARD_NUM, -4 )}}
                            @endif
                         @endif
                     </td>
                     <td><strong><b>
                        $ {{ number_format($driver->cashAvailable,2) }}
                     </b></strong>
                    </td>
                     <td>
                         {{ $driver->DRIVER_PHONE }}
                     </td>
                     <td>
                         {{ $driver->STATUS == 1 ? "Active" : "InActive" }}
                     </td>
                     <td>
                         {{ $driver->SUB_STATUS }}
                     </td>
                     @if (Auth::user()->userlevel == 'admin')
                     <td>
                        {{ $driver->users->company_name }}
                     </td>
                     @endif
                     <td>
                    @if(Auth::user()->userlevel == 'admin' && $driver->SUB_STATUS == 'New Card Order')
                         <a href="{{get_admin_url('driver/'.$driver->SMART_DRIVERID.'/card_details')}}" class="green">Asign Card</a>
                         <a href="{{ route('driverDelete', $driver->SMART_DRIVERID) }}" class="red" onclick="return confirm('Are you sure you want to delete?')">| Delete</a>
                    @elseif(Auth::user()->userlevel == 'supervisor')
                         <a href="{{get_admin_url('driver/'.$driver->SMART_DRIVERID )}}" class="green">Edit </a>
                         @if(!empty(Auth::user()->contract_id && Auth::user()->ar_id && $driver->CARD_NUM))
                         <a href="{{get_admin_url('addLoadFunds/'.$driver->SMART_DRIVERID)}}" class="green">| Add Load Funds</a>
                         @endif
                         @if(empty($driver->CARD_NUM))
                         <a href="{{ route('driverDelete', $driver->SMART_DRIVERID) }}" class="red" onclick="return confirm('Are you sure you want to delete?')">| Delete</a>
                         @endif
                    @endif

                    </td>
                 </tr>

                 @endforeach

             </tbody>
         </table>
         {{$drivers->links('dashboard.layouts.pagination')}}
