@php
    $propertys = config('globalarray.PROPERTYTYPE');
@endphp
@extends('dashboard.layouts.master')
@section('content')
    <div class="page-title-box d-flex align-items-center justify-content-between">
        <h4 class="mb-0 font-size-18">{{ $data['page_title'] }}</h4>
        <div class="page-title-right">
            <ol class="breadcrumb m-0">
                <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
                <li class="breadcrumb-item active">{{ $data['page_title'] }}</li>
            </ol>
        </div>
    </div>
    @if (session()->has('success'))
        <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close"
                data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
        @php session()->forget('success');@endphp
    @endif
    <div class="row mb-3">
        <form method="GET" action="" class="form-filter">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-outline">
                        <label>Keyword</label><br>
                        <input type="search" id="search_text" name="s" class="form-control form-control-sm"
                            value="{{ request()->get('s') }}" placeholder="{{ admin_lang('search') }}">
                    </div>
                </div>
                @if (Auth::user()->userlevel == 'admin')
                    <div class="col-md-3">
                        <div class="form-outline">
                            <label class="control-label">Company</label><br>
                            <select name="company_name" id="company_name"
                                class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
                                <option value="">Select Company</option>
                                @foreach ($companies as $item)
                                    <option value="{{ $item->id }}"
                                        {{ $item->id == request()->get('company_name') ? 'selected' : '' }}>
                                        {{ $item->company_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif
                <div class="col-md-3">
                    <div class="form-outline">
                        <label class="control-label">Status</label><br>
                        <select name="driver_status" id="driver_status"
                            class="form-control custom-select form-select custom-select-sm form-control form-control-sm">
                            <option value="">Select Status</option>
                            <option value="1" {{ request()->get('driver_status') == '1' ? 'selected' : '' }}>Active
                            </option>
                            <option value="0" {{ request()->get('driver_status') == '0' ? 'selected' : '' }}>InActive
                            </option>
                        </select>
                    </div>
                </div>
                <div>
                    <!-- <div class="col-md-2"> -->
                    <div class="form-outline  mb-3">
                        <button type="submit" class="btn btn-sm btn-primary button-form-filter"
                            style="margin-top: 20px;">{{ admin_lang('search') }}</button>
                        <a href="{{ get_admin_url('driver') }}" class="btn btn-sm btn-primary button-form-filter"
                            style="margin-top: 20px;">Show All</a>
                        <!-- </div> -->
                    </div>
        </form>
    </div>

    <div class="card">
        <div class="card-body" id="ajax_driver">

        </div>
    </div>
    <script>
        $(document).ready(function() {


            var url = "ajaxlist_driver?page=1&s=" + $('#search_text').val() + "&company_name=" + $('#company_name')
                .val() + "&driver_status=" + $('#driver_status').val();
            var responsediv = "ajax_driver";
            loadtable(url, responsediv);

            $("#property_city").on("change", function() {
                var Id = $(this).val();
                url = "{{ get_admin_url('ajax_area') }}";
                params = {
                    id: Id
                };
                getlistajax(url, params, 'deceased_area_id');

            });

        });
    </script>
@endsection('content')
