@extends('dashboard.layouts.master')
@section('content')
    <style>
        .red {
            color: red;
        }
    </style>
    @action('admin_dashboard_before_counter')
    @if (Auth::user()->userlevel == 'supervisor')
        <div class="col-md-3 mb-3">
            <a href="{{ get_admin_url('driveradd/quickAdd') }}" class="btn btn-primary btn-sm">Quick Add</a>
        </div>
        <div class="row">
            @action('admin_dashboard_counter')
            @if (session()->has('success'))
                <div class="alert alert-success alert-dismissible fade show"><button type="button" class="btn-close"
                        data-bs-dismiss="alert" aria-label="Close"></button>{{ session()->get('success') }}</div>
                @php session()->forget('success');@endphp
            @endif
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Balance</p>
                                <h4
                                    class="mb-0 {{ Auth::user()->credit_available < Auth::user()->low_limit_threshold ? 'red' : '' }}">
                                    $ {{ number_format(get_balance(), 2) }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="{{ route('driver') }}" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Total Drivers</p>
                                <h4 class="mb-0">{{ get_driver_count() }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="{{ route('driver') }}" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium" style="margin-bottom: 5px;">Total Active Card</p>
                                <h4 class="mb-0">{{ get_card_count() }}</h4>
                                <p style="margin-bottom: 0px;">$ {{ sum_of_cash_available() }}</p>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium" style="margin-bottom: 5px;">Low Balance Alert</p>
                                <h4>$ {{ number_format(Auth::user()->low_limit_threshold, 2) }}</h4>
                                <form action="{{ route('low_limit_threshold', Auth::user()->id) }}" method="POST">
                                    @csrf
                                    <input type="text" class="mb-2" name="low_limit_threshold"
                                        value="{{ Auth::user()->low_limit_threshold ? Auth::user()->low_limit_threshold : '' }}"
                                        size="8" placeholder="Low Limit Threshold">
                                    <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                </form>
                            </div>
                            <!-- <div class="flex-shrink-0 align-self-center">
                                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                                    <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                                                </div>
                                            </div> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @elseif(Auth::user()->userlevel == 'admin')
        <div class="row">
            @action('admin_dashboard_counter')
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Balance</p>
                                <h4 class="mb-0">$ {{ get_sum_of_all_company_user() }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="{{ route('driver') }}" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Total Drivers</p>
                                <h4 class="mb-0">{{ get_admin_driver_count() }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="{{ route('driver') }}" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Total Active Cards</p>
                                <h4 class="mb-0">{{ get_admin_card_count() }} </h4>
                                <p style="margin-bottom: 0px;">$ {{ sum_of_admin_cash_available() }}</p>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <a href="{{ route('usercompanys') }}" class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Total Company</p>
                                <h4 class="mb-0">{{ get_company_count() }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    @else
        <div class="row">
            @action('admin_dashboard_counter')
            <div class="col-md-3">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">Cash Available</p>
                                <h4 class="mb-0">$ {{ number_format(getCardAvaCash($driver->SMART_DRIVERID), 2) }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-file font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 d-none hide">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">{{ admin_lang('administrator') }}</p>
                                <h4 class="mb-0">{{ get_user_level_count('admin') }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 d-none hide">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">{{ admin_lang('supervisor') }}</p>
                                <h4 class="mb-0">{{ get_user_level_count('supervisor') }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user-pin font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 d-none hide">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">{{ admin_lang('users') }}</p>
                                <h4 class="mb-0">{{ get_user_level_count('user') }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-user font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 d-none hide">
                <div class="card mini-stats-wid">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium">{{ admin_lang('media_library') }}</p>
                                <h4 class="mb-0">{{ get_media_count() }}</h4>
                            </div>
                            <div class="flex-shrink-0 align-self-center">
                                <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                    <span class="avatar-title"><i class="bx bx-camera font-size-24"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
    @action('admin_dashboard_after_counter')
    @if (Auth::user()->userlevel == 'admin' || Auth::user()->userlevel == 'supervisor')
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-sm-flex flex-wrap">
                            <h4 class="card-title mb-4">{{ admin_lang('total_active_cards') }}</h4>
                        </div>
                        <div class="col-md-2">
                            <form action="{{ route('index_dashboard') }}" method="GET">
                                <select name="past_year" id="past_year"
                                    class="form-control custom-select form-select custom-select-sm form-control form-control-sm mb-3"
                                    required>
                                    <option
                                        value="{{ date('Y') }}"{{ !request()->has('past_year') || request()->get('past_year') == date('Y') ? ' selected' : '' }}>
                                        {{ date('Y') }}</option>
                                    <?php
                                    $currentYear = date('Y');
                                    for ($i = $currentYear - 1; $i >= $currentYear - 3; $i--) {
                                        echo '<option value="' . $i . '"' . (request()->has('past_year') && request()->get('past_year') == $i ? ' selected' : '') . '>' . $i . '</option>';
                                    }
                                    ?>
                                </select>

                                <button type="submit" class="btn btn-primary btn-sm">{{ admin_lang('submit') }}</button>
                            </form>
                        </div>
                        <div id="stacked-column-chart" class="apex-charts" dir="ltr">

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="d-sm-flex flex-wrap">
                    <h4 class="card-title">Last Driver Add</h4>
                </div>
                <table id="jq-table" class="table table-striped table-bordered drivertable mt-4">
                    <thead>
                        <tr>
                            <th>First Name</th>
                            <th>Last Name</th>
                            <th>Card #</th>
                            <th><strong><b>Cash</b></strong></th>
                            <th>Phone</th>
                            <th>Status</th>
                            <th>Sub Status</th>
                            @if (Auth::user()->userlevel == 'admin')
                                <th>Company</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($drivers as $driver)
                            <tr>
                                <td>
                                    {{ $driver->FIRST_NAME }}
                                </td>
                                <td>
                                    {{ $driver->LAST_NAME }}
                                </td>
                                <td>
                                    @if (!empty($driver->CARD_NUM))
                                        @if (Auth::user()->userlevel == 'admin')
                                            {{ $driver->CARD_NUM }}
                                        @else
                                            {{ substr($driver->CARD_NUM, 0, 6) }}******{{ substr($driver->CARD_NUM, -4) }}
                                        @endif
                                    @endif
                                </td>
                                <td><strong><b>
                                            $ {{ number_format($driver->cashAvailable, 2) }}
                                        </b></strong>
                                </td>
                                <td>
                                    {{ $driver->DRIVER_PHONE }}
                                </td>
                                <td>
                                    {{ $driver->STATUS == 1 ? 'Active' : 'InActive' }}
                                </td>
                                <td>
                                    {{ $driver->SUB_STATUS }}
                                </td>
                                @if (Auth::user()->userlevel == 'admin')
                                    <td>
                                        {{ $driver->users->company_name }}
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="d-sm-flex flex-wrap">
                    <h4 class="card-title">Last Driver Fund Add</h4>
                </div>
                <table id="jq-table" class="table table-striped table-bordered drivertable mt-4">
                    <thead>
                        <tr>
                            <th>Driver Name</th>
                            <th>Amount</th>
                            <th>Issue To</th>
                            <th>Notes</th>
                            <th>Ref ID</th>
                            <th>Created Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($driver_fund as $driver)
                        <tr>
                            <td>
                               {{ $driver->drivers->USERNAME }}
                            </td>
                            <td>
                                $ {{ number_format($driver->amount, 2) }}
                            </td>
                            <td>
                                {{ $driver->issue_to }}
                            </td>
                            <td>
                                {{ $driver->notes }}
                            </td>
                            <td>
                               {{ $driver->ref_id }}
                           </td>
                           <td>
                               {{ date('m-d-Y', strtotime($driver->created_at)) }}
                           </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
@endsection
@section('script_code')
    <script type="text/javascript" src="{{ asset('dashboard/js/apexcharts.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('dashboard/js/echarts.min.js') }}"></script>
    <script>
        @if (Auth::user()->userlevel == 'admin' || Auth::user()->userlevel == 'supervisor')
            var options_visitors = {
                chart: {
                    height: 270,
                    type: "bar",
                    stacked: !0,
                    toolbar: {
                        show: !1
                    },
                    zoom: {
                        enabled: !0
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: !1,
                        columnWidth: "15%",
                        endingShape: "rounded"
                    }
                },
                dataLabels: {
                    enabled: !1
                },
                series: [{
                    name: "",
                    data: [
                        @foreach ($cards as $card)
                            "{{ $card['data'] }}",
                        @endforeach ()
                    ]
                }],
                xaxis: {
                    categories: [
                        @foreach ($cards as $card)
                            "{{ $card['name'] }}",
                        @endforeach ()
                    ]
                },
                colors: ["#556ee6"],
                legend: {
                    position: "bottom"
                },
                fill: {
                    opacity: 1
                }
            };
            chart_visitors = new ApexCharts(document.querySelector("#stacked-column-chart"), options_visitors);
            chart_visitors.render();
        @endif ()
    </script>
@endsection
