@extends('dashboard.layouts.master')
@section('content')
<div class="page-title-box d-flex align-items-center justify-content-between">
    <h4 class="mb-0 font-size-18">{{ $page_title }}</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ get_admin_url('/') }}">{{ admin_lang('dashboard') }}</a></li>
            <li class="breadcrumb-item active">{{ $page_title }}</li>
        </ol>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="email-leftbar card">
            <div class="mail-list">
                <a href="{{ get_admin_url('messages/appointments') }}" @if($list_class == 'appointments') class="active" @endif><i class="bx bx-calendar mr-2"></i> {{ admin_lang('appointments') }} {!! get_messages_html('appointments') !!}</a>
                <a href="{{ get_admin_url('messages/contactus') }}" @if($list_class == 'contactus') class="active" @endif><i class="bx bx-envelope mr-2"></i> {{ admin_lang('contactus') }} {!! get_messages_html('contactus') !!}</a>
            </div>
        </div>
        <div class="email-rightbar mb-3">
            <div class="card">
                <div class="card-body">
                    <div class="media mb-4">
                        <div class="media-body">
                            <h5 class="font-size-14 mt-1">{{get_post_meta_inarray($post_excerpts, 'username')}}</h5>
                            <span class="text-muted"><a href="mailto:{{get_post_meta_inarray($post_excerpts, 'email')}}"><i class="bx bx-envelope"></i> {{get_post_meta_inarray($post_excerpts, 'email')}}</a></span>
                            @if(get_post_meta_inarray($post_excerpts, 'phone')) | <span class="text-muted"><a href="tel:{{get_post_meta_inarray($post_excerpts, 'phone')}}"><i class="bx bx-mobile-alt"></i> {{get_post_meta_inarray($post_excerpts, 'phone')}}</a></span>@endif
                            @if(get_post_meta_inarray($post_excerpts, 'date') or get_post_meta_inarray($post_excerpts, 'time')) | <span class="text-muted"><i class="bx bx-calendar"></i> {{get_post_meta_inarray($post_excerpts, 'date')}} - {{get_post_meta_inarray($post_excerpts, 'time')}}</span>@endif
                            <div class="modified text-muted">{{ time_format($modified, 'date') }}<br />{{ time_format($modified, 'time') }}</div>
                        </div>
                    </div>
                    <hr />
                    <h4 class="mt-0 font-size-16">{{$post_title}}</h4>
                    <p>{!!$post_content!!}}</p>
                    <hr>
                   <div class="text-muted font-size-11">
                        @if(get_option_inarray($browser_detect, 'ip')){{get_option_inarray($browser_detect, 'ip')}}@endif
                        @if(get_option_inarray($browser_detect, 'platformname')) | {{get_option_inarray($browser_detect, 'platformname')}}@endif
                        @if(get_option_inarray($browser_detect, 'browserfamily')) | {{get_option_inarray($browser_detect, 'browserfamily')}}@endif
                    </div>
                    @if(get_option_inarray($browser_detect, 'useragent'))<div class="text-muted font-size-11">{{get_option_inarray($browser_detect, 'useragent')}}</div>@endif
                    <hr>
                    <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirm-delete" data-href="{{ get_admin_url('message/delete/'.$post_id.'/'.csrf_token()) }}" data-body="{{ admin_lang('delete_confirm') }}?" class="red">{{ admin_lang('delete') }}</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection