@extends('dashboard.layouts.master')
@section('content')
@include('dashboard.posts.boxs.box_page_head')
<form method="POST" action="{{ get_admin_url('PostSendForm') }}" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="post_type" value="{{$type}}">
    <input type="hidden" name="action" value="{{$action}}" />
    <input type="hidden" name="post_id" value="{{$post_id}}" />
    @include('dashboard.posts.boxs.box_publish_toolbar')
    @include('dashboard.posts.inputs.input_title')
    @include('dashboard.posts.inputs.input_postname')
    <div class="tacf-box-container">
        <div class="tacf-box-tabs nav-tabs-cookie" data-cookie="formpost_pages" data-cookie-tab="tab-details">
            <a href="#" class="active" data-tab=".tab-details"><i class="bx bx-pencil"></i> {{ admin_lang('details') }}</a>
            <a href="#" class="" data-tab=".tab-content"><i class="bx bx-file"></i> {{ admin_lang('content') }}</a>
            @if($action == 'update' and is_permission('comments'))<a href="#" class="" data-tab=".tab-comments"><i class="bx bx-comment-dots"></i> {{admin_lang('comments')}}</a>@endif
        </div>
        <div class="tacf-tabs-content">
            <div class="tacf-tab-content tab-details active">
                <div class="row">
                    <div class="col-md-9 border-right">
                        <div class="row">
                            <div class="col-md-4">
                                @include('dashboard.posts.inputs.input_comment_status')
                                <label>{{ admin_lang('details') }}</label>
                                <div>
                                    <input type="checkbox" name="postmeta[meta_author]" value="1" class="custom-control-input" switch="bool" id="meta_author_switch" @if(get_post_meta('meta_author', $post_id) or !$post_id) checked @endif>
                                    <label for="meta_author_switch" data-on-label="ON" data-off-label="OFF"><span>{{admin_lang('author')}}</span></label> 
                                </div>
                                <div>
                                    <input type="checkbox" name="postmeta[meta_date]" value="1" class="custom-control-input" switch="bool" id="meta_date_switch" @if(get_post_meta('meta_date', $post_id) or !$post_id) checked @endif>
                                    <label for="meta_date_switch" data-on-label="ON" data-off-label="OFF"><span>{{admin_lang('date')}}</span></label> 
                                </div>
                                <div>
                                    <input type="checkbox" name="postmeta[meta_comments]" value="1" class="custom-control-input" switch="bool" id="meta_comments_switch" @if(get_post_meta('meta_comments', $post_id) or !$post_id) checked @endif>
                                    <label for="meta_comments_switch" data-on-label="ON" data-off-label="OFF"><span>{{admin_lang('comments')}}</span></label> 
                                </div>
                                <div>
                                    <input type="checkbox" name="postmeta[meta_views]" value="1" class="custom-control-input" switch="bool" id="meta_views_switch" @if(get_post_meta('meta_views', $post_id) or !$post_id) checked @endif>
                                    <label for="meta_views_switch" data-on-label="ON" data-off-label="OFF"><span>{{admin_lang('views')}}</span></label> 
                                </div>                                
                                <div>
                                    <input type="checkbox" name="postmeta[meta_shareit]" value="1" class="custom-control-input" switch="bool" id="meta_shareit_switch" @if(get_post_meta('meta_shareit', $post_id) or !$post_id) checked @endif>
                                    <label for="meta_shareit_switch" data-on-label="ON" data-off-label="OFF"><span>{{admin_lang('share')}}</span></label> 
                                </div>                                
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>{{ admin_lang('style') }}</label>
                                    <select class="form-select" name="postmeta[page_style]">
                                        <option value="left_sidebar" @if(get_post_meta('page_style', $post_id) == 'left_sidebar') selected="" @endif>{{admin_lang('left_sidebar')}}</option>
                                        <option value="right_sidebar" @if(get_post_meta('page_style', $post_id) == 'right_sidebar') selected="" @endif>{{admin_lang('right_sidebar')}}</option>
                                        <option value="full" @if(get_post_meta('page_style', $post_id) == 'full') selected="" @endif>{{admin_lang('full_width')}}</option>
                                        <option value="fixed" @if(get_post_meta('page_style', $post_id) == 'fixed') selected="" @endif>{{admin_lang('centered')}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>{{ admin_lang('template') }}</label>
                                    <select class="form-select" name="postmeta[template]">
                                        <option value="default" @if(get_post_meta('template', $post_id) == 'default') selected="" @endif>{{admin_lang('default')}}</option>
                                        @action('admin_blade_action_page_template', get_post_meta('template', $post_id))
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-md-3">
                        @include('dashboard.posts.inputs.input_featuredimage')
                    </div>
                </div>
            </div>
            <div class="tacf-tab-content tab-content p-0">
                @include('dashboard.posts.inputs.input_content')
            </div>
            @if($action == 'update')
            <div class="tacf-tab-content tab-comments pl-3 pr-3 pb-3 pt-0">
                @include('dashboard.comments.index_loop_comments')
            </div>
            @endif
        </div>
    </div>
</form>
@if(get_option('content_editor') == 'articleeditor')
@include('dashboard.layouts.articleeditor')
@else
@include('dashboard.layouts.tinymce')
@endif
@endsection
@section('style_files')
<link href="{{ asset('libs/tacf/tacf.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script src="{{ asset('libs/tacf/tacf.min.js') }}"></script>
@endsection