@extends('dashboard.layouts.master')
@section('content')
@include('dashboard.posts.boxs.box_page_head')
<form method="POST" action="{{ get_admin_url('PostSendForm') }}" enctype="multipart/form-data">
    {{ csrf_field() }}
    <input type="hidden" name="post_type" value="{{$type}}">
    <input type="hidden" name="action" value="{{$action}}" />
    <input type="hidden" name="post_id" value="{{$post_id}}" />
    @include('dashboard.posts.boxs.box_publish_toolbar')
    <div class="tacf-box-container">
        <div class="tacf-box-tabs">
            <a href="#" class="active" data-tab=".tab-details"><i class="bx bx-pencil"></i> {{ admin_lang('details') }}</a>
        </div>
        <div class="tacf-tabs-content">
            <div class="tacf-tab-content tab-details active">
                <div class="row">
                    <div class="col-md-7 border-right">
                        <div class="row">
                            <div class="col-md-9">
                                <div class="form-group">
                                    <label>{{ admin_lang('title') }}</label>
                                    <input type="text" name="title" placeholder="{{ admin_lang('title') }}" value="{{$post_title}}" class="form-control" />
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">@include('dashboard.posts.inputs.input_orders')</div>
                            </div>
                        </div>
                        <div class="row align-items-center">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>{{extension_lang('pricings', 'price')}}</label>
                                    <input type="text" name="postmeta[price]" placeholder="{{extension_lang('pricings', 'price')}}" value="{{ $ex_data['price'] }}" class="form-control" />
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>{{extension_lang('pricings', 'payeach')}}</label>
                                    <input type="text" name="postmeta[payeach]" placeholder="{{extension_lang('pricings', 'payeach')}}" value="{{ $ex_data['payeach'] }}" class="form-control" />
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>{{extension_lang('pricings', 'priceold')}}</label>
                                    <input type="text" name="postmeta[priceold]" placeholder="{{extension_lang('pricings', 'priceold')}}" value="{{ $ex_data['priceold'] }}" class="form-control" />
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>{{extension_lang('pricings', 'currency')}}</label>
                                    <input type="text" name="postmeta[currency]" placeholder="{{extension_lang('pricings', 'currency')}}" value="{{ $ex_data['currency'] }}" class="form-control" />
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>{{extension_lang('pricings', 'background')}}</label>
                                    <input type="text" name="postmeta[bgcolor]" value="{{ $ex_data['bgcolor'] }}" class="form-control colorpicker" />
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>{{extension_lang('pricings', 'color')}}</label>
                                    <input type="text" name="postmeta[color]" value="{{ $ex_data['color'] }}" class="form-control colorpicker" />
                                </div>
                            </div>
                            <div class="col-md-6 pt-3">
                                <input type="checkbox" name="postmeta[regularly]" value="1" class="custom-control-input" switch="bool" id="regularly_switch" @if($ex_data['regularly']) checked @endif>
                                <label for="regularly_switch" data-on-label="ON" data-off-label="OFF"><span>{{extension_lang('pricings', 'regularly')}}</span></label> 
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <label>{{extension_lang('pricings', 'url')}}</label>
                                <input type="text" name="postmeta[url]" placeholder="{{extension_lang('pricings', 'url')}}" value="{{ $ex_data['url'] }}" class="form-control" />
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <label>{{extension_lang('pricings', 'featured')}}</label>
                        <div class="tacf-input m-0">
                            <div class="tacf-repeater">
                                <table class="tacf-table">
                                    <tbody class="tacf-ui-sortable">
                                        @if(count($ex_data['featured']))
                                        @php $key = 0; @endphp
                                        @foreach ($ex_data['featured'] as $featured)
                                        <tr class="tacf-row">
                                            <td class="tacf-field tacf-col-item">
                                                <h3 class="tacf-head-item">
                                                    <span class="tacf-title-item"><span>{!!$featured['title']!!}</span></span> 
                                                    <span class="tacf-row-handle tacf-action-handle order ui-sortable-handle" title="{{admin_lang('move')}}"><i class="bx bx-move"></i></span>
                                                    <span class="tacf-remove" data-event="remove-row" title="{{admin_lang('remove')}}"><i class="bx bxs-trash-alt"></i></span>
                                                    <span class="tacf-collapse-button">@if($featured['toggle'])<i class="fas fa-minus"></i>@else<i class="fas fa-plus"></i>@endif</span> 
                                                    <input type="hidden" class="tacf-toggle-input" name="featured[{{$key}}][toggle]" value="{{$featured['toggle']}}">
                                                </h3>
                                                <div class="tacf-input tacf-toggle-content" @if(!$featured['toggle'])style="display: none;"@endif>
                                                    <input type="text" name="featured[{{$key}}][title]" value="{{$featured['title']}}" class="form-control tacf_toggle_title" />
                                                </div>
                                            </td>
                                        </tr>
                                        @php $key++; @endphp
                                        @endforeach
                                        @endif
                                        <tr class="tacf-row tacf-clone">
                                            <td class="tacf-field tacf-col-item">
                                                <h3 class="tacf-head-item">
                                                    <span class="tacf-title-item"><span>{{extension_lang('pricings', 'featured')}}</span></span> 
                                                    <span class="tacf-row-handle tacf-action-handle order ui-sortable-handle" title="{{admin_lang('move')}}"><i class="bx bx-move"></i></span>
                                                    <span class="tacf-remove" data-event="remove-row" title="{{admin_lang('remove')}}"><i class="bx bxs-trash-alt"></i></span>
                                                    <span class="tacf-collapse-button"><i class="fas fa-minus"></i></span> 
                                                    <input type="hidden" class="tacf-input-key tacf-toggle-input" data-name="featured[{key}][toggle]" value="1">
                                                </h3>
                                                <div class="tacf-input tacf-toggle-content">
                                                    <input type="text" data-name="featured[{key}][title]" class="form-control tacf-input-key tacf_toggle_title" />
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <div class="tacf-actions tacf-actions-footer p-0 mt-2 pt-2">
                                    <a class="tacf-button button button-primary" href="#" data-event="add-row">{{admin_lang('add_new')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection
@section('style_files')
<link rel="stylesheet" href="{{ asset('libs/spectrum/spectrum.min.css') }}" type="text/css" />
<link href="{{ asset('libs/tacf/tacf.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('script_files')
<script src="{{ asset('libs/spectrum/spectrum.min.js') }}"></script>
<script src="{{ asset('libs/tacf/tacf.min.js') }}"></script>
<script>$(".colorpicker").spectrum({allowEmpty: false,showAlpha: false});</script>
@endsection